/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.CommonBundle;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.NewFileActionWithCategory;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/action/NewDockerfileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/ide/actions/NewFileActionWithCategory;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createDockerfile", "Lcom/intellij/psi/PsiFile;", "psiDir", "Lcom/intellij/psi/PsiDirectory;", "isAvailable", "", "getPsiDirectory", "getOffsetToPreserve", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "doCreate", "findChildDockerfile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "getCategory", "", "intellij.clouds.docker"})
public final class NewDockerfileAction
extends DumbAwareAction
implements NewFileActionWithCategory {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(this.isAvailable(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiDirectory psiDirectory = this.getPsiDirectory(e);
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory psiDir = psiDirectory;
        if (psiDir.isValid()) {
            PsiFile psiFile = this.createDockerfile(psiDir);
            if (psiFile == null) {
                return;
            }
            PsiFile dockerfile = psiFile;
            Project project = psiDir.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
            if (view != null && editor != null && Intrinsics.areEqual((Object)editor.getDocument(), (Object)PsiDocumentManager.getInstance((Project)project2).getDocument(dockerfile))) {
                int offset = this.getOffsetToPreserve(editor);
                view.selectElement((PsiElement)dockerfile);
                if (offset != -1 && !editor.isDisposed()) {
                    editor.getCaretModel().moveToOffset(offset);
                }
            }
        }
    }

    private final PsiFile createDockerfile(PsiDirectory psiDir) {
        Project project = psiDir.getProject();
        String string = CommonBundle.getErrorTitle();
        ElementCreator elementCreator2 = new ElementCreator(this, psiDir, project, string){
            final /* synthetic */ NewDockerfileAction this$0;
            final /* synthetic */ PsiDirectory $psiDir;
            {
                this.this$0 = $receiver;
                this.$psiDir = $psiDir;
                super($super_call_param$1, $super_call_param$2);
            }

            protected PsiElement[] create(String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                PsiFile psiFile = NewDockerfileAction.access$doCreate(this.this$0, this.$psiDir);
                if (psiFile == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                    return PsiElement.EMPTY_ARRAY;
                }
                PsiFile file = psiFile;
                PsiElement[] psiElementArray = new PsiElement[]{file};
                return psiElementArray;
            }

            protected String getActionName(String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                String string = DockerBundle.message((String)"action.NewDockerfile.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
        Object[] objectArray = elementCreator2.tryCreate("Dockerfile");
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"tryCreate(...)");
        Object[] elements = objectArray;
        return (PsiFile)ArraysKt.firstOrNull((Object[])elements);
    }

    private final boolean isAvailable(AnActionEvent e) {
        if (PlatformUtils.isRider()) {
            return false;
        }
        PsiDirectory psiDir = this.getPsiDirectory(e);
        if (psiDir != null && psiDir.isValid()) {
            VirtualFile virtualFile = psiDir.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            VirtualFile virtualDir = virtualFile;
            return virtualDir.isValid() && virtualDir.isDirectory() && this.findChildDockerfile(virtualDir) == null;
        }
        return false;
    }

    private final PsiDirectory getPsiDirectory(AnActionEvent e) {
        PsiDirectory[] directories;
        PsiDirectory[] view;
        PsiDirectory[] psiDirectoryArray = view = (PsiDirectory[])e.getData(LangDataKeys.IDE_VIEW);
        if (view == null || (psiDirectoryArray = psiDirectoryArray.getDirectories()) == null) {
            psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
        }
        return (directories = psiDirectoryArray).length == 1 ? directories[0] : null;
    }

    private final int getOffsetToPreserve(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        return offset == 0 ? -1 : offset;
    }

    private final PsiFile doCreate(PsiDirectory psiDir) {
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)psiDir.getProject());
        FileTemplate fileTemplate = fileTemplateManager.getInternalTemplate("Dockerfile");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInternalTemplate(...)");
        FileTemplate template = fileTemplate;
        return CreateFileFromTemplateAction.createFileFromTemplate((String)"Dockerfile", (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)true, (Map)MapsKt.emptyMap());
    }

    private final VirtualFile findChildDockerfile(VirtualFile dir) {
        VirtualFile dockerfile;
        if (dir.isValid() && (dockerfile = dir.findChild("Dockerfile")) != null && dockerfile.isValid() && !dockerfile.isDirectory()) {
            return dockerfile;
        }
        return null;
    }

    @NotNull
    public String getCategory() {
        return "Deployment";
    }

    public static final /* synthetic */ PsiFile access$doCreate(NewDockerfileAction $this, PsiDirectory psiDir) {
        return $this.doCreate(psiDir);
    }
}

