/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.agent.registry.model.DockerRegistry;
import com.intellij.docker.agent.registry.model.DockerRegistryKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.PushImageDialogKt;
import com.intellij.docker.registry.RegistrySelectionEditor;
import com.intellij.docker.registry.UniqueElementsComboBoxModel;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.docker.view.registry.DockerRegistryProvider;
import com.intellij.docker.view.registry.node.DockerNamespaceNode;
import com.intellij.docker.view.registry.node.DockerRepositoryNode;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0013\u001a0\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00030\u0003 \u0015*\u0017\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u0017\u00a2\u0006\u0002\b\u00160\u0014\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/docker/registry/PushImageDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "registry", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "imageBody", "", "imageTag", "model", "Lcom/intellij/docker/registry/DockerRepositoryModel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/registry/DockerRegistryConfiguration;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/docker/registry/DockerRepositoryModel;Lcom/intellij/openapi/project/Project;)V", "myNamespacesModel", "Lcom/intellij/ui/MutableCollectionComboBoxModel;", "", "myImagesModel", "Lcom/intellij/docker/registry/UniqueElementsComboBoxModel;", "myTagsModel", "myPushableRegistries", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Unmodifiable;", "", "myRegistrySelectionEditor", "Lcom/intellij/docker/registry/RegistrySelectionEditor;", "myWaitForNamespaces", "", "myWaitForImages", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "MyListCellRenderer", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nPushImageDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PushImageDialog.kt\ncom/intellij/docker/registry/PushImageDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n1#2:386\n*E\n"})
final class PushImageDialog
extends DialogWrapper {
    @NotNull
    private final String imageBody;
    @NotNull
    private final DockerRepositoryModel model;
    @NotNull
    private final Project project;
    @NotNull
    private final MutableCollectionComboBoxModel<Object> myNamespacesModel;
    @NotNull
    private final UniqueElementsComboBoxModel<String> myImagesModel;
    @NotNull
    private final UniqueElementsComboBoxModel<String> myTagsModel;
    private final List<DockerRegistryConfiguration> myPushableRegistries;
    @NotNull
    private final RegistrySelectionEditor myRegistrySelectionEditor;
    private volatile boolean myWaitForNamespaces;
    private volatile boolean myWaitForImages;

    public PushImageDialog(@Nullable DockerRegistryConfiguration registry, @NotNull String imageBody, @NotNull String imageTag, @NotNull DockerRepositoryModel model, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)imageBody, (String)"imageBody");
        Intrinsics.checkNotNullParameter((Object)imageTag, (String)"imageTag");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false);
        this.imageBody = imageBody;
        this.model = model;
        this.project = project;
        this.myNamespacesModel = new MutableCollectionComboBoxModel();
        this.myImagesModel = new UniqueElementsComboBoxModel();
        this.myTagsModel = new UniqueElementsComboBoxModel();
        List<DockerRegistryConfiguration> list2 = this.myPushableRegistries = DockerRegistryManager.getInstance().getRegistries();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"myPushableRegistries");
        this.myRegistrySelectionEditor = new RegistrySelectionEditor(list2, registry);
        this.init();
        this.setTitle(DockerBundle.message((String)"configurable.PushImageConfigurable.display.name", (Object[])new Object[0]));
        this.myTagsModel.addItem(imageTag);
        if (registry == null) {
            this.myImagesModel.addItem(this.imageBody);
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> PushImageDialog.createCenterPanel$lambda$14(this, arg_0));
    }

    protected void doOKAction() {
        Object object;
        DockerRegistryConfiguration selectedRegistry = this.myRegistrySelectionEditor.getSelectedAccount();
        Object object2 = this.myNamespacesModel.getSelected();
        if (object2 != null) {
            Object it = object2;
            boolean bl = false;
            object = it instanceof DockerNamespaceNode ? (DockerNamespaceNode)it : null;
            if (object == null || (object = ((DockerNamespaceNode)object).getNamespace()) == null || (object = DockerRegistryKt.getFullPath((DockerRegistry.Namespace)object)) == null) {
                object = it.toString();
            }
        } else {
            object = null;
        }
        DockerNamespaceNode namespace = object;
        String repository = (String)this.myImagesModel.getSelected();
        if (StringUtil.isEmpty((String)repository)) {
            throw new ConfigurationException(DockerBundle.message((String)"PushImageConfigurable.error.repository.required", (Object[])new Object[0]));
        }
        String tag = (String)this.myTagsModel.getSelected();
        this.model.setNamespace((String)((Object)namespace));
        this.model.setRegistry(selectedRegistry);
        this.model.setRepository(repository);
        this.model.setTag(tag);
        this.project.putUserData(PushImageDialogKt.access$getLAST_SELECTED_REGISTRY_CONFIG_KEY$p(), (Object)selectedRegistry);
        super.doOKAction();
    }

    private static final void createCenterPanel$lambda$14$onRegistryChanged(PushImageDialog this$0, Ref.ObjectRef<ComboBox<Object>> namespacesComboBox) {
        DockerRegistryConfiguration dockerRegistryConfiguration = this$0.myRegistrySelectionEditor.getSelectedAccount();
        if (dockerRegistryConfiguration == null) {
            return;
        }
        DockerRegistryConfiguration registryConfiguration = dockerRegistryConfiguration;
        this$0.myNamespacesModel.removeAll();
        this$0.myImagesModel.removeAll();
        DockerRegistryProvider provider = DockerRegistryProvider.Companion.getProvider(registryConfiguration);
        ComboBox comboBox = (ComboBox)namespacesComboBox.element;
        if (comboBox != null) {
            comboBox.setEditable(false);
        }
        this$0.myWaitForNamespaces = true;
        InternalUtilsKt.exceptionallyAsyncOnEdt(InternalUtilsKt.thenApplyAsyncOnEdt(provider.getNamespacesFor(registryConfiguration), (Function1)new Function1(namespacesComboBox, this$0){
            final /* synthetic */ Ref.ObjectRef<ComboBox<Object>> $namespacesComboBox;
            final /* synthetic */ PushImageDialog this$0;
            {
                this.$namespacesComboBox = $namespacesComboBox;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final Void invoke(List<DockerNamespaceNode> result2) {
                Intrinsics.checkNotNullParameter(result2, (String)"result");
                DockerNamespaceNode namespaceToSelect = null;
                if (result2.isEmpty()) {
                    ComboBox comboBox = (ComboBox)this.$namespacesComboBox.element;
                    if (comboBox != null) {
                        comboBox.setEditable(true);
                    }
                } else {
                    void $this$forEach$iv;
                    Iterable iterable = result2;
                    PushImageDialog pushImageDialog = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DockerNamespaceNode namespaceNode = (DockerNamespaceNode)element$iv;
                        boolean bl = false;
                        if (StringsKt.startsWith$default((String)PushImageDialog.access$getImageBody$p(pushImageDialog), (String)namespaceNode.getNamespace().getName(), (boolean)false, (int)2, null)) {
                            namespaceToSelect = namespaceNode;
                            PushImageDialog.access$getMyImagesModel$p(pushImageDialog).addItem(StringsKt.removePrefix((String)PushImageDialog.access$getImageBody$p(pushImageDialog), (CharSequence)(namespaceNode.getNamespace().getName() + "/")));
                        }
                        PushImageDialog.access$getMyNamespacesModel$p(pushImageDialog).addItem((Object)namespaceNode);
                    }
                }
                if (namespaceToSelect != null) {
                    PushImageDialog.access$getMyNamespacesModel$p(this.this$0).setSelectedItem(namespaceToSelect);
                } else {
                    PushImageDialog.access$getMyImagesModel$p(this.this$0).addItem(PushImageDialog.access$getImageBody$p(this.this$0));
                }
                PushImageDialog.access$setMyWaitForNamespaces$p(this.this$0, false);
                this.this$0.pack();
                return null;
            }
        }), (Function1)new Function1(this$0, namespacesComboBox){
            final /* synthetic */ PushImageDialog this$0;
            final /* synthetic */ Ref.ObjectRef<ComboBox<Object>> $namespacesComboBox;
            {
                this.this$0 = $receiver;
                this.$namespacesComboBox = $namespacesComboBox;
            }

            public final Void invoke(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PushImageDialog.access$getMyImagesModel$p(this.this$0).addItem(PushImageDialog.access$getImageBody$p(this.this$0));
                ComboBox comboBox = (ComboBox)this.$namespacesComboBox.element;
                if (comboBox != null) {
                    comboBox.setEditable(true);
                }
                PushImageDialog.access$setMyWaitForNamespaces$p(this.this$0, false);
                return null;
            }
        });
    }

    private static final Boolean createCenterPanel$lambda$14$lambda$6$lambda$1(PushImageDialog this$0) {
        return this$0.myWaitForNamespaces;
    }

    private static final String createCenterPanel$lambda$14$lambda$6$lambda$2(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it instanceof DockerNamespaceNode ? (DockerNamespaceNode)it : null;
        if (object == null || (object = ((DockerNamespaceNode)object).getNamespace()) == null || (object = DockerRegistryKt.getFullPath((DockerRegistry.Namespace)object)) == null) {
            object = it.toString();
        }
        return object;
    }

    private static final String createCenterPanel$lambda$14$lambda$6$lambda$5$lambda$3(Object it) {
        Object object = it instanceof DockerNamespaceNode ? (DockerNamespaceNode)it : null;
        if (object == null || (object = ((DockerNamespaceNode)object).getNamespace()) == null || (object = DockerRegistryKt.getFullPath((DockerRegistry.Namespace)object)) == null) {
            object = it.toString();
        }
        return object;
    }

    private static final void createCenterPanel$lambda$14$lambda$6$lambda$5$lambda$4(PushImageDialog this$0, Ref.ObjectRef $imageComboBox, ActionEvent it) {
        DockerNamespaceNode node;
        Object object = this$0.myNamespacesModel.getSelectedItem();
        DockerNamespaceNode dockerNamespaceNode = node = object instanceof DockerNamespaceNode ? (DockerNamespaceNode)object : null;
        if (node != null) {
            String lastSelected = (String)this$0.myImagesModel.getSelected();
            this$0.myImagesModel.removeAll();
            if (lastSelected != null) {
                this$0.myImagesModel.addItem(lastSelected);
                this$0.myImagesModel.setSelectedItem(lastSelected);
            }
            ComboBox comboBox = (ComboBox)$imageComboBox.element;
            if (comboBox != null) {
                comboBox.setEditable(false);
            }
            this$0.myWaitForImages = true;
            InternalUtilsKt.exceptionallyAsyncOnEdt(InternalUtilsKt.thenApplyAsyncOnEdt(node.getRepositoryNodesPromise(), (Function1)new Function1((Ref.ObjectRef<ComboBox<String>>)$imageComboBox, this$0){
                final /* synthetic */ Ref.ObjectRef<ComboBox<String>> $imageComboBox;
                final /* synthetic */ PushImageDialog this$0;
                {
                    this.$imageComboBox = $imageComboBox;
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public final Void invoke(List<DockerRepositoryNode> result2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter(result2, (String)"result");
                    Iterable iterable = result2;
                    PushImageDialog pushImageDialog = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DockerRepositoryNode repositoryNode = (DockerRepositoryNode)element$iv;
                        boolean bl = false;
                        String name = repositoryNode.getRepository().getName();
                        PushImageDialog.access$getMyImagesModel$p(pushImageDialog).addItem(name);
                    }
                    ComboBox comboBox = (ComboBox)this.$imageComboBox.element;
                    if (comboBox != null) {
                        comboBox.setEditable(true);
                    }
                    PushImageDialog.access$setMyWaitForImages$p(this.this$0, false);
                    this.this$0.pack();
                    return null;
                }
            }), (Function1)new Function1((Ref.ObjectRef<ComboBox<String>>)$imageComboBox, this$0){
                final /* synthetic */ Ref.ObjectRef<ComboBox<String>> $imageComboBox;
                final /* synthetic */ PushImageDialog this$0;
                {
                    this.$imageComboBox = $imageComboBox;
                    this.this$0 = $receiver;
                }

                public final Void invoke(Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ComboBox comboBox = (ComboBox)this.$imageComboBox.element;
                    if (comboBox != null) {
                        comboBox.setEditable(true);
                    }
                    PushImageDialog.access$setMyWaitForImages$p(this.this$0, false);
                    return null;
                }
            });
        }
    }

    private static final Unit createCenterPanel$lambda$14$lambda$6$lambda$5(PushImageDialog this$0, Ref.ObjectRef $imageComboBox, ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setEditable(true);
        ComboboxSpeedSearch.installSpeedSearch((JComboBox)((JComboBox)$this$applyToComponent), PushImageDialog::createCenterPanel$lambda$14$lambda$6$lambda$5$lambda$3);
        ClientProperty.put((JComponent)((JComponent)$this$applyToComponent), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        $this$applyToComponent.addActionListener(arg_0 -> PushImageDialog.createCenterPanel$lambda$14$lambda$6$lambda$5$lambda$4(this$0, $imageComboBox, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14$lambda$6(Ref.ObjectRef $namespacesComboBox, PushImageDialog this$0, Ref.ObjectRef $imageComboBox, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $namespacesComboBox.element = $this$row.comboBox((ComboBoxModel)this$0.myNamespacesModel, (ListCellRenderer)((Object)new MyListCellRenderer<Object>(() -> PushImageDialog.createCenterPanel$lambda$14$lambda$6$lambda$1(this$0), PushImageDialog::createCenterPanel$lambda$14$lambda$6$lambda$2))).align(Align.FILL).applyToComponent(arg_0 -> PushImageDialog.createCenterPanel$lambda$14$lambda$6$lambda$5(this$0, $imageComboBox, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Boolean createCenterPanel$lambda$14$lambda$11$lambda$7(PushImageDialog this$0) {
        return this$0.myWaitForImages;
    }

    private static final String createCenterPanel$lambda$14$lambda$11$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final void createCenterPanel$lambda$14$lambda$11$lambda$10$onImageChanged(PushImageDialog this$0) {
        String lastSelected = (String)this$0.myTagsModel.getSelected();
        this$0.myTagsModel.removeAll();
        if (lastSelected != null) {
            this$0.myTagsModel.addItem(lastSelected);
        }
    }

    private static final void createCenterPanel$lambda$14$lambda$11$lambda$10$lambda$9(PushImageDialog this$0, ActionEvent it) {
        PushImageDialog.createCenterPanel$lambda$14$lambda$11$lambda$10$onImageChanged(this$0);
    }

    private static final Unit createCenterPanel$lambda$14$lambda$11$lambda$10(PushImageDialog this$0, ComboBox $this$applyToComponent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
            $this$applyToComponent.setEditable(true);
            ClientProperty.put((JComponent)((JComponent)$this$applyToComponent), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
            Component component2 = $this$applyToComponent.getEditor().getEditorComponent();
            JTextComponent imageEditor = component2 instanceof JTextComponent ? (JTextComponent)component2 : null;
            $this$applyToComponent.addActionListener(arg_0 -> PushImageDialog.createCenterPanel$lambda$14$lambda$11$lambda$10$lambda$9(this$0, arg_0));
            Object object = imageEditor;
            if (object == null || (object = ((JTextComponent)object).getDocument()) == null) break block0;
            object.addDocumentListener((DocumentListener)new DocumentAdapter(this$0){
                final /* synthetic */ PushImageDialog this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    PushImageDialog.access$createCenterPanel$lambda$14$lambda$11$lambda$10$onImageChanged(this.this$0);
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14$lambda$11(Ref.ObjectRef $imageComboBox, PushImageDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $imageComboBox.element = $this$row.comboBox((ComboBoxModel)((Object)this$0.myImagesModel), (ListCellRenderer)((Object)new MyListCellRenderer<String>(() -> PushImageDialog.createCenterPanel$lambda$14$lambda$11$lambda$7(this$0), PushImageDialog::createCenterPanel$lambda$14$lambda$11$lambda$8))).align(Align.FILL).applyToComponent(arg_0 -> PushImageDialog.createCenterPanel$lambda$14$lambda$11$lambda$10(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14$lambda$13$lambda$12(ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setEditable(true);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14$lambda$13(PushImageDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)((Object)this$0.myTagsModel)), null, (int)2, null).align(Align.FILL).applyToComponent(PushImageDialog::createCenterPanel$lambda$14$lambda$13$lambda$12);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$14(PushImageDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Ref.ObjectRef namespacesComboBox = new Ref.ObjectRef();
        RegistrySelectionEditor $this$createCenterPanel_u24lambda_u2414_u24lambda_u240 = this$0.myRegistrySelectionEditor;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u2414_u24lambda_u240.setAccountSelectionListener(() -> PushImageDialog.createCenterPanel$lambda$14$onRegistryChanged(this$0, namespacesComboBox));
        $this$createCenterPanel_u24lambda_u2414_u24lambda_u240.addRegistrySelectionEditor($this$panel, this$0.project);
        Ref.ObjectRef imageComboBox = new Ref.ObjectRef();
        String string = DockerBundle.message((String)"configurable.PushImageConfigurable.namespace.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> PushImageDialog.createCenterPanel$lambda$14$lambda$6(namespacesComboBox, this$0, imageComboBox, arg_0));
        String string2 = DockerBundle.message((String)"configurable.PushImageConfigurable.repository.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> PushImageDialog.createCenterPanel$lambda$14$lambda$11(imageComboBox, this$0, arg_0));
        String string3 = DockerBundle.message((String)"configurable.PushImageConfigurable.tag.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> PushImageDialog.createCenterPanel$lambda$14$lambda$13(this$0, arg_0));
        PushImageDialog.createCenterPanel$lambda$14$onRegistryChanged(this$0, (Ref.ObjectRef<ComboBox<Object>>)namespacesComboBox);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableCollectionComboBoxModel access$getMyNamespacesModel$p(PushImageDialog $this) {
        return $this.myNamespacesModel;
    }

    public static final /* synthetic */ UniqueElementsComboBoxModel access$getMyImagesModel$p(PushImageDialog $this) {
        return $this.myImagesModel;
    }

    public static final /* synthetic */ String access$getImageBody$p(PushImageDialog $this) {
        return $this.imageBody;
    }

    public static final /* synthetic */ void access$setMyWaitForNamespaces$p(PushImageDialog $this, boolean bl) {
        $this.myWaitForNamespaces = bl;
    }

    public static final /* synthetic */ void access$setMyWaitForImages$p(PushImageDialog $this, boolean bl) {
        $this.myWaitForImages = bl;
    }

    public static final /* synthetic */ void access$createCenterPanel$lambda$14$lambda$11$lambda$10$onImageChanged(PushImageDialog this$0) {
        PushImageDialog.createCenterPanel$lambda$14$lambda$11$lambda$10$onImageChanged(this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B.\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJD\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000f2\r\u0010\u0010\u001a\t\u0018\u00018\u0000\u00a2\u0006\u0002\b\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0014\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/registry/PushImageDialog$MyListCellRenderer;", "V", "Lcom/intellij/ui/ColoredListCellRenderer;", "waitingForData", "Ljava/util/function/Supplier;", "", "toString", "Ljava/util/function/Function;", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/util/function/Supplier;Ljava/util/function/Function;)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "hasFocus", "(Ljavax/swing/JList;Ljava/lang/Object;IZZ)V", "intellij.clouds.docker"})
    private static final class MyListCellRenderer<V>
    extends ColoredListCellRenderer<V> {
        @NotNull
        private final Supplier<Boolean> waitingForData;
        @NotNull
        private final Function<V, String> toString;

        public MyListCellRenderer(@NotNull Supplier<Boolean> waitingForData, @NotNull Function<V, String> toString) {
            Intrinsics.checkNotNullParameter(waitingForData, (String)"waitingForData");
            Intrinsics.checkNotNullParameter(toString, (String)"toString");
            this.waitingForData = waitingForData;
            this.toString = toString;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends V> list2, @Nullable V value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (value != null) {
                this.append(this.toString.apply(value));
            }
            this.setIcon(this.waitingForData.get() != false ? (Icon)AnimatedIcon.Default.INSTANCE : null);
        }
    }
}

