/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerComposeDownOptions;
import com.intellij.docker.DockerComposeDownOptionsImpl;
import com.intellij.docker.DockerComposeStatus;
import com.intellij.docker.DockerStatus;
import com.intellij.docker.DockerTransitionStatus;
import com.intellij.docker.agent.cli.compose.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.agent.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.agent.compose.cli.DockerComposeRestartCliBuilder;
import com.intellij.docker.agent.compose.cli.DockerComposeStartCliBuilder;
import com.intellij.docker.agent.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.agent.terminal.pipe.DockerBasePipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.agent.util.ComposeVersion;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeCliExecutor;
import com.intellij.docker.runtimes.ComposePresentableDelegate;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntimeKt;
import com.intellij.docker.runtimes.ComposeServiceStatus;
import com.intellij.docker.runtimes.DockerDeferredRuntime;
import com.intellij.docker.runtimes.DockerNetworkRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeDetailsProvider;
import com.intellij.docker.runtimes.DockerRuntimeNavigatable;
import com.intellij.docker.runtimes.DockerRuntimeVirtualFileNavigatable;
import com.intellij.docker.runtimes.deploy.DockerComposeDeployer;
import com.intellij.docker.runtimes.deploy.DockerDeployer;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldKt;
import com.intellij.docker.ui.utils.DockerIconUtilsKt;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.docker.view.DockerRuntimeServiceViewContributorKt;
import com.intellij.docker.view.details.DockerLoggingHandlerTab;
import com.intellij.docker.view.details.DockerTabManager;
import com.intellij.docker.view.details.compose.DockerComposeProjectDashboardTab;
import com.intellij.execution.services.ServiceViewItemState;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 `2\u00020\u00012\u00020\u0002:\u0001`B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0010\u00a2\u0006\u0002\b6J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u001fH\u0016J\b\u0010=\u001a\u00020\u000fH\u0014J>\u0010>\u001a\u00020?2\n\u0010@\u001a\u0006\u0012\u0002\b\u00030A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u001b2\u0014\b\u0002\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060DH\u0081@\u00a2\u0006\u0004\bE\u0010FJ\u0006\u0010G\u001a\u00020?J\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u001fJ\u0006\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020KJ\u0006\u0010M\u001a\u00020KJ\b\u0010N\u001a\u00020KH\u0002J\u0006\u0010O\u001a\u00020KJ\u000e\u0010P\u001a\u00020?H\u0086@\u00a2\u0006\u0002\u0010QJ\u000e\u0010R\u001a\u00020?H\u0086@\u00a2\u0006\u0002\u0010QJ\u001a\u0010S\u001a\u00020?2\n\b\u0002\u0010T\u001a\u0004\u0018\u00010UH\u0086@\u00a2\u0006\u0002\u0010VJ\u000e\u0010W\u001a\u00020?H\u0086@\u00a2\u0006\u0002\u0010QJ\u0012\u0010X\u001a\u0004\u0018\u00010 2\b\b\u0001\u0010Y\u001a\u00020\u0006J\u0012\u0010Z\u001a\u00020[2\b\u0010T\u001a\u0004\u0018\u00010UH\u0002J\r\u0010\\\u001a\u00020?H\u0000\u00a2\u0006\u0002\b]J\b\u0010^\u001a\u00020\u000fH\u0002J\u000e\u0010_\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\fR\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"R\u0014\u0010&\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\fR\u0014\u0010(\u001a\u00020)X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001d\u0010,\u001a\u0004\u0018\u00010-8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/\u00a8\u0006a"}, d2={"Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;", "Lcom/intellij/docker/runtimes/DockerRuntimeBase;", "Lcom/intellij/docker/runtimes/DockerParentRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "composeProjectName", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "getComposeProjectName", "()Ljava/lang/String;", "myStatus", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/intellij/docker/DockerStatus;", "deployer", "Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer;", "getDeployer", "()Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer;", "executor", "Lcom/intellij/docker/runtimes/ComposeCliExecutor;", "getExecutor", "()Lcom/intellij/docker/runtimes/ComposeCliExecutor;", "workDirectory", "getWorkDirectory", "loggingPipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "getLoggingPipe", "()Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "serviceRuntimes", "", "Lcom/intellij/docker/runtimes/ComposeServiceRuntime;", "getServiceRuntimes", "()Ljava/util/List;", "networks", "Lcom/intellij/docker/runtimes/DockerNetworkRuntime;", "getNetworks", "presentableName", "getPresentableName", "detailsProvider", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "getDetailsProvider$intellij_clouds_docker", "()Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "runtimeNavigatable", "Lcom/intellij/docker/runtimes/DockerRuntimeNavigatable;", "getRuntimeNavigatable", "()Lcom/intellij/docker/runtimes/DockerRuntimeNavigatable;", "runtimeNavigatable$delegate", "Lkotlin/Lazy;", "getHeaderComponent", "Lcom/intellij/docker/ui/scaffold/Scaffold$SimpleSegment;", "scaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "getHeaderComponent$intellij_clouds_docker", "getNodePresentation", "Lcom/intellij/ide/projectView/PresentationData;", "state", "Lcom/intellij/execution/services/ServiceViewItemState;", "getChildren", "Lcom/intellij/docker/runtimes/DockerRuntime;", "doGetStatus", "executeCli", "", "cliBuilder", "Lcom/intellij/docker/agent/cli/compose/AbstractDockerComposeCmdCliBuilder;", "pipe", "additionalEnvs", "", "executeCli$intellij_clouds_docker", "(Lcom/intellij/docker/agent/cli/compose/AbstractDockerComposeCmdCliBuilder;Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelCurrentProcess", "getComposeFiles", "Ljava/nio/file/Path;", "isValidRuntime", "", "isAllServicesWithoutContainers", "isAllServicesRunning", "isAllServicesStopped", "isAnyServiceRunning", "startAllServices", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopAllServices", "down", "downOptions", "Lcom/intellij/docker/DockerComposeDownOptions;", "(Lcom/intellij/docker/DockerComposeDownOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restartAllRunningServices", "findService", "serviceName", "downCommand", "Lcom/intellij/docker/agent/compose/cli/DockerComposeDownCliBuilder;", "updateStatus", "updateStatus$intellij_clouds_docker", "createStatus", "getServicesWithContainers", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nComposeApplicationRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeApplicationRuntime.kt\ncom/intellij/docker/runtimes/ComposeApplicationRuntime\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n774#2:282\n865#2,2:283\n1374#2:285\n1460#2,5:286\n1740#2,3:291\n1740#2,3:294\n2746#2,3:297\n1761#2,3:300\n774#2:303\n865#2,2:304\n1563#2:306\n1634#2,3:307\n2746#2,3:315\n1761#2,3:318\n1761#2,3:321\n774#2:324\n865#2,2:325\n1788#2,4:327\n37#3:310\n36#3,3:311\n1#4:314\n*S KotlinDebug\n*F\n+ 1 ComposeApplicationRuntime.kt\ncom/intellij/docker/runtimes/ComposeApplicationRuntime\n*L\n62#1:282\n62#1:283,2\n197#1:285\n197#1:286,5\n201#1:291,3\n203#1:294,3\n205#1:297,3\n207#1:300,3\n232#1:303\n232#1:304,2\n234#1:306\n234#1:307,3\n264#1:315,3\n270#1:318,3\n273#1:321,3\n280#1:324\n280#1:325,2\n97#1:327,4\n234#1:310\n234#1:311,3\n*E\n"})
public final class ComposeApplicationRuntime
extends DockerRuntimeBase
implements DockerParentRuntime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String composeProjectName;
    @NotNull
    private final SynchronizedClearableLazy<DockerStatus> myStatus;
    @NotNull
    private final DockerRuntimeDetailsProvider detailsProvider;
    @NotNull
    private final Lazy runtimeNavigatable$delegate;
    @JvmField
    @NotNull
    public static final CloudNotifier COMPOSE_NOTIFIER = new CloudNotifier("docker-compose");

    public ComposeApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull String composeProjectName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)composeProjectName, (String)"composeProjectName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context, project);
        this.composeProjectName = composeProjectName;
        this.myStatus = new SynchronizedClearableLazy(() -> ComposeApplicationRuntime.myStatus$lambda$0(this));
        this.detailsProvider = arg_0 -> ComposeApplicationRuntime.detailsProvider$lambda$4(this, arg_0);
        this.runtimeNavigatable$delegate = LazyKt.lazy(() -> ComposeApplicationRuntime.runtimeNavigatable_delegate$lambda$6(this, project));
    }

    @NotNull
    public final String getComposeProjectName() {
        return this.composeProjectName;
    }

    private final DockerComposeDeployer getDeployer() {
        DockerDeferredRuntime<DockerRuntime> dockerDeferredRuntime = DockerRuntime.Companion.getDeferredRuntime$intellij_clouds_docker((DockerRuntime)this);
        DockerDeployer<DockerRuntime> dockerDeployer = dockerDeferredRuntime != null ? DockerDeferredRuntime.Companion.getDeployer$intellij_clouds_docker(dockerDeferredRuntime) : null;
        return dockerDeployer instanceof DockerComposeDeployer ? (DockerComposeDeployer)dockerDeployer : null;
    }

    private final ComposeCliExecutor getExecutor() {
        Object object = this.getDeployer();
        if (object == null || (object = ((DockerComposeDeployer)object).getCliExecutor()) == null) {
            object = new ComposeCliExecutor(this.getContext());
        }
        return object;
    }

    private final String getWorkDirectory() {
        Object object = this.getDeployer();
        return object != null && (object = ((DockerComposeDeployer)object).getWorkDirectory()) != null ? ((File)object).getPath() : null;
    }

    private final DockerTerminalPipe.WithTty getLoggingPipe() {
        DockerTerminalPipe.WithTty withTty = DockerRuntime.Companion.getDeferredRuntime$intellij_clouds_docker((DockerRuntime)this);
        if (withTty == null || (withTty = withTty.getPipe()) == null) {
            withTty = InternalUtilsKt.makeTerminalPipeWithTty().setShowCursor(false);
        }
        return withTty;
    }

    @NotNull
    public final List<ComposeServiceRuntime> getServiceRuntimes() {
        return this.getContext().getRuntimesManager().findComposeServices(this.composeProjectName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DockerNetworkRuntime> getNetworks() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getContext().getRuntimesManager().getNetworks().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DockerNetworkRuntime it = (DockerNetworkRuntime)element$iv$iv;
            boolean bl = false;
            Map map = it.getNetwork().labels;
            if (!Intrinsics.areEqual((Object)(map != null ? (String)map.get("com.docker.compose.project") : null), (Object)this.composeProjectName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "Docker-compose: " + this.composeProjectName;
    }

    @Override
    @NotNull
    public DockerRuntimeDetailsProvider getDetailsProvider$intellij_clouds_docker() {
        return this.detailsProvider;
    }

    @Override
    @Nullable
    protected DockerRuntimeNavigatable getRuntimeNavigatable() {
        Lazy lazy = this.runtimeNavigatable$delegate;
        return (DockerRuntimeNavigatable)lazy.getValue();
    }

    @Override
    @NotNull
    public Scaffold.SimpleSegment getHeaderComponent$intellij_clouds_docker(@NotNull Scaffold scaffold) {
        Intrinsics.checkNotNullParameter((Object)scaffold, (String)"scaffold");
        Scaffold $this$getHeaderComponent_u24lambda_u2415 = scaffold;
        boolean bl = false;
        return $this$getHeaderComponent_u24lambda_u2415.segment((Function1<? super Scaffold.SimpleSegment, Unit>)((Function1)arg_0 -> ComposeApplicationRuntime.getHeaderComponent$lambda$15$lambda$14(this, arg_0)));
    }

    @Override
    @NotNull
    public PresentationData getNodePresentation(@NotNull ServiceViewItemState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new ComposePresentableDelegate(this).getNodePresentation(state);
    }

    @Override
    @NotNull
    public List<DockerRuntime> getChildren() {
        return CollectionsKt.plus((Collection)DockerUiUtilsKt.withNaturalSorting((Iterable)this.getServiceRuntimes()), (Iterable)DockerUiUtilsKt.withNaturalSorting((Iterable)this.getNetworks()));
    }

    @Override
    @NotNull
    protected DockerStatus doGetStatus() {
        return (DockerStatus)this.myStatus.getValue();
    }

    @JvmOverloads
    @Nullable
    public final Object executeCli$intellij_clouds_docker(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder, @Nullable DockerTerminalPipe.WithTty pipe2, @NotNull Map<String, String> additionalEnvs, @NotNull Continuation<? super Unit> $completion) throws ServerRuntimeException {
        Object object = this.getExecutor().executeCli(cliBuilder, this.getWorkDirectory(), pipe2, additionalEnvs, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object executeCli$intellij_clouds_docker$default(ComposeApplicationRuntime composeApplicationRuntime, AbstractDockerComposeCmdCliBuilder abstractDockerComposeCmdCliBuilder, DockerTerminalPipe.WithTty withTty, Map map, Continuation continuation, int n, Object object) throws ServerRuntimeException {
        if ((n & 2) != 0) {
            withTty = composeApplicationRuntime.getLoggingPipe();
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return composeApplicationRuntime.executeCli$intellij_clouds_docker(abstractDockerComposeCmdCliBuilder, withTty, map, (Continuation<? super Unit>)continuation);
    }

    public final void cancelCurrentProcess() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Companion.selectConsoleTab$intellij_clouds_docker(this);
        }
        this.getExecutor().cancelCurrentProcess();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> getComposeFiles() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getServiceRuntimes();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ComposeServiceRuntime p0 = (ComposeServiceRuntime)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.getComposeFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    public final boolean isValidRuntime() {
        return !((Collection)this.getServiceRuntimes()).isEmpty();
    }

    public final boolean isAllServicesWithoutContainers() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.getServiceRuntimes();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (!ComposeServiceRuntimeKt.isContainsContainers(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isAllServicesRunning() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.getServicesWithContainers();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (ComposeServiceRuntimeKt.isAnyContainerRunning(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isAllServicesStopped() {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.getServicesWithContainers();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (!ComposeServiceRuntimeKt.isAnyContainerRunning(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isAnyServiceRunning() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getServicesWithContainers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                    boolean bl2 = false;
                    if (!ComposeServiceRuntimeKt.isAnyContainerRunning(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final Object startAllServices(@NotNull Continuation<? super Unit> $completion) throws ServerRuntimeException {
        DockerComposeStartCliBuilder $this$startAllServices_u24lambda_u2420 = DockerComposeCliUtil.buildStartCommand(this.getContext().getServerConfiguration());
        boolean bl = false;
        $this$startAllServices_u24lambda_u2420.withFiles(this.getComposeFiles());
        $this$startAllServices_u24lambda_u2420.withProjectName(this.composeProjectName);
        Companion.selectConsoleTab$intellij_clouds_docker(this);
        Object object = this.runStatusTransition(DockerTransitionStatus.STARTING, (Function1)new Function1<Continuation<? super Unit>, Object>(this, $this$startAllServices_u24lambda_u2420, null){
            int label;
            final /* synthetic */ ComposeApplicationRuntime this$0;
            final /* synthetic */ DockerComposeStartCliBuilder $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ComposeApplicationRuntime.executeCli$intellij_clouds_docker$default(this.this$0, (AbstractDockerComposeCmdCliBuilder)this.$this_with, null, null, (Continuation)this, 6, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object stopAllServices(@NotNull Continuation<? super Unit> $completion) throws ServerRuntimeException {
        DockerComposeStopCliBuilder $this$stopAllServices_u24lambda_u2421 = DockerComposeCliUtil.buildStopCommand(this.getContext().getServerConfiguration());
        boolean bl = false;
        $this$stopAllServices_u24lambda_u2421.withProjectName(this.composeProjectName);
        $this$stopAllServices_u24lambda_u2421.withFiles(this.getComposeFiles());
        Companion.selectConsoleTab$intellij_clouds_docker(this);
        Object object = this.runStatusTransition(DockerTransitionStatus.STOPPING, (Function1)new Function1<Continuation<? super Unit>, Object>(this, $this$stopAllServices_u24lambda_u2421, null){
            int label;
            final /* synthetic */ ComposeApplicationRuntime this$0;
            final /* synthetic */ DockerComposeStopCliBuilder $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ComposeApplicationRuntime.executeCli$intellij_clouds_docker$default(this.this$0, (AbstractDockerComposeCmdCliBuilder)this.$this_with, null, null, (Continuation)this, 6, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object down(@Nullable DockerComposeDownOptions downOptions, @NotNull Continuation<? super Unit> $completion) {
        Companion.selectConsoleTab$intellij_clouds_docker(this);
        Object object = this.runStatusTransition(DockerTransitionStatus.DELETING, (Function1)new Function1<Continuation<? super Unit>, Object>(this, downOptions, null){
            int label;
            final /* synthetic */ ComposeApplicationRuntime this$0;
            final /* synthetic */ DockerComposeDownOptions $downOptions;
            {
                this.this$0 = $receiver;
                this.$downOptions = $downOptions;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ComposeApplicationRuntime.executeCli$intellij_clouds_docker$default(this.this$0, (AbstractDockerComposeCmdCliBuilder)ComposeApplicationRuntime.access$downCommand(this.this$0, this.$downOptions), null, null, (Continuation)this, 6, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object down$default(ComposeApplicationRuntime composeApplicationRuntime, DockerComposeDownOptions dockerComposeDownOptions, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            dockerComposeDownOptions = null;
        }
        return composeApplicationRuntime.down(dockerComposeDownOptions, (Continuation<? super Unit>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object restartAllRunningServices(@NotNull Continuation<? super Unit> $completion) throws ServerRuntimeException {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        ComposeServiceRuntime it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        DockerComposeRestartCliBuilder $this$restartAllRunningServices_u24lambda_u2424 = DockerComposeCliUtil.buildRestartCommand(this.getContext().getServerConfiguration());
        boolean bl = false;
        Iterable iterable = this.getServiceRuntimes();
        DockerComposeRestartCliBuilder dockerComposeRestartCliBuilder = $this$restartAllRunningServices_u24lambda_u2424;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ComposeServiceRuntime)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getServiceStatus() == ComposeServiceStatus.UP)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ComposeServiceRuntime)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getServiceName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        dockerComposeRestartCliBuilder.withServices(Arrays.copyOf(stringArray, stringArray.length));
        $this$restartAllRunningServices_u24lambda_u2424.withProjectName(this.composeProjectName);
        $this$restartAllRunningServices_u24lambda_u2424.withFiles(this.getComposeFiles());
        Companion.selectConsoleTab$intellij_clouds_docker(this);
        Object object = this.runStatusTransition(DockerTransitionStatus.STARTING, (Function1)new Function1<Continuation<? super Unit>, Object>(this, $this$restartAllRunningServices_u24lambda_u2424, null){
            int label;
            final /* synthetic */ ComposeApplicationRuntime this$0;
            final /* synthetic */ DockerComposeRestartCliBuilder $this_with;
            {
                this.this$0 = $receiver;
                this.$this_with = $receiver2;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ComposeApplicationRuntime.executeCli$intellij_clouds_docker$default(this.this$0, (AbstractDockerComposeCmdCliBuilder)this.$this_with, null, null, (Continuation)this, 6, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final ComposeServiceRuntime findService(@Nls @NotNull String serviceName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            Iterable iterable = this.getServiceRuntimes();
            for (Object t : iterable) {
                ComposeServiceRuntime it = (ComposeServiceRuntime)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getServiceName(), (Object)serviceName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final DockerComposeDownCliBuilder downCommand(DockerComposeDownOptions downOptions) throws ServerRuntimeException {
        Object object;
        DockerComposeDownCliBuilder downCommand = (DockerComposeDownCliBuilder)((DockerComposeDownCliBuilder)DockerComposeCliUtil.buildDownCommand(this.getContext().getServerConfiguration()).withFiles(this.getComposeFiles())).withProjectName(this.composeProjectName);
        DockerComposeDownOptions dockerComposeDownOptions = downOptions;
        if (dockerComposeDownOptions == null && ((object = this.getDeployer()) != null && (object = ((DockerComposeDeployer)object).getDeployInfo()) != null ? ((DockerComposeDeployer.DeployInfo)object).getDownOptions() : (dockerComposeDownOptions = null)) == null) {
            dockerComposeDownOptions = new DockerComposeDownOptionsImpl(null, false, false, 7, null);
        }
        DockerComposeDownOptions $this$downCommand_u24lambda_u2426 = dockerComposeDownOptions;
        boolean bl = false;
        DockerComposeDownCliBuilder dockerComposeDownCliBuilder = downCommand.withRemoveVolumes($this$downCommand_u24lambda_u2426.isRemoveVolumesOnComposeDown()).withRemoveOrphans($this$downCommand_u24lambda_u2426.getRemoveOrphansOnComposeDown()).withRemoveImages(DockerComposeCliUtil.toKind($this$downCommand_u24lambda_u2426.getRemoveImagesOnComposeDown()));
        Object object2 = this.getDeployer();
        if (object2 == null || (object2 = ((DockerComposeDeployer)object2).getDeployInfo()) == null || (object2 = ((DockerComposeDeployer.DeployInfo)object2).getEnvFiles()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        return (DockerComposeDownCliBuilder)dockerComposeDownCliBuilder.withEnvFiles((List)object2);
    }

    public final void updateStatus$intellij_clouds_docker() {
        this.myStatus.drop();
    }

    private final DockerStatus createStatus() {
        DockerStatus dockerStatus;
        if (this.isAllServicesWithoutContainers()) {
            dockerStatus = DockerStatus.Companion.create(DockerIconUtilsKt.getComposeProjectIcon(ComposeServiceStatus.WITHOUT_CONTAINERS), ComposeApplicationRuntime::createStatus$lambda$27);
        } else {
            ComposeServiceRuntime it;
            boolean bl;
            block19: {
                Iterable $this$none$iv = this.getServiceRuntimes();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (ComposeServiceRuntime)element$iv;
                        boolean bl2 = false;
                        if (!DockerComposeUtilsKt.isComposeFilesLabelSupported((ComposeVersion)it.getComposeVersion())) continue;
                        bl = false;
                        break block19;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Supplier supplier = DockerBundle.messagePointer((String)"DockerComposeApplication.unsupported.version.message", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
                dockerStatus = new DockerComposeStatus.Project(ComposeServiceStatus.ERROR, supplier, null, 4, null);
            } else if (!this.isValidRuntime()) {
                dockerStatus = new DockerComposeStatus.Project(ComposeServiceStatus.ERROR, null, null, 6, null);
            } else if (this.isAllServicesStopped()) {
                dockerStatus = new DockerComposeStatus.Project(ComposeServiceStatus.STOPPED, null, null, 6, null);
            } else {
                boolean bl3;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block20: {
                    $this$any$iv = this.getServicesWithContainers();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (ComposeServiceRuntime)element$iv;
                            boolean bl4 = false;
                            if (!ComposeServiceRuntimeKt.isAnyContainerUnhealthy(it)) continue;
                            bl3 = true;
                            break block20;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    dockerStatus = new DockerComposeStatus.Project(ComposeServiceStatus.UNHEALTHY, null, DockerBundle.messagePointer((String)"Container.health.status.unhealthy", (Object[])new Object[0]), 2, null);
                } else {
                    boolean bl5;
                    block21: {
                        $this$any$iv = this.getServicesWithContainers();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (ComposeServiceRuntime)element$iv;
                                boolean bl6 = false;
                                if (!ComposeServiceRuntimeKt.isAnyContainerHealthy(it)) continue;
                                bl5 = true;
                                break block21;
                            }
                            bl5 = false;
                        }
                    }
                    dockerStatus = bl5 ? (DockerStatus)new DockerComposeStatus.Project(ComposeServiceStatus.HEALTHY, null, DockerBundle.messagePointer((String)"Container.health.status.healthy", (Object[])new Object[0]), 2, null) : (DockerStatus)new DockerComposeStatus.Project(ComposeServiceStatus.UP, null, null, 6, null);
                }
            }
        }
        return dockerStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ComposeServiceRuntime> getServicesWithContainers() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getServiceRuntimes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComposeServiceRuntime p0 = (ComposeServiceRuntime)element$iv$iv;
            boolean bl = false;
            if (!ComposeServiceRuntimeKt.isContainsContainers(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmOverloads
    @Nullable
    public final Object executeCli$intellij_clouds_docker(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder, @Nullable DockerTerminalPipe.WithTty pipe2, @NotNull Continuation<? super Unit> $completion) throws ServerRuntimeException {
        return ComposeApplicationRuntime.executeCli$intellij_clouds_docker$default(this, cliBuilder, pipe2, null, $completion, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final Object executeCli$intellij_clouds_docker(@NotNull AbstractDockerComposeCmdCliBuilder<?> cliBuilder, @NotNull Continuation<? super Unit> $completion) throws ServerRuntimeException {
        return ComposeApplicationRuntime.executeCli$intellij_clouds_docker$default(this, cliBuilder, null, null, $completion, 6, null);
    }

    private static final DockerStatus myStatus$lambda$0(ComposeApplicationRuntime this$0) {
        return this$0.createStatus();
    }

    /*
     * WARNING - void declaration
     */
    private static final List detailsProvider$lambda$4(ComposeApplicationRuntime this$0, DockerTabManager it) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List $this$detailsProvider_u24lambda_u244_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$detailsProvider_u24lambda_u244_u24lambda_u243.add(new DockerComposeProjectDashboardTab(it, this$0));
        if (DockerRuntime.Companion.getDeferredRuntime$intellij_clouds_docker((DockerRuntime)this$0) == null) {
            void it2;
            DockerLoggingHandlerTab.Piped<DockerRuntime> piped;
            DockerLoggingHandlerTab.Piped<DockerRuntime> piped2 = piped = Companion.createConsoleTab$intellij_clouds_docker(this$0, it);
            List list3 = $this$detailsProvider_u24lambda_u244_u24lambda_u243;
            boolean bl2 = false;
            it2.attachPipe((DockerBasePipe)this$0.getLoggingPipe());
            list3.add(piped);
        }
        return CollectionsKt.build((List)list2);
    }

    private static final VirtualFile runtimeNavigatable_delegate$lambda$6$lambda$5(ComposeApplicationRuntime this$0) {
        Path mainFile = (Path)CollectionsKt.firstOrNull(this$0.getComposeFiles());
        return mainFile == null ? null : LocalFileSystem.getInstance().findFileByIoFile(mainFile.toFile());
    }

    private static final DockerRuntimeNavigatable runtimeNavigatable_delegate$lambda$6(ComposeApplicationRuntime this$0, Project $project) {
        Object object = this$0.getDeployer();
        if (object == null || (object = ((DockerComposeDeployer)object).getRuntimeNavigatable()) == null) {
            object = new DockerRuntimeVirtualFileNavigatable($project, (Function0<? extends VirtualFile>)((Function0)() -> ComposeApplicationRuntime.runtimeNavigatable_delegate$lambda$6$lambda$5(this$0)));
        }
        return object;
    }

    private static final Unit getHeaderComponent$lambda$15$lambda$14$lambda$7(ComposeApplicationRuntime this$0, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.setIcon(this$0.getStatus().getIcon());
        $this$textFragment.append(this$0.getPresentableName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit getHeaderComponent$lambda$15$lambda$14$lambda$9(ComposeApplicationRuntime this$0, Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        List<ComposeServiceRuntime> serviceRuntimes = this$0.getServiceRuntimes();
        Iterable $this$count$iv = serviceRuntimes;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ComposeServiceRuntime it = (ComposeServiceRuntime)element$iv;
                boolean bl = false;
                if (!ComposeServiceRuntimeKt.isAnyContainerRunning(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int runningServicesCount = n;
        Object[] objectArray = new Object[]{runningServicesCount, serviceRuntimes.size()};
        $this$textFragment.append(DockerBundle.message((String)"Docker.running.state", (Object[])objectArray), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final boolean getHeaderComponent$lambda$15$lambda$14$lambda$10(ComposeApplicationRuntime this$0, AnAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isValidRuntime() && !this$0.isAllServicesRunning();
    }

    private static final boolean getHeaderComponent$lambda$15$lambda$14$lambda$11(ComposeApplicationRuntime this$0, AnAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isValidRuntime() && this$0.isAnyServiceRunning();
    }

    private static final boolean getHeaderComponent$lambda$15$lambda$14$lambda$12(ComposeApplicationRuntime this$0, AnAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isValidRuntime() && this$0.isAnyServiceRunning();
    }

    private static final boolean getHeaderComponent$lambda$15$lambda$14$lambda$13(ComposeApplicationRuntime this$0, AnAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isValidRuntime() && !this$0.isAllServicesWithoutContainers();
    }

    private static final Unit getHeaderComponent$lambda$15$lambda$14(ComposeApplicationRuntime this$0, Scaffold.SimpleSegment $this$segment) {
        Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
        $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)arg_0 -> ComposeApplicationRuntime.getHeaderComponent$lambda$15$lambda$14$lambda$7(this$0, arg_0)));
        $this$segment.textFragment((Function1<? super Scaffold.SimpleSegment.TextFragment, Unit>)((Function1)arg_0 -> ComposeApplicationRuntime.getHeaderComponent$lambda$15$lambda$14$lambda$9(this$0, arg_0)));
        ScaffoldKt.button$default($this$segment, null, null, "Docker.RemoteServers.StartAllComposeApp", arg_0 -> ComposeApplicationRuntime.getHeaderComponent$lambda$15$lambda$14$lambda$10(this$0, arg_0), 3, null);
        ScaffoldKt.button$default($this$segment, null, null, "Docker.RemoteServers.RestartComposeApp", arg_0 -> ComposeApplicationRuntime.getHeaderComponent$lambda$15$lambda$14$lambda$11(this$0, arg_0), 3, null);
        ScaffoldKt.button$default($this$segment, null, null, "Docker.RemoteServers.StopComposeApp", arg_0 -> ComposeApplicationRuntime.getHeaderComponent$lambda$15$lambda$14$lambda$12(this$0, arg_0), 3, null);
        ScaffoldKt.button$default($this$segment, null, null, "Docker.RemoteServers.DownComposeApp", arg_0 -> ComposeApplicationRuntime.getHeaderComponent$lambda$15$lambda$14$lambda$13(this$0, arg_0), 3, null);
        return Unit.INSTANCE;
    }

    private static final String createStatus$lambda$27() {
        return "";
    }

    public static final /* synthetic */ DockerComposeDownCliBuilder access$downCommand(ComposeApplicationRuntime $this, DockerComposeDownOptions downOptions) {
        return $this.downCommand(downOptions);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ#\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0002J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/runtimes/ComposeApplicationRuntime$Companion;", "", "<init>", "()V", "COMPOSE_NOTIFIER", "Lcom/intellij/remoteServer/util/CloudNotifier;", "selectConsoleTab", "", "runtime", "Lcom/intellij/docker/runtimes/DockerRuntime;", "selectConsoleTab$intellij_clouds_docker", "createConsoleTab", "Lcom/intellij/docker/view/details/DockerLoggingHandlerTab$Piped;", "tabManager", "Lcom/intellij/docker/view/details/DockerTabManager;", "createConsoleTab$intellij_clouds_docker", "computeEnvVarAwareProjectName", "", "workDirectory", "Ljava/nio/file/Path;", "envFileNames", "", "tryFindProjectNameInEnvFiles", "tryFindProjectNameInEnvFile", "envFileName", "computeErasedProjectName", "name", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nComposeApplicationRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeApplicationRuntime.kt\ncom/intellij/docker/runtimes/ComposeApplicationRuntime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void selectConsoleTab$intellij_clouds_docker(@NotNull DockerRuntime runtime) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            String string = DockerBundle.message((String)"ConsoleTab.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            DockerRuntimeServiceViewContributorKt.selectDetailsTab(runtime, string);
        }

        @NotNull
        public final DockerLoggingHandlerTab.Piped<DockerRuntime> createConsoleTab$intellij_clouds_docker(@NotNull DockerRuntime runtime, @NotNull DockerTabManager tabManager) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
            Supplier supplier = DockerBundle.messagePointer((String)"ConsoleTab.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            Supplier supplier2 = supplier;
            return new DockerLoggingHandlerTab.Piped<DockerRuntime>(tabManager, runtime, supplier2, false, null, 16, null);
        }

        @NotNull
        public final String computeEnvVarAwareProjectName(@NotNull Path workDirectory, @NotNull List<String> envFileNames) {
            Intrinsics.checkNotNullParameter((Object)workDirectory, (String)"workDirectory");
            Intrinsics.checkNotNullParameter(envFileNames, (String)"envFileNames");
            String string = this.tryFindProjectNameInEnvFiles(workDirectory, envFileNames);
            if (string == null && (string = StringKt.nullize((String)System.getenv("COMPOSE_PROJECT_NAME"), (boolean)true)) == null) {
                string = this.computeErasedProjectName(PathsKt.getName((Path)workDirectory));
            }
            return string;
        }

        public static /* synthetic */ String computeEnvVarAwareProjectName$default(Companion companion, Path path2, List list2, int n, Object object) {
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            return companion.computeEnvVarAwareProjectName(path2, list2);
        }

        private final String tryFindProjectNameInEnvFiles(Path workDirectory, List<String> envFileNames) {
            String string;
            block1: {
                for (String envFileName : (Iterable)envFileNames) {
                    boolean bl = false;
                    String string2 = Companion.tryFindProjectNameInEnvFile(workDirectory, envFileName);
                    if (string2 == null) continue;
                    string = string2;
                    break block1;
                }
                string = null;
            }
            return string;
        }

        static /* synthetic */ String tryFindProjectNameInEnvFiles$default(Companion companion, Path path2, List list2, int n, Object object) {
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            return companion.tryFindProjectNameInEnvFiles(path2, list2);
        }

        private final String tryFindProjectNameInEnvFile(Path workDirectory, String envFileName) {
            Object v4;
            Object object;
            block4: {
                String string = envFileName;
                if (string == null) {
                    string = ".env";
                }
                Path path2 = workDirectory.resolve(string);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                VirtualFile virtualFile = VfsUtil.findFile((Path)path2, (boolean)false);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile file = virtualFile;
                if (file.isDirectory()) {
                    return null;
                }
                InputStream inputStream = file.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                object = inputStream;
                Object object2 = Charsets.UTF_8;
                object2 = TextStreamsKt.readLines((Reader)new InputStreamReader((InputStream)object, (Charset)object2));
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"COMPOSE_PROJECT_NAME", (boolean)false, (int)2, null)) continue;
                    v4 = t;
                    break block4;
                }
                v4 = null;
            }
            String string = v4;
            return string != null && (object = StringsKt.substringAfter$default((String)string, (String)"=", null, (int)2, null)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
        }

        static /* synthetic */ String tryFindProjectNameInEnvFile$default(Companion companion, Path path2, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.tryFindProjectNameInEnvFile(path2, string);
        }

        @NotNull
        public final String computeErasedProjectName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            CharSequence charSequence = name;
            Regex regex = new Regex("[^a-zA-Z0-9-_]+");
            String string = "";
            String string2 = StringUtil.toLowerCase((String)regex.replace(charSequence, string));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

