/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe.columns;

import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.dataframe.columns.RealType;
import com.intellij.charts.dataframe.columns.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0019j\b\u0012\u0004\u0012\u00020\u0014`\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0011\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020 H\u0096\u0002R\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lcom/intellij/charts/dataframe/columns/DoubleColumn;", "Lcom/intellij/charts/dataframe/columns/Column;", "", "name", "", "data", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "type", "Lcom/intellij/charts/dataframe/columns/Type;", "getType", "()Lcom/intellij/charts/dataframe/columns/Type;", "isNumerical", "", "()Z", "lazyRange", "Lkotlin/ranges/ClosedRange;", "isNotNull", "index", "", "isNull", "getDouble", "(I)Ljava/lang/Double;", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "descendant", "range", "getRange", "()Lkotlin/ranges/ClosedRange;", "iterator", "", "intellij.charts"})
public final class DoubleColumn
extends Column<Double> {
    private final boolean isNumerical;
    @Nullable
    private ClosedRange<Double> lazyRange;

    public DoubleColumn(@NotNull String name, @NotNull List<Double> data2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        super(name, data2);
        this.isNumerical = true;
    }

    @Override
    @NotNull
    public Type<Double> getType() {
        return RealType.INSTANCE;
    }

    @Override
    public boolean isNumerical() {
        return this.isNumerical;
    }

    @Override
    public boolean isNotNull(int index) {
        return this.getData().get(index) != null;
    }

    @Override
    public boolean isNull(int index) {
        return this.getData().get(index) == null;
    }

    @Override
    @Nullable
    public Double getDouble(int index) {
        return (Double)this.getData().get(index);
    }

    @Override
    @NotNull
    public Comparator<Integer> getComparator(boolean descendant) {
        return descendant ? (arg_0, arg_1) -> DoubleColumn.getComparator$lambda$0(this, arg_0, arg_1) : (arg_0, arg_1) -> DoubleColumn.getComparator$lambda$1(this, arg_0, arg_1);
    }

    @Override
    @NotNull
    public ClosedRange<Double> getRange() {
        if (this.lazyRange != null) {
            ClosedRange<Double> closedRange = this.lazyRange;
            Intrinsics.checkNotNull(closedRange);
            return closedRange;
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int n = ((Collection)this.getData()).size();
        for (int i = 0; i < n; ++i) {
            Double value = (Double)this.getData().get(i);
            if (value == null) continue;
            if (min > value) {
                min = value;
            }
            if (!(max < value)) continue;
            max = value;
        }
        this.lazyRange = (ClosedRange)RangesKt.rangeTo((double)min, (double)max);
        ClosedRange<Double> closedRange = this.lazyRange;
        Intrinsics.checkNotNull(closedRange);
        return closedRange;
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        return this.getData().iterator();
    }

    private static final int getComparator$lambda$0(DoubleColumn this$0, Integer i1, Integer i2) {
        Intrinsics.checkNotNull((Object)i2);
        Double d = (Double)this$0.get(i2);
        double d2 = d != null ? d : Double.MIN_VALUE;
        Intrinsics.checkNotNull((Object)i1);
        Double d3 = (Double)this$0.get(i1);
        return Double.compare(d2, d3 != null ? d3 : Double.MIN_VALUE);
    }

    private static final int getComparator$lambda$1(DoubleColumn this$0, Integer i1, Integer i2) {
        Intrinsics.checkNotNull((Object)i1);
        Double d = (Double)this$0.get(i1);
        double d2 = d != null ? d : Double.MIN_VALUE;
        Intrinsics.checkNotNull((Object)i2);
        Double d3 = (Double)this$0.get(i2);
        return Double.compare(d2, d3 != null ? d3 : Double.MIN_VALUE);
    }
}

