/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.plot;

import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.plot.FigureToAwt;
import org.jetbrains.letsPlot.awt.plot.MonolithicAwt;
import org.jetbrains.letsPlot.awt.plot.MonolithicAwtKt;
import org.jetbrains.letsPlot.awt.plot.component.DefaultErrorMessageComponent;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.spec.FailureHandler;
import org.jetbrains.letsPlot.core.util.MonolithicCommon;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicy;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u00a8\u0001\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\r2\u0018\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00140\r2#\b\u0002\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00040\r2\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0018\u0012\u0004\u0012\u00020\u00140\rJ\u0099\u0001\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\r2\u0018\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00140\r2\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\r2\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0018\u0012\u0004\u0012\u00020\u00140\rJ7\u0010\u001a\u001a\u00020\u00042\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00040\rH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/MonolithicAwt;", "", "()V", "buildPlotFromProcessedSpecs", "Ljavax/swing/JComponent;", "plotSpec", "", "", "containerSize", "Ljava/awt/Dimension;", "sizingPolicy", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "svgComponentFactory", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "Lkotlin/ParameterName;", "name", "svg", "executor", "Lkotlin/Function0;", "", "errorMessageComponentFactory", "message", "computationMessagesHandler", "", "buildPlotFromRawSpecs", "handleException", "e", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "platf-awt"})
public final class MonolithicAwt {
    @NotNull
    public static final MonolithicAwt INSTANCE = new MonolithicAwt();

    private MonolithicAwt() {
    }

    @NotNull
    public final JComponent buildPlotFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable Dimension containerSize, @NotNull SizingPolicy sizingPolicy, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor, @NotNull Function1<? super String, ? extends JComponent> errorMessageComponentFactory2, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)sizingPolicy, (String)"sizingPolicy");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        Intrinsics.checkNotNullParameter(errorMessageComponentFactory2, (String)"errorMessageComponentFactory");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        try {
            Map plotSpec2 = MonolithicCommon.processRawSpecs$default(MonolithicCommon.INSTANCE, plotSpec, false, 2, null);
            jComponent = this.buildPlotFromProcessedSpecs(plotSpec2, containerSize, sizingPolicy, svgComponentFactory, executor, errorMessageComponentFactory2, computationMessagesHandler);
        }
        catch (RuntimeException e) {
            jComponent = this.handleException(e, errorMessageComponentFactory2);
        }
        return jComponent;
    }

    public static /* synthetic */ JComponent buildPlotFromRawSpecs$default(MonolithicAwt monolithicAwt, Map map2, Dimension dimension, SizingPolicy sizingPolicy, Function1 function1, Function1 function12, Function1 function13, Function1 function14, int n, Object object) {
        if ((n & 0x20) != 0) {
            function13 = DefaultErrorMessageComponent.Companion.getFactory();
        }
        return monolithicAwt.buildPlotFromRawSpecs(map2, dimension, sizingPolicy, (Function1<? super SvgSvgElement, ? extends JComponent>)function1, (Function1<? super Function0<Unit>, Unit>)function12, function13, (Function1<? super List<String>, Unit>)function14);
    }

    @NotNull
    public final JComponent buildPlotFromProcessedSpecs(@NotNull Map<String, Object> plotSpec, @Nullable Dimension containerSize, @NotNull SizingPolicy sizingPolicy, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor, @NotNull Function1<? super String, ? extends JComponent> errorMessageComponentFactory2, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)sizingPolicy, (String)"sizingPolicy");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        Intrinsics.checkNotNullParameter(errorMessageComponentFactory2, (String)"errorMessageComponentFactory");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        try {
            DoubleVector doubleVector;
            Dimension dimension = containerSize;
            if (dimension != null) {
                Dimension it = dimension;
                boolean bl = false;
                doubleVector = new DoubleVector(it.width, it.height);
            } else {
                doubleVector = null;
            }
            DoubleVector containerSizeDV = doubleVector;
            MonolithicCommon.PlotsBuildResult buildResult = MonolithicCommon.INSTANCE.buildPlotsFromProcessedSpecs(plotSpec, containerSizeDV, sizingPolicy);
            if (buildResult.isError()) {
                Intrinsics.checkNotNull((Object)buildResult, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.util.MonolithicCommon.PlotsBuildResult.Error");
                String errorMessage = ((MonolithicCommon.PlotsBuildResult.Error)buildResult).getError();
                return (JComponent)errorMessageComponentFactory2.invoke((Object)errorMessage);
            }
            Intrinsics.checkNotNull((Object)buildResult, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.util.MonolithicCommon.PlotsBuildResult.Success");
            MonolithicCommon.PlotsBuildResult.Success success2 = (MonolithicCommon.PlotsBuildResult.Success)buildResult;
            List<String> computationMessages = success2.getBuildInfo().getComputationMessages();
            computationMessagesHandler.invoke(computationMessages);
            return new FigureToAwt(success2.getBuildInfo(), svgComponentFactory, executor).eval();
        }
        catch (RuntimeException e) {
            return this.handleException(e, errorMessageComponentFactory2);
        }
    }

    public static /* synthetic */ JComponent buildPlotFromProcessedSpecs$default(MonolithicAwt monolithicAwt, Map map2, Dimension dimension, SizingPolicy sizingPolicy, Function1 function1, Function1 function12, Function1 function13, Function1 function14, int n, Object object) {
        if ((n & 0x20) != 0) {
            function13 = DefaultErrorMessageComponent.Companion.getFactory();
        }
        return monolithicAwt.buildPlotFromProcessedSpecs(map2, dimension, sizingPolicy, (Function1<? super SvgSvgElement, ? extends JComponent>)function1, (Function1<? super Function0<Unit>, Unit>)function12, function13, (Function1<? super List<String>, Unit>)function14);
    }

    private final JComponent handleException(RuntimeException e, Function1<? super String, ? extends JComponent> errorMessageComponentFactory2) {
        FailureHandler.FailureInfo failureInfo = FailureHandler.INSTANCE.failureInfo(e);
        if (failureInfo.isInternalError()) {
            MonolithicAwtKt.access$getLOG$p().error(e, (Function0<String>)((Function0)handleException.1.INSTANCE));
        }
        return (JComponent)errorMessageComponentFactory2.invoke((Object)failureInfo.getMessage());
    }
}

