/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J;\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000eH\u0016J*\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00152\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0002J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u0017H\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0003H\u0002R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/ECDFStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "n", "", "padded", "", "(Ljava/lang/Integer;Z)V", "Ljava/lang/Integer;", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "buildStat", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "", "", "xs", "consumes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "linspace", "start", "stop", "num", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nECDFStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ECDFStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/ECDFStat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n766#2:86\n857#2,2:87\n1549#2:89\n1620#2,3:90\n1549#2:93\n1620#2,3:94\n1#3:97\n*S KotlinDebug\n*F\n+ 1 ECDFStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/ECDFStat\n*L\n38#1:86\n38#1:87,2\n38#1:89\n38#1:90,3\n52#1:93\n52#1:94,3\n*E\n"})
public final class ECDFStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer n;
    private final boolean padded;
    public static final boolean DEF_PADDED = true;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public ECDFStat(@Nullable Integer n, boolean padded) {
        super(DEF_MAPPING);
        this.n = n;
        this.padded = padded;
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        return CollectionsKt.listOf(Aes.Companion.getX());
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data2, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX()};
        if (!this.hasRequiredValues(data2, aesArray)) {
            return this.withEmptyStatValues();
        }
        Map<DataFrame.Variable, List<Double>> statData = this.buildStat(data2.getNumeric(TransformVar.INSTANCE.getX()));
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), (List)MapsKt.getValue(statData, (Object)Stats.INSTANCE.getX())).putNumeric(Stats.INSTANCE.getY(), (List)MapsKt.getValue(statData, (Object)Stats.INSTANCE.getY())).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFrame.Variable, List<Double>> buildStat(List<Double> xs) {
        List list2;
        List padX;
        List list3;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        boolean bl;
        Double it;
        Pair[] $this$filterTo$iv$iv;
        Iterable $this$filter$iv = xs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            double d;
            it = (Double)t;
            bl = false;
            Double d2 = it;
            boolean bl2 = d2 != null ? !Double.isInfinite(d = d2.doubleValue()) && !Double.isNaN(d) : false;
            if (!bl2) continue;
            destination$iv$iv.add(t);
        }
        Pair[] $this$map$iv = (Pair[])((List)destination$iv$iv);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv2) {
            it = (Double)t;
            collection = destination$iv$iv;
            bl = false;
            Double d = it;
            Intrinsics.checkNotNull((Object)d);
            collection.add(Double.valueOf(d));
        }
        List xValues = (List)destination$iv$iv;
        if (xValues.isEmpty()) {
            $this$map$iv = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getX(), (Object)CollectionsKt.emptyList()), TuplesKt.to((Object)Stats.INSTANCE.getY(), (Object)CollectionsKt.emptyList())};
            return MapsKt.mapOf((Pair[])$this$map$iv);
        }
        Function1 ecdf2 = (Function1)new Function1<Double, Double>((List<Double>)xValues){
            final /* synthetic */ List<Double> $xValues;
            {
                this.$xValues = $xValues;
                super(1);
            }

            @NotNull
            public final Double invoke(double t) {
                int n;
                Iterable $this$count$iv = this.$xValues;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        double x2 = ((Number)element$iv).doubleValue();
                        boolean bl = false;
                        if (!(x2 <= t) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                return (double)n / (double)this.$xValues.size();
            }
        };
        List<Double> statX = this.n == null ? CollectionsKt.distinct((Iterable)xValues) : this.linspace(CollectionsKt.minOrThrow((Iterable)xValues), CollectionsKt.maxOrThrow((Iterable)xValues), this.n);
        Iterable $this$map$iv2 = statX;
        boolean $i$f$map222 = false;
        Object[] objectArray = $this$map$iv2;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = collection2;
            boolean bl3 = false;
            collection.add(((Number)ecdf2.invoke((Object)((double)it2))).doubleValue());
        }
        List statY = (List)collection2;
        if (this.padded) {
            Object[] $i$f$map222 = new Double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
            list3 = CollectionsKt.listOf((Object[])$i$f$map222);
        } else {
            list3 = padX = CollectionsKt.emptyList();
        }
        if (this.padded) {
            objectArray = new Double[]{0.0, 1.0};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List padY = list2;
        objectArray = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getX(), (Object)CollectionsKt.plus((Collection)statX, (Iterable)padX)), TuplesKt.to((Object)Stats.INSTANCE.getY(), (Object)CollectionsKt.plus((Collection)statY, (Iterable)padY))};
        return MapsKt.mapOf((Pair[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> linspace(double start2, double stop2, int num) {
        if (num <= 0) {
            return CollectionsKt.emptyList();
        }
        if (num == 1) {
            return CollectionsKt.listOf((Object)start2);
        }
        double step2 = (stop2 - start2) / (double)(num - 1);
        ArrayList<Double> arrayList = new ArrayList<Double>(num);
        int n = 0;
        while (n < num) {
            void it;
            int n2;
            int n3 = n2 = n++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(start2 + (double)it * step2);
        }
        return arrayList;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/ECDFStat$Companion;", "", "()V", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "DEF_PADDED", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

