/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.anim;

import java.awt.geom.Point2D;
import org.jetbrains.relocated.apache.batik.anim.InterpolatingAnimation;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimatableElement;
import org.jetbrains.relocated.apache.batik.anim.timing.TimedElement;
import org.jetbrains.relocated.apache.batik.anim.values.AnimatableAngleValue;
import org.jetbrains.relocated.apache.batik.anim.values.AnimatableMotionPointValue;
import org.jetbrains.relocated.apache.batik.anim.values.AnimatableValue;
import org.jetbrains.relocated.apache.batik.ext.awt.geom.Cubic;
import org.jetbrains.relocated.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.jetbrains.relocated.apache.batik.ext.awt.geom.ExtendedPathIterator;
import org.jetbrains.relocated.apache.batik.ext.awt.geom.PathLength;

public class MotionAnimation
extends InterpolatingAnimation {
    protected ExtendedGeneralPath path;
    protected PathLength pathLength;
    protected float[] keyPoints;
    protected boolean rotateAuto;
    protected boolean rotateAutoReverse;
    protected float rotateAngle;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MotionAnimation(TimedElement timedElement, AnimatableElement animatableElement, int calcMode, float[] keyTimes, float[] keySplines, boolean additive, boolean cumulative, AnimatableValue[] values2, AnimatableValue from2, AnimatableValue to, AnimatableValue by, ExtendedGeneralPath path2, float[] keyPoints, boolean rotateAuto, boolean rotateAutoReverse, float rotateAngle, short rotateAngleUnit) {
        super(timedElement, animatableElement, calcMode, keyTimes, keySplines, additive, cumulative);
        int i;
        int j;
        int i2;
        this.rotateAuto = rotateAuto;
        this.rotateAutoReverse = rotateAutoReverse;
        this.rotateAngle = AnimatableAngleValue.rad(rotateAngle, rotateAngleUnit);
        if (path2 == null) {
            path2 = new ExtendedGeneralPath();
            if (values2 == null || values2.length == 0) {
                if (from2 != null) {
                    AnimatableMotionPointValue fromPt = (AnimatableMotionPointValue)from2;
                    float x2 = fromPt.getX();
                    float y2 = fromPt.getY();
                    path2.moveTo(x2, y2);
                    if (to != null) {
                        AnimatableMotionPointValue toPt = (AnimatableMotionPointValue)to;
                        path2.lineTo(toPt.getX(), toPt.getY());
                    } else {
                        if (by == null) throw timedElement.createException("values.to.by.path.missing", new Object[]{null});
                        AnimatableMotionPointValue byPt = (AnimatableMotionPointValue)by;
                        path2.lineTo(x2 + byPt.getX(), y2 + byPt.getY());
                    }
                } else if (to != null) {
                    AnimatableMotionPointValue unPt = (AnimatableMotionPointValue)animatableElement.getUnderlyingValue();
                    AnimatableMotionPointValue toPt = (AnimatableMotionPointValue)to;
                    path2.moveTo(unPt.getX(), unPt.getY());
                    path2.lineTo(toPt.getX(), toPt.getY());
                    this.cumulative = false;
                } else {
                    if (by == null) throw timedElement.createException("values.to.by.path.missing", new Object[]{null});
                    AnimatableMotionPointValue byPt = (AnimatableMotionPointValue)by;
                    path2.moveTo(0.0f, 0.0f);
                    path2.lineTo(byPt.getX(), byPt.getY());
                    this.additive = true;
                }
            } else {
                AnimatableMotionPointValue pt = (AnimatableMotionPointValue)values2[0];
                path2.moveTo(pt.getX(), pt.getY());
                for (int i3 = 1; i3 < values2.length; ++i3) {
                    pt = (AnimatableMotionPointValue)values2[i3];
                    path2.lineTo(pt.getX(), pt.getY());
                }
            }
        }
        this.path = path2;
        this.pathLength = new PathLength(path2);
        int segments = 0;
        ExtendedPathIterator epi = path2.getExtendedPathIterator();
        while (!epi.isDone()) {
            int type = epi.currentSegment();
            if (type != 0) {
                ++segments;
            }
            epi.next();
        }
        int count2 = keyPoints == null ? segments + 1 : keyPoints.length;
        float totalLength = this.pathLength.lengthOfPath();
        if (this.keyTimes != null && calcMode != 2) {
            if (this.keyTimes.length != count2) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyTimes"});
            }
        } else if (calcMode == 1 || calcMode == 3) {
            this.keyTimes = new float[count2];
            for (i2 = 0; i2 < count2; ++i2) {
                this.keyTimes[i2] = (float)i2 / (float)(count2 - 1);
            }
        } else if (calcMode == 0) {
            this.keyTimes = new float[count2];
            for (i2 = 0; i2 < count2; ++i2) {
                this.keyTimes[i2] = (float)i2 / (float)count2;
            }
        } else {
            epi = path2.getExtendedPathIterator();
            this.keyTimes = new float[count2];
            j = 0;
            for (i = 0; i < count2 - 1; ++i) {
                while (epi.currentSegment() == 0) {
                    ++j;
                    epi.next();
                }
                this.keyTimes[i] = this.pathLength.getLengthAtSegment(j) / totalLength;
                ++j;
                epi.next();
            }
            this.keyTimes[count2 - 1] = 1.0f;
        }
        if (keyPoints != null) {
            if (keyPoints.length != this.keyTimes.length) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyPoints"});
            }
        } else {
            epi = path2.getExtendedPathIterator();
            keyPoints = new float[count2];
            j = 0;
            for (i = 0; i < count2 - 1; ++i) {
                while (epi.currentSegment() == 0) {
                    ++j;
                    epi.next();
                }
                keyPoints[i] = this.pathLength.getLengthAtSegment(j) / totalLength;
                ++j;
                epi.next();
            }
            keyPoints[count2 - 1] = 1.0f;
        }
        this.keyPoints = keyPoints;
    }

    @Override
    protected void sampledAtUnitTime(float unitTime, int repeatIteration) {
        AnimatableMotionPointValue accumulation;
        float ang;
        AnimatableMotionPointValue value;
        float interpolation = 0.0f;
        if (unitTime != 1.0f) {
            float ang2;
            int keyTimeIndex;
            for (keyTimeIndex = 0; keyTimeIndex < this.keyTimes.length - 1 && unitTime >= this.keyTimes[keyTimeIndex + 1]; ++keyTimeIndex) {
            }
            if (keyTimeIndex == this.keyTimes.length - 1 && this.calcMode == 0) {
                keyTimeIndex = this.keyTimes.length - 2;
                interpolation = 1.0f;
            } else if (this.calcMode == 1 || this.calcMode == 2 || this.calcMode == 3) {
                interpolation = unitTime == 0.0f ? 0.0f : (unitTime - this.keyTimes[keyTimeIndex]) / (this.keyTimes[keyTimeIndex + 1] - this.keyTimes[keyTimeIndex]);
                if (this.calcMode == 3 && unitTime != 0.0f) {
                    float t;
                    Point2D.Double p;
                    double x2;
                    Cubic c = this.keySplineCubics[keyTimeIndex];
                    float tolerance = 0.001f;
                    float min = 0.0f;
                    float max = 1.0f;
                    while (!(Math.abs((x2 = (p = c.eval(t = (min + max) / 2.0f)).getX()) - (double)interpolation) < (double)tolerance)) {
                        if (x2 < (double)interpolation) {
                            min = t;
                            continue;
                        }
                        max = t;
                    }
                    interpolation = (float)p.getY();
                }
            }
            float point2 = this.keyPoints[keyTimeIndex];
            if (interpolation != 0.0f) {
                point2 += interpolation * (this.keyPoints[keyTimeIndex + 1] - this.keyPoints[keyTimeIndex]);
            }
            Point2D p = this.pathLength.pointAtLength(point2 *= this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                ang2 = this.pathLength.angleAtLength(point2);
                if (this.rotateAutoReverse) {
                    ang2 = (float)((double)ang2 + Math.PI);
                }
            } else {
                ang2 = this.rotateAngle;
            }
            value = new AnimatableMotionPointValue(null, (float)p.getX(), (float)p.getY(), ang2);
        } else {
            Point2D p = this.pathLength.pointAtLength(this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                ang = this.pathLength.angleAtLength(this.pathLength.lengthOfPath());
                if (this.rotateAutoReverse) {
                    ang = (float)((double)ang + Math.PI);
                }
            } else {
                ang = this.rotateAngle;
            }
            value = new AnimatableMotionPointValue(null, (float)p.getX(), (float)p.getY(), ang);
        }
        if (this.cumulative) {
            Point2D p = this.pathLength.pointAtLength(this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                ang = this.pathLength.angleAtLength(this.pathLength.lengthOfPath());
                if (this.rotateAutoReverse) {
                    ang = (float)((double)ang + Math.PI);
                }
            } else {
                ang = this.rotateAngle;
            }
            accumulation = new AnimatableMotionPointValue(null, (float)p.getX(), (float)p.getY(), ang);
        } else {
            accumulation = null;
        }
        this.value = ((AnimatableValue)value).interpolate(this.value, null, interpolation, accumulation, repeatIteration);
        if (this.value.hasChanged()) {
            this.markDirty();
        }
    }
}

