#!/bin/bash
truncate -s 0 templates.h

function handle_file {
  l=$1
  path_name="${l%.mustache}"
  name="${path_name##*/}"
  name="${name^^}"
  #template=$(html-minifier --collapse-boolean-attributes --collapse-whitespace --minify-js true --minify-css true --quote-character \' $l | sed -e 's/\\/\\\\/g' | sed -e 's/"/\\"/g')
  template=$(sed -e 's/^[[:space:]]*//;s/[[:space:]]*$//' $l | sed -e 's/\\/\\\\/g' | sed -e 's/"/\\"/g')
  template=${template//$'\n'/\\n}
  echo "#define PROMPTTEMPLATE_${name} \"${template}\"" >> templates.h
}

(
  echo "// This file is automatically generated. If any of the .mustache files is changed, rerun the generation."
  echo "#ifndef PROMPTTEXT_TEMPLATES_H"
  echo "#define PROMPTTEXT_TEMPLATES_H"
  echo
  echo '#include "wrapper/cjson.h"'
  echo
) >> templates.h

FILES=$(ls *.mustache)

for l in ${FILES[@]}; do
  handle_file $l
done

(
  echo
  echo "#endif // PROMPTTEXT_TEMPLATES_H"
) >> templates.h
