/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.BytesInputStream;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTCPTransport
implements ModbusTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusTCPTransport.class);
    private Socket m_Socket;
    protected DataInputStream m_Input;
    protected DataOutputStream m_Output;
    protected BytesInputStream m_ByteIn;

    public ModbusTCPTransport(Socket socket) {
        try {
            this.setSocket(socket);
        }
        catch (IOException ex) {
            String errMsg = "Socket invalid";
            logger.debug("Socket invalid");
            throw new IllegalStateException("Socket invalid");
        }
    }

    public void setSocket(Socket socket) throws IOException {
        this.close();
        this.m_Socket = socket;
        this.prepareStreams(socket);
    }

    @Override
    public void close() throws IOException {
        if (this.m_Input != null) {
            try {
                this.m_Input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.m_Output != null) {
            try {
                this.m_Output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.m_Socket != null) {
            try {
                this.m_Socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeMessage(ModbusMessage msg) throws ModbusIOException {
        try {
            msg.writeTo(this.m_Output);
            this.m_Output.flush();
        }
        catch (Exception ex) {
            throw new ModbusIOException(String.format("I/O exception - failed to write: %s", ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusRequest readRequest() throws ModbusIOException {
        try {
            ModbusRequest req = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                byte[] buffer = this.m_ByteIn.getBuffer();
                this.m_Input.readFully(buffer, 0, 6);
                short bf = ModbusUtil.registerToShort(buffer, 4);
                this.m_Input.readFully(buffer, 6, bf);
                this.m_ByteIn.reset(buffer, 6 + bf);
                this.m_ByteIn.skip(7);
                int functionCode = this.m_ByteIn.readUnsignedByte();
                this.m_ByteIn.reset();
                req = ModbusRequest.createModbusRequest(functionCode);
                req.readFrom(this.m_ByteIn);
            }
            return req;
        }
        catch (EOFException eoex) {
            throw new ModbusIOException(true);
        }
        catch (SocketException sockex) {
            throw new ModbusIOException(true);
        }
        catch (Exception ex) {
            throw new ModbusIOException(String.format("I/O exception - failed to read: %s %s", ex.getClass().getSimpleName(), ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModbusResponse readResponse() throws ModbusIOException {
        try {
            ModbusResponse res = null;
            BytesInputStream bytesInputStream = this.m_ByteIn;
            synchronized (bytesInputStream) {
                byte[] buffer = this.m_ByteIn.getBuffer();
                this.m_Input.readFully(buffer, 0, 6);
                short bf = ModbusUtil.registerToShort(buffer, 4);
                this.m_Input.readFully(buffer, 6, bf);
                this.m_ByteIn.reset(buffer, 6 + bf);
                this.m_ByteIn.skip(7);
                int functionCode = this.m_ByteIn.readUnsignedByte();
                this.m_ByteIn.reset();
                res = ModbusResponse.createModbusResponse(functionCode);
                res.readFrom(this.m_ByteIn);
            }
            return res;
        }
        catch (Exception ex) {
            throw new ModbusIOException(String.format("I/O exception: %s %s", ex.getClass().getSimpleName(), ex.getMessage()));
        }
    }

    protected void prepareStreams(Socket socket) throws IOException {
        this.m_Input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.m_Output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.m_ByteIn = new BytesInputStream(256);
    }
}

