// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetBucketLifecycleConfiguration`](crate::operation::get_bucket_lifecycle_configuration::builders::GetBucketLifecycleConfigurationFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_bucket_lifecycle_configuration::builders::GetBucketLifecycleConfigurationFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_bucket_lifecycle_configuration::builders::GetBucketLifecycleConfigurationFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket for which to get the lifecycle information.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_bucket_lifecycle_configuration::builders::GetBucketLifecycleConfigurationFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_bucket_lifecycle_configuration::builders::GetBucketLifecycleConfigurationFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><note>  <p>This parameter applies to general purpose buckets only. It is not supported for directory bucket lifecycle configurations.</p> </note><br>
    /// - On success, responds with [`GetBucketLifecycleConfigurationOutput`](crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationOutput) with field(s):
    ///   - [`rules(Option<Vec::<LifecycleRule>>)`](crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationOutput::rules): <p>Container for a lifecycle rule.</p>
    ///   - [`transition_default_minimum_object_size(Option<TransitionDefaultMinimumObjectSize>)`](crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationOutput::transition_default_minimum_object_size): <p>Indicates which default minimum object size behavior is applied to the lifecycle configuration.</p><note>  <p>This parameter applies to general purpose buckets only. It isn't supported for directory bucket lifecycle configurations.</p> </note> <ul>  <li>   <p><code>all_storage_classes_128K</code> - Objects smaller than 128 KB will not transition to any storage class by default.</p></li>  <li>   <p><code>varies_by_storage_class</code> - Objects smaller than 128 KB will transition to Glacier Flexible Retrieval or Glacier Deep Archive storage classes. By default, all other storage classes will prevent transitions smaller than 128 KB.</p></li> </ul> <p>To customize the minimum object size for any transition you can add a filter that specifies a custom <code>ObjectSizeGreaterThan</code> or <code>ObjectSizeLessThan</code> in the body of your transition rule. Custom filters always take precedence over the default transition behavior.</p>
    /// - On failure, responds with [`SdkError<GetBucketLifecycleConfigurationError>`](crate::operation::get_bucket_lifecycle_configuration::GetBucketLifecycleConfigurationError)
    pub fn get_bucket_lifecycle_configuration(
        &self,
    ) -> crate::operation::get_bucket_lifecycle_configuration::builders::GetBucketLifecycleConfigurationFluentBuilder {
        crate::operation::get_bucket_lifecycle_configuration::builders::GetBucketLifecycleConfigurationFluentBuilder::new(self.handle.clone())
    }
}
