/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_wo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BY = "Belaris";
        final String metaValue_MT = "Malt";
        final String metaValue_la = "Latin";
        final String metaValue_BE = "Belsig";
        final Object[][] data = new Object[][] {
            { "001", "àddina" },
            { "002", "Africa" },
            { "003", "North America" },
            { "005", "Amerique du Sud" },
            { "009", "Oseani" },
            { "011", "Sowwu Afrique" },
            { "013", "Amerique Centrale" },
            { "014", "Penku Afrique" },
            { "015", "Afrique du Nord" },
            { "017", "Moyen Afrique" },
            { "018", "Afrique du Sud" },
            { "019", "Amerika" },
            { "021", "amerique du nord" },
            { "029", "Caraïbe" },
            { "030", "Asie penku" },
            { "034", "Asie du Sud" },
            { "035", "Asie Sud-est" },
            { "039", "Sud Europe" },
            { "053", "Ostralasi" },
            { "054", "Melanesi" },
            { "057", "Mikronesi" },
            { "061", "Polineesi" },
            { "142", "Asia" },
            { "143", "Asie centrale" },
            { "145", "Asie sowwu jàng" },
            { "150", "Europe" },
            { "151", "Europe bu penku" },
            { "154", "Europe du nord" },
            { "155", "Europe sowwu jàng" },
            { "202", "Afrique sub-saharienne" },
            { "419", "Amerique Latine" },
            { "AC", "Ile Ascension" },
            { "AD", "Andoor" },
            { "AE", "Emira Arab Ini" },
            { "AF", "Afganistaŋ" },
            { "AG", "Antiguwa ak Barbuda" },
            { "AI", "Angiiy" },
            { "AL", "Albani" },
            { "AM", "Armeni" },
            { "AO", "Àngolaa" },
            { "AQ", "Antarktik" },
            { "AR", "Arsàntin" },
            { "AS", "Samowa bu Amerig" },
            { "AT", "Ótiriis" },
            { "AU", "Ostarali" },
            { "AW", "Aruba" },
            { "AX", "Duni Aalànd" },
            { "AZ", "Aserbayjaŋ" },
            { "BA", "Bosni Ersegowin" },
            { "BB", "Barbad" },
            { "BD", "Bengalades" },
            { "BE", metaValue_BE },
            { "BF", "Burkina Faaso" },
            { "BG", "Bilgari" },
            { "BH", "Bahreyin" },
            { "BI", "Burundi" },
            { "BJ", "Benee" },
            { "BL", "Saŋ Bartalemi" },
            { "BM", "Bermid" },
            { "BN", "Burney" },
            { "BO", "Boliwi" },
            { "BQ", "Pays-Bas bu Caraïbe" },
            { "BR", "Beresil" },
            { "BS", "Bahamas" },
            { "BT", "Butaŋ" },
            { "BV", "Dunu Buwet" },
            { "BW", "Botswana" },
            { "BY", metaValue_BY },
            { "BZ", "Belis" },
            { "CA", "Kanadaa" },
            { "CC", "Duni Koko (Kilin)" },
            { "CD", "Kongo (R K D)" },
            { "CF", "Repiblik Sàntar Afrik" },
            { "CG", "Réewum Kongo" },
            { "CH", "Siwis" },
            { "CI", "Kodiwaar" },
            { "CK", "Duni Kuuk" },
            { "CL", "Sili" },
            { "CM", "Kamerun" },
            { "CN", "Siin" },
            { "CO", "Kolombi" },
            { "CP", "Ile Clipperton" },
            { "CQ", "Guernsey Pound" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabo Werde" },
            { "CW", "Kursawo" },
            { "CX", "Dunu Kirismas" },
            { "CY", "Siipar" },
            { "CZ", "Réewum Cek" },
            { "DE", "Almaañ" },
            { "DG", "Garsiya" },
            { "DJ", "Jibuti" },
            { "DK", "Danmàrk" },
            { "DM", "Dominik" },
            { "DO", "Repiblik Dominiken" },
            { "DZ", "Alseri" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ekwaatër" },
            { "EE", "Estoni" },
            { "EG", "Esipt" },
            { "EH", "Sahara bu sowwu" },
            { "ER", "Eritere" },
            { "ES", "Españ" },
            { "ET", "Ecopi" },
            { "EU", "EZ" },
            { "EZ", "Eurozone" },
            { "FI", "Finlànd" },
            { "FJ", "Fijji" },
            { "FK", "Duni Falkland" },
            { "FM", "Mikoronesi" },
            { "FO", "Duni Faro" },
            { "FR", "Faraans" },
            { "GA", "Gaboŋ" },
            { "GB", "Ruwaayom Ini" },
            { "GD", "Garanad" },
            { "GE", "Seworsi" },
            { "GF", "Guyaan Farañse" },
            { "GG", "Gernase" },
            { "GH", "Gana" },
            { "GI", "Sibraltaar" },
            { "GL", "Girinlànd" },
            { "GM", "Gàmbi" },
            { "GN", "Gine" },
            { "GP", "Guwaadelup" },
            { "GQ", "Gine Ekuwatoriyal" },
            { "GR", "Gerees" },
            { "GS", "Seworsi di Sid ak Duni Sàndwiis di Sid" },
            { "GT", "Guwatemala" },
            { "GU", "Guwam" },
            { "GW", "Gine-Bisaawóo" },
            { "GY", "Giyaan" },
            { "HK", "Ooŋ Koŋ" },
            { "HM", "Duni Hërd ak Duni MakDonald" },
            { "HN", "Onduraas" },
            { "HR", "Korowasi" },
            { "HT", "Ayti" },
            { "HU", "Ongari" },
            { "IC", "Ile Canary" },
            { "ID", "Indonesi" },
            { "IE", "Irlànd" },
            { "IL", "Israyel" },
            { "IM", "Dunu Maan" },
            { "IN", "End" },
            { "IO", "Terituwaaru Brëtaañ ci Oseyaa Enjeŋ" },
            { "IQ", "Irag" },
            { "IR", "Iraŋ" },
            { "IS", "Islànd" },
            { "IT", "Itali" },
            { "JE", "Serse" },
            { "JM", "Samayig" },
            { "JO", "Sordani" },
            { "JP", "Sàppoŋ" },
            { "KE", "Keeña" },
            { "KG", "Kirgistaŋ" },
            { "KH", "Kàmboj" },
            { "KI", "Kiribati" },
            { "KM", "Komoor" },
            { "KN", "Saŋ Kits ak Newis" },
            { "KP", "Kore Noor" },
            { "KR", "Corée du Sud" },
            { "KW", "Kowet" },
            { "KY", "Duni Kaymaŋ" },
            { "KZ", "Kasaxstaŋ" },
            { "LA", "Lawos" },
            { "LB", "Libaa" },
            { "LC", "Saŋ Lusi" },
            { "LI", "Liktensteyin" },
            { "LK", "Siri Lànka" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "LT", "Litiyani" },
            { "LU", "Liksàmbur" },
            { "LV", "Letoni" },
            { "LY", "Libi" },
            { "MA", "Marog" },
            { "MC", "Monako" },
            { "MD", "Moldawi" },
            { "ME", "Montenegoro" },
            { "MF", "Saŋ Marteŋ" },
            { "MG", "Madagaskaar" },
            { "MH", "Duni Marsaal" },
            { "MK", "Maseduwaan bëj Gànnaar" },
            { "ML", "Mali" },
            { "MM", "Miyanmaar" },
            { "MN", "Mongoli" },
            { "MO", "Makaawo" },
            { "MP", "Duni Mariyaan Noor" },
            { "MQ", "Martinik" },
            { "MR", "Mooritani" },
            { "MS", "Mooseraa" },
            { "MT", metaValue_MT },
            { "MU", "Moriis" },
            { "MV", "Maldiiw" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesi" },
            { "MZ", "Mosàmbig" },
            { "NA", "Namibi" },
            { "NC", "Nuwel Kaledoni" },
            { "NE", "Niiseer" },
            { "NF", "Dunu Norfolk" },
            { "NG", "Niseriya" },
            { "NI", "Nikaraguwa" },
            { "NL", "Peyi Baa" },
            { "NO", "Norwees" },
            { "NP", "Nepaal" },
            { "NR", "Nawru" },
            { "NU", "Niw" },
            { "NZ", "Nuwel Selànd" },
            { "OM", "Omaan" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinesi Farañse" },
            { "PG", "Papuwasi Gine Gu Bees" },
            { "PH", "Filipin" },
            { "PK", "Pakistaŋ" },
            { "PL", "Poloñ" },
            { "PM", "Saŋ Peer ak Mikeloŋ" },
            { "PN", "Duni Pitkayirn" },
            { "PR", "Porto Riko" },
            { "PS", "réew yu Palestine" },
            { "PT", "Portigaal" },
            { "PW", "Palaw" },
            { "PY", "Paraguwe" },
            { "QA", "Kataar" },
            { "QO", "Oceanie" },
            { "RE", "Reeñoo" },
            { "RO", "Rumani" },
            { "RS", "Serbi" },
            { "RU", "Risi" },
            { "RW", "Ruwànda" },
            { "SA", "Arabi Sawudi" },
            { "SB", "Duni Salmoon" },
            { "SC", "Seysel" },
            { "SD", "Sudaŋ" },
            { "SE", "Suwed" },
            { "SG", "Singapuur" },
            { "SH", "Saŋ Eleen" },
            { "SI", "Esloweni" },
            { "SJ", "Swalbaar ak Jan Mayen" },
            { "SK", "Eslowaki" },
            { "SL", "Siyera Lewon" },
            { "SM", "San Marino" },
            { "SN", "Senegaal" },
            { "SO", "Somali" },
            { "SR", "Sirinam" },
            { "SS", "Sudaŋ di Sid" },
            { "ST", "Sawo Tome ak Pirinsipe" },
            { "SV", "El Salwadoor" },
            { "SX", "Sin Marten" },
            { "SY", "Siri" },
            { "SZ", "Suwasilànd" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Duni Tirk ak Kaykos" },
            { "TD", "Càdd" },
            { "TF", "Teer Ostraal gu Fraas" },
            { "TG", "Togo" },
            { "TH", "Taylànd" },
            { "TJ", "Tajikistaŋ" },
            { "TK", "Tokoloo" },
            { "TL", "Timor Leste" },
            { "TM", "Tirkmenistaŋ" },
            { "TN", "Tinisi" },
            { "TO", "Tonga" },
            { "TR", "Tirki" },
            { "TT", "Tirinite ak Tobago" },
            { "TV", "Tuwalo" },
            { "TW", "Taywan" },
            { "TZ", "Taŋsani" },
            { "UA", "Ikeren" },
            { "UG", "Ugànda" },
            { "UM", "Duni Amerig Utar meer" },
            { "UN", "United Nations" },
            { "US", "Etaa Sini" },
            { "UY", "Uruge" },
            { "UZ", "Usbekistaŋ" },
            { "VA", "Site bu Watikaa" },
            { "VC", "Saŋ Weesaa ak Garanadin" },
            { "VE", "Wenesiyela" },
            { "VG", "Duni Wirsin yu Brëtaañ" },
            { "VI", "Duni Wirsin yu Etaa-sini" },
            { "VN", "Wiyetnam" },
            { "VU", "Wanuatu" },
            { "WF", "Walis ak Futuna" },
            { "WS", "Samowa" },
            { "XA", "Pseudo-aksan" },
            { "XB", "Pseudo-bidi" },
            { "XK", "Kosowo" },
            { "YE", "Yaman" },
            { "YT", "Mayot" },
            { "ZA", "Afrik di Sid" },
            { "ZM", "Sàmbi" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Gox buñ xamul" },
            { "af", "Afrikaans" },
            { "am", "Amharik" },
            { "ar", "Arabic" },
            { "as", "Asame" },
            { "az", "Aserbayjane" },
            { "ba", "Baskir" },
            { "be", metaValue_BY },
            { "bg", "Bilgaar" },
            { "bn", "Baŋla" },
            { "bo", "Tibetan" },
            { "br", "Breton" },
            { "bs", "Bosñak" },
            { "ca", "Katalan" },
            { "co", "Kors" },
            { "cs", "Cek" },
            { "cy", "Wels" },
            { "da", "Danuwa" },
            { "de", "Almaa" },
            { "dv", "Diweyi" },
            { "dz", "Dsongkaa" },
            { "el", "Gereg" },
            { "en", "Àngale" },
            { "eo", "Esperantoo" },
            { "es", "Español" },
            { "et", "Estoñiye" },
            { "eu", "Bask" },
            { "fa", "Pers" },
            { "ff", "Pël" },
            { "fi", "Feylànde" },
            { "fo", "Feroos" },
            { "fr", "Farañse" },
            { "ga", "Irlànde" },
            { "gd", "Galuwaa bu Ekos" },
            { "gl", "Galisiye" },
            { "gn", "Garani" },
            { "gu", "Gujarati" },
            { "ha", "Hawsa" },
            { "he", "Ebrë" },
            { "hi", "Endo" },
            { "hr", "Krowat" },
            { "ht", "Kereyolu Ayti" },
            { "hu", "Ongruwaa" },
            { "hy", "Armaniye" },
            { "hz", "Herero" },
            { "id", "Endonesiye" },
            { "ig", "Igbo" },
            { "is", "Islànde" },
            { "it", "Italiye" },
            { "iu", "Inuktitit" },
            { "ja", "Sapone" },
            { "ka", "Sorsiye" },
            { "kk", "Kasax" },
            { "km", "Xmer" },
            { "kn", "Kannadaa" },
            { "ko", "Koreye" },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdi" },
            { "ky", "Kirgiis" },
            { "la", metaValue_la },
            { "lb", "Liksàmbursuwaa" },
            { "lo", "Laaw" },
            { "lt", "Lituyaniye" },
            { "lv", "Letoniye" },
            { "mg", "Malagasi" },
            { "mi", "Mawri" },
            { "mk", "Maseduwaane" },
            { "ml", "Malayalam" },
            { "mn", "Mongoliye" },
            { "mr", "Marati" },
            { "ms", "Malay" },
            { "mt", metaValue_MT },
            { "my", "Birmes" },
            { "ne", "Nepale" },
            { "nl", "Neyerlànde" },
            { "no", "Nerwesiye" },
            { "ny", "Sewa" },
            { "oc", "Ositan" },
            { "om", "Oromo" },
            { "or", "Oja" },
            { "pa", "Punjabi" },
            { "pl", "Polone" },
            { "ps", "Pasto" },
            { "pt", "Purtugees" },
            { "qu", "Kesuwa" },
            { "rm", "Romaas" },
            { "ro", "Rumaniyee" },
            { "ru", "Rus" },
            { "rw", "Kinyarwànda" },
            { "sa", "Sanskrit" },
            { "sd", "Sindi" },
            { "se", "Penku Sami" },
            { "si", "Sinala" },
            { "sk", "Eslowaki (Eslowak)" },
            { "sl", "Esloweniye" },
            { "so", "Somali (làkk)" },
            { "sq", "Albane" },
            { "sr", "Serb" },
            { "sv", "Suweduwaa" },
            { "ta", "Tamil" },
            { "te", "Telugu" },
            { "tg", "Tajis" },
            { "th", "Tay" },
            { "ti", "Tigriña" },
            { "tk", "Tirkmen" },
            { "to", "Tongan" },
            { "tr", "Tirk" },
            { "tt", "Tatar" },
            { "ug", "Uygur" },
            { "uk", "Ikreniye" },
            { "ur", "Urdu" },
            { "uz", "Usbek" },
            { "ve", "Wenda" },
            { "vi", "Wiyetnaamiye" },
            { "wo", "Wolof" },
            { "yi", "Yidis" },
            { "yo", "Yoruba" },
            { "zh", "Sinuwaa" },
            { "ban", "Bali" },
            { "bem", "Bemba" },
            { "ceb", "Sibiyanoo" },
            { "chm", "Mari" },
            { "chr", "Ceroki" },
            { "ckb", "Kurdi gu Diggu" },
            { "dsb", "Sorab-Suuf" },
            { "fil", "Filipiye" },
            { "haw", "Hawaye" },
            { "hil", "Hiligaynon" },
            { "hsb", "Sorab-Kaw" },
            { "ibb", "Ibibiyo" },
            { "kok", "Konkani" },
            { "kru", "Kuruks" },
            { "men", "Mende" },
            { "mni", "Manipuri" },
            { "moh", "Mowak" },
            { "niu", "Niweyan" },
            { "pap", "Papiyamento" },
            { "quc", "Kishe" },
            { "sah", "Saxa" },
            { "sat", "Santali" },
            { "sma", "Sami gu Saalum" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Eskolt Sami" },
            { "syr", "Siryak" },
            { "tzm", "Tamasis gu Digg Atlaas" },
            { "und", "Làkk wuñ xamul" },
            { "Arab", "Araab" },
            { "Cyrl", "Sirilik" },
            { "Hans", "Buñ woyofal" },
            { "Hant", "Cosaan" },
            { "Jpan", "Nihon no" },
            { "Kore", "hangug-ui" },
            { "Latn", metaValue_la },
            { "Zxxx", "Luñ bindul" },
            { "Zzzz", "Mbind muñ xamul" },
            { "de_AT", "Almaa bu Ótiriis" },
            { "de_CH", "Almaa bu Kawe bu Swis" },
            { "en_AU", "Àngale bu Óstraali" },
            { "en_CA", "Àngale bu Kanadaa" },
            { "en_GB", "Àngale bu Grànd Brëtaañ" },
            { "en_US", "Àngale bu Amerik" },
            { "es_ES", "Español bu Tugël" },
            { "es_MX", "Español bu Meksik" },
            { "fr_CA", "Frañse bu Kanadaa" },
            { "fr_CH", "Frañse bu Swis" },
            { "nl_BE", metaValue_BE },
            { "pt_BR", "Purtugees bu Bresil" },
            { "pt_PT", "Portugees bu Tugël" },
            { "es_419", "Español bu Amerik Latin" },
            { "hi_Latn", "Hindī" },
            { "zh_Hans", "Sinuwaa buñ woyofal" },
            { "zh_Hant", "Sinuwaa bu cosaan" },
            { "type.nu.latn", "Siifari Tugal" },
            { "type.ca.iso8601", "ISO-8601 Calendar" },
            { "type.co.standard", "SSO (Toftalin wiñ gën a xam)" },
            { "type.ca.gregorian", "Arminaatu Gregoriyee" },
        };
        return data;
    }
}
