/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (c) 2025 Samsung Electronics Co., Ltd.
 *             https://www.samsung.com
 * Copyright (c) 2025 Axis Communications AB.
 *             https://www.axis.com
 *
 * Device Tree binding constants for ARTPEC-8 clock controller.
 */

#ifndef _DT_BINDINGS_CLOCK_ARTPEC8_H
#define _DT_BINDINGS_CLOCK_ARTPEC8_H

/* CMU_CMU */
#define CLK_FOUT_SHARED0_PLL					1
#define CLK_DOUT_SHARED0_DIV2					2
#define CLK_DOUT_SHARED0_DIV3					3
#define CLK_DOUT_SHARED0_DIV4					4
#define CLK_FOUT_SHARED1_PLL					5
#define CLK_DOUT_SHARED1_DIV2					6
#define CLK_DOUT_SHARED1_DIV3					7
#define CLK_DOUT_SHARED1_DIV4					8
#define CLK_FOUT_AUDIO_PLL					9
#define CLK_DOUT_CMU_BUS					10
#define CLK_DOUT_CMU_BUS_DLP					11
#define CLK_DOUT_CMU_CDC_CORE					12
#define CLK_DOUT_CMU_OTP					13
#define CLK_DOUT_CMU_CORE_MAIN					14
#define CLK_DOUT_CMU_CORE_DLP					15
#define CLK_DOUT_CMU_CPUCL_SWITCH				16
#define CLK_DOUT_CMU_DLP_CORE					17
#define CLK_DOUT_CMU_FSYS_BUS					18
#define CLK_DOUT_CMU_FSYS_IP					19
#define CLK_DOUT_CMU_FSYS_SCAN0					20
#define CLK_DOUT_CMU_FSYS_SCAN1					21
#define CLK_DOUT_CMU_GPU_3D					22
#define CLK_DOUT_CMU_GPU_2D					23
#define CLK_DOUT_CMU_IMEM_ACLK					24
#define CLK_DOUT_CMU_IMEM_JPEG					25
#define CLK_DOUT_CMU_MIF_SWITCH					26
#define CLK_DOUT_CMU_MIF_BUSP					27
#define CLK_DOUT_CMU_PERI_DISP					28
#define CLK_DOUT_CMU_PERI_IP					29
#define CLK_DOUT_CMU_PERI_AUDIO					30
#define CLK_DOUT_CMU_RSP_CORE					31
#define CLK_DOUT_CMU_TRFM_CORE					32
#define CLK_DOUT_CMU_VCA_ACE					33
#define CLK_DOUT_CMU_VCA_OD					34
#define CLK_DOUT_CMU_VIO_CORE					35
#define CLK_DOUT_CMU_VIO_AUDIO					36
#define CLK_DOUT_CMU_VIP0_CORE					37
#define CLK_DOUT_CMU_VIP1_CORE					38
#define CLK_DOUT_CMU_VPP_CORE					39

/* CMU_BUS */
#define CLK_MOUT_BUS_ACLK_USER					1
#define CLK_MOUT_BUS_DLP_USER					2
#define CLK_DOUT_BUS_PCLK					3

/* CMU_CORE */
#define CLK_MOUT_CORE_ACLK_USER					1
#define CLK_MOUT_CORE_DLP_USER					2
#define CLK_DOUT_CORE_PCLK					3

/* CMU_CPUCL */
#define CLK_FOUT_CPUCL_PLL					1
#define CLK_MOUT_CPUCL_PLL					2
#define CLK_MOUT_CPUCL_SWITCH_USER				3
#define CLK_DOUT_CPUCL_CPU					4
#define CLK_DOUT_CPUCL_CLUSTER_ACLK				5
#define CLK_DOUT_CPUCL_CLUSTER_PCLKDBG				6
#define CLK_DOUT_CPUCL_CLUSTER_CNTCLK				7
#define CLK_DOUT_CPUCL_CLUSTER_ATCLK				8
#define CLK_DOUT_CPUCL_PCLK					9
#define CLK_DOUT_CPUCL_CMUREF					10
#define CLK_DOUT_CPUCL_DBG					11
#define CLK_DOUT_CPUCL_PCLKDBG					12
#define CLK_GOUT_CPUCL_CLUSTER_CPU				13
#define CLK_GOUT_CPUCL_SHORTSTOP				14
#define CLK_GOUT_CPUCL_CSSYS_IPCLKPORT_PCLKDBG			15
#define CLK_GOUT_CPUCL_CSSYS_IPCLKPORT_ATCLK			16

/* CMU_FSYS */
#define CLK_FOUT_FSYS_PLL					1
#define CLK_MOUT_FSYS_SCAN0_USER				2
#define CLK_MOUT_FSYS_SCAN1_USER				3
#define CLK_MOUT_FSYS_BUS_USER					4
#define CLK_MOUT_FSYS_MMC_USER					5
#define CLK_DOUT_FSYS_PCIE_PIPE					6
#define CLK_DOUT_FSYS_ADC					7
#define CLK_DOUT_FSYS_PCIE_PHY_REFCLK_SYSPLL			8
#define CLK_DOUT_FSYS_EQOS_INT125				9
#define CLK_DOUT_FSYS_OTP_MEM					10
#define CLK_DOUT_FSYS_SCLK_UART					11
#define CLK_DOUT_FSYS_EQOS_25					12
#define CLK_DOUT_FSYS_EQOS_2p5					13
#define CLK_DOUT_FSYS_BUS300					14
#define CLK_DOUT_FSYS_BUS_QSPI					15
#define CLK_DOUT_FSYS_MMC_CARD0					16
#define CLK_DOUT_FSYS_MMC_CARD1					17
#define CLK_DOUT_SCAN_CLK_FSYS_125				18
#define CLK_DOUT_FSYS_QSPI					19
#define CLK_DOUT_FSYS_SFMC_NAND					20
#define CLK_DOUT_FSYS_SCAN_CLK_MMC				21
#define CLK_GOUT_FSYS_USB20DRD_IPCLKPORT_ACLK_PHYCTRL_20	22
#define CLK_GOUT_FSYS_USB20DRD_IPCLKPORT_BUS_CLK_EARLY		23
#define CLK_GOUT_FSYS_XHB_USB_IPCLKPORT_CLK			24
#define CLK_GOUT_FSYS_XHB_AHBBR_IPCLKPORT_CLK			25
#define CLK_GOUT_FSYS_I2C0_IPCLKPORT_I_PCLK			26
#define CLK_GOUT_FSYS_I2C1_IPCLKPORT_I_PCLK			27
#define CLK_GOUT_FSYS_PWM_IPCLKPORT_I_PCLK_S0			28
#define CLK_GOUT_FSYS_DWC_PCIE_CTL_INST_0_MSTR_ACLK_UG		29
#define CLK_GOUT_FSYS_DWC_PCIE_CTL_INXT_0_SLV_ACLK_UG		30
#define CLK_GOUT_FSYS_DWC_PCIE_CTL_INST_0_DBI_ACLK_UG		31
#define CLK_GOUT_FSYS_PIPE_PAL_INST_0_I_APB_PCLK		32
#define CLK_GOUT_FSYS_EQOS_TOP_IPCLKPORT_ACLK_I			33
#define CLK_GOUT_FSYS_EQOS_TOP_IPCLKPORT_CLK_CSR_I		34
#define CLK_GOUT_FSYS_EQOS_TOP_IPCLKPORT_I_RGMII_TXCLK_2P5	35
#define CLK_GOUT_FSYS_SFMC_IPCLKPORT_I_ACLK_NAND		36
#define CLK_GOUT_FSYS_MMC0_IPCLKPORT_SDCLKIN			37
#define CLK_GOUT_FSYS_MMC0_IPCLKPORT_I_ACLK			38
#define CLK_GOUT_FSYS_MMC1_IPCLKPORT_SDCLKIN			39
#define CLK_GOUT_FSYS_MMC1_IPCLKPORT_I_ACLK			40
#define CLK_GOUT_FSYS_PCIE_PHY_REFCLK_IN			41
#define CLK_GOUT_FSYS_UART0_PCLK				42
#define CLK_GOUT_FSYS_UART0_SCLK_UART				43
#define CLK_GOUT_FSYS_BUS_QSPI					44
#define CLK_GOUT_FSYS_QSPI_IPCLKPORT_HCLK			45
#define CLK_GOUT_FSYS_QSPI_IPCLKPORT_SSI_CLK			46

/* CMU_IMEM */
#define CLK_MOUT_IMEM_ACLK_USER					1
#define CLK_MOUT_IMEM_GIC_CA53					2
#define CLK_MOUT_IMEM_GIC_CA5					3
#define CLK_MOUT_IMEM_JPEG_USER					4
#define CLK_GOUT_IMEM_MCT_PCLK					5
#define CLK_GOUT_IMEM_PCLK_TMU0_APBIF				6

/* CMU_PERI */
#define CLK_MOUT_PERI_IP_USER					1
#define CLK_MOUT_PERI_AUDIO_USER				2
#define CLK_MOUT_PERI_I2S0					3
#define CLK_MOUT_PERI_I2S1					4
#define CLK_MOUT_PERI_DISP_USER					5
#define CLK_DOUT_PERI_SPI					6
#define CLK_DOUT_PERI_UART1					7
#define CLK_DOUT_PERI_UART2					8
#define CLK_DOUT_PERI_PCLK					9
#define CLK_DOUT_PERI_I2S0					10
#define CLK_DOUT_PERI_I2S1					11
#define CLK_DOUT_PERI_DSIM					12
#define CLK_GOUT_PERI_UART1_PCLK				13
#define CLK_GOUT_PERI_UART1_SCLK_UART				14
#define CLK_GOUT_PERI_UART2_PCLK				15
#define CLK_GOUT_PERI_UART2_SCLK_UART				16
#define CLK_GOUT_PERI_I2C2_IPCLKPORT_I_PCLK			17
#define CLK_GOUT_PERI_I2C3_IPCLKPORT_I_PCLK			18
#define CLK_GOUT_PERI_SPI0_PCLK					19
#define CLK_GOUT_PERI_SPI0_SCLK_SPI				20
#define CLK_GOUT_PERI_APB_ASYNC_DSIM_IPCLKPORT_PCLKS		21
#define CLK_GOUT_PERI_I2SSC0_IPCLKPORT_CLK_HST			22
#define CLK_GOUT_PERI_I2SSC1_IPCLKPORT_CLK_HST			23
#define CLK_GOUT_PERI_AUDIO_OUT_IPCLKPORT_CLK			24
#define CLK_GOUT_PERI_I2SSC0_IPCLKPORT_CLK			25
#define CLK_GOUT_PERI_I2SSC1_IPCLKPORT_CLK			26
#define CLK_GOUT_PERI_DMA4DSIM_IPCLKPORT_CLK_APB_CLK		27
#define CLK_GOUT_PERI_DMA4DSIM_IPCLKPORT_CLK_AXI_CLK		28

#endif /* _DT_BINDINGS_CLOCK_ARTPEC8_H */
