// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v5.29.2
// source: envoy/extensions/filters/http/ext_proc/v3/ext_proc.proto

package ext_procv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/cncf/xds/go/xds/annotations/v3"
	v31 "github.com/envoyproxy/go-control-plane/envoy/config/common/mutation_rules/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v32 "github.com/envoyproxy/go-control-plane/envoy/type/matcher/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Describes the route cache action to be taken when an external processor response
// is received in response to request headers.
type ExternalProcessor_RouteCacheAction int32

const (
	// The default behavior is to clear the route cache only when the
	// :ref:`clear_route_cache <envoy_v3_api_field_service.ext_proc.v3.CommonResponse.clear_route_cache>`
	// field is set in an external processor response.
	ExternalProcessor_DEFAULT ExternalProcessor_RouteCacheAction = 0
	// Always clear the route cache irrespective of the clear_route_cache bit in
	// the external processor response.
	ExternalProcessor_CLEAR ExternalProcessor_RouteCacheAction = 1
	// Do not clear the route cache irrespective of the clear_route_cache bit in
	// the external processor response. Setting to RETAIN is equivalent to set the
	// :ref:`disable_clear_route_cache <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.disable_clear_route_cache>`
	// to true.
	ExternalProcessor_RETAIN ExternalProcessor_RouteCacheAction = 2
)

// Enum value maps for ExternalProcessor_RouteCacheAction.
var (
	ExternalProcessor_RouteCacheAction_name = map[int32]string{
		0: "DEFAULT",
		1: "CLEAR",
		2: "RETAIN",
	}
	ExternalProcessor_RouteCacheAction_value = map[string]int32{
		"DEFAULT": 0,
		"CLEAR":   1,
		"RETAIN":  2,
	}
)

func (x ExternalProcessor_RouteCacheAction) Enum() *ExternalProcessor_RouteCacheAction {
	p := new(ExternalProcessor_RouteCacheAction)
	*p = x
	return p
}

func (x ExternalProcessor_RouteCacheAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExternalProcessor_RouteCacheAction) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_enumTypes[0].Descriptor()
}

func (ExternalProcessor_RouteCacheAction) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_enumTypes[0]
}

func (x ExternalProcessor_RouteCacheAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExternalProcessor_RouteCacheAction.Descriptor instead.
func (ExternalProcessor_RouteCacheAction) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP(), []int{0, 0}
}

// The filter communicates with an external gRPC service called an "external processor"
// that can do a variety of things with the request and response:
//
// * Access and modify the HTTP headers on the request, response, or both
// * Access and modify the HTTP request and response bodies
// * Access and modify the dynamic stream metadata
// * Immediately send an HTTP response downstream and terminate other processing
//
// The filter communicates with the server using a gRPC bidirectional stream. After the initial
// request, the external server is in control over what additional data is sent to it
// and how it should be processed.
//
// By implementing the protocol specified by the stream, the external server can choose:
//
//   - Whether it receives the response message at all
//   - Whether it receives the message body at all, in separate chunks, or as a single buffer
//   - Whether subsequent HTTP requests are transmitted synchronously or whether they are
//     sent asynchronously.
//   - To modify request or response trailers if they already exist
//
// The filter supports up to six different processing steps. Each is represented by
// a gRPC stream message that is sent to the external processor. For each message, the
// processor must send a matching response.
//
//   - Request headers: Contains the headers from the original HTTP request.
//   - Request body: Delivered if they are present and sent in a single message if
//     the BUFFERED or BUFFERED_PARTIAL mode is chosen, in multiple messages if the
//     STREAMED mode is chosen, and not at all otherwise.
//   - Request trailers: Delivered if they are present and if the trailer mode is set
//     to SEND.
//   - Response headers: Contains the headers from the HTTP response. Keep in mind
//     that if the upstream system sends them before processing the request body that
//     this message may arrive before the complete body.
//   - Response body: Sent according to the processing mode like the request body.
//   - Response trailers: Delivered according to the processing mode like the
//     request trailers.
//
// By default, the processor sends only the request and response headers messages.
// This may be changed to include any of the six steps by changing the processing_mode
// setting of the filter configuration, or by setting the mode_override of any response
// from the external processor. The latter is only enabled if allow_mode_override is
// set to true. This way, a processor may, for example, use information
// in the request header to determine whether the message body must be examined, or whether
// the proxy should simply stream it straight through.
//
// All of this together allows a server to process the filter traffic in fairly
// sophisticated ways. For example:
//
//   - A server may choose to examine all or part of the HTTP message bodies depending
//     on the content of the headers.
//   - A server may choose to immediately reject some messages based on their HTTP
//     headers (or other dynamic metadata) and more carefully examine others.
//   - A server may asynchronously monitor traffic coming through the filter by inspecting
//     headers, bodies, or both, and then decide to switch to a synchronous processing
//     mode, either permanently or temporarily.
//
// The protocol itself is based on a bidirectional gRPC stream. Envoy will send the
// server
// :ref:`ProcessingRequest <envoy_v3_api_msg_service.ext_proc.v3.ProcessingRequest>`
// messages, and the server must reply with
// :ref:`ProcessingResponse <envoy_v3_api_msg_service.ext_proc.v3.ProcessingResponse>`.
//
// Stats about each gRPC call are recorded in a :ref:`dynamic filter state
// <arch_overview_advanced_filter_state_sharing>` object in a namespace matching the filter
// name.
//
// [#next-free-field: 23]
type ExternalProcessor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for the gRPC service that the filter will communicate with.
	// The filter supports both the "Envoy" and "Google" gRPC clients.
	// Only one of “grpc_service“ or “http_service“ can be set.
	// It is required that one of them must be set.
	GrpcService *v3.GrpcService `protobuf:"bytes,1,opt,name=grpc_service,json=grpcService,proto3" json:"grpc_service,omitempty"`
	// [#not-implemented-hide:]
	// Configuration for the HTTP service that the filter will communicate with.
	// Only one of “http_service“ or
	// :ref:`grpc_service <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.grpc_service>`.
	// can be set. It is required that one of them must be set.
	//
	// If “http_service“ is set, the
	// :ref:`processing_mode <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.processing_mode>`
	// can not be configured to send any body or trailers. i.e, http_service only supports
	// sending request or response headers to the side stream server.
	//
	// With this configuration, Envoy behavior:
	//
	// 1. The headers are first put in a proto message
	// :ref:`ProcessingRequest <envoy_v3_api_msg_service.ext_proc.v3.ProcessingRequest>`.
	//
	// 2. This proto message is then transcoded into a JSON text.
	//
	// 3. Envoy then sends a HTTP POST message with content-type as "application/json",
	// and this JSON text as body to the side stream server.
	//
	// After the side-stream receives this HTTP request message, it is expected to do as follows:
	//
	// 1. It converts the body, which is a JSON string, into a “ProcessingRequest“
	// proto message to examine and mutate the headers.
	//
	// 2. It then sets the mutated headers into a new proto message
	// :ref:`ProcessingResponse <envoy_v3_api_msg_service.ext_proc.v3.ProcessingResponse>`.
	//
	// 3. It converts “ProcessingResponse“ proto message into a JSON text.
	//
	// 4. It then sends a HTTP response back to Envoy with status code as "200",
	// content-type as "application/json" and sets the JSON text as the body.
	HttpService *ExtProcHttpService `protobuf:"bytes,20,opt,name=http_service,json=httpService,proto3" json:"http_service,omitempty"`
	// By default, if the gRPC stream cannot be established, or if it is closed
	// prematurely with an error, the filter will fail. Specifically, if the
	// response headers have not yet been delivered, then it will return a 500
	// error downstream. If they have been delivered, then instead the HTTP stream to the
	// downstream client will be reset.
	// With this parameter set to true, however, then if the gRPC stream is prematurely closed
	// or could not be opened, processing continues without error.
	FailureModeAllow bool `protobuf:"varint,2,opt,name=failure_mode_allow,json=failureModeAllow,proto3" json:"failure_mode_allow,omitempty"`
	// Specifies default options for how HTTP headers, trailers, and bodies are
	// sent. See ProcessingMode for details.
	ProcessingMode *ProcessingMode `protobuf:"bytes,3,opt,name=processing_mode,json=processingMode,proto3" json:"processing_mode,omitempty"`
	// Envoy provides a number of :ref:`attributes <arch_overview_attributes>`
	// for expressive policies. Each attribute name provided in this field will be
	// matched against that list and populated in the request_headers message.
	// See the :ref:`attribute documentation <arch_overview_request_attributes>`
	// for the list of supported attributes and their types.
	RequestAttributes []string `protobuf:"bytes,5,rep,name=request_attributes,json=requestAttributes,proto3" json:"request_attributes,omitempty"`
	// Envoy provides a number of :ref:`attributes <arch_overview_attributes>`
	// for expressive policies. Each attribute name provided in this field will be
	// matched against that list and populated in the response_headers message.
	// See the :ref:`attribute documentation <arch_overview_attributes>`
	// for the list of supported attributes and their types.
	ResponseAttributes []string `protobuf:"bytes,6,rep,name=response_attributes,json=responseAttributes,proto3" json:"response_attributes,omitempty"`
	// Specifies the timeout for each individual message sent on the stream and
	// when the filter is running in synchronous mode. Whenever the proxy sends
	// a message on the stream that requires a response, it will reset this timer,
	// and will stop processing and return an error (subject to the processing mode)
	// if the timer expires before a matching response is received. There is no
	// timeout when the filter is running in asynchronous mode. Zero is a valid
	// config which means the timer will be triggered immediately. If not
	// configured, default is 200 milliseconds.
	MessageTimeout *durationpb.Duration `protobuf:"bytes,7,opt,name=message_timeout,json=messageTimeout,proto3" json:"message_timeout,omitempty"`
	// Optional additional prefix to use when emitting statistics. This allows to distinguish
	// emitted statistics between configured *ext_proc* filters in an HTTP filter chain.
	StatPrefix string `protobuf:"bytes,8,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Rules that determine what modifications an external processing server may
	// make to message headers. If not set, all headers may be modified except
	// for "host", ":authority", ":scheme", ":method", and headers that start
	// with the header prefix set via
	// :ref:`header_prefix <envoy_v3_api_field_config.bootstrap.v3.Bootstrap.header_prefix>`
	// (which is usually "x-envoy").
	// Note that changing headers such as "host" or ":authority" may not in itself
	// change Envoy's routing decision, as routes can be cached. To also force the
	// route to be recomputed, set the
	// :ref:`clear_route_cache <envoy_v3_api_field_service.ext_proc.v3.CommonResponse.clear_route_cache>`
	// field to true in the same response.
	MutationRules *v31.HeaderMutationRules `protobuf:"bytes,9,opt,name=mutation_rules,json=mutationRules,proto3" json:"mutation_rules,omitempty"`
	// Specify the upper bound of
	// :ref:`override_message_timeout <envoy_v3_api_field_service.ext_proc.v3.ProcessingResponse.override_message_timeout>`
	// If not specified, by default it is 0, which will effectively disable the “override_message_timeout“ API.
	MaxMessageTimeout *durationpb.Duration `protobuf:"bytes,10,opt,name=max_message_timeout,json=maxMessageTimeout,proto3" json:"max_message_timeout,omitempty"`
	// Allow headers matching the “forward_rules“ to be forwarded to the external processing server.
	// If not set, all headers are forwarded to the external processing server.
	ForwardRules *HeaderForwardingRules `protobuf:"bytes,12,opt,name=forward_rules,json=forwardRules,proto3" json:"forward_rules,omitempty"`
	// Additional metadata to be added to the filter state for logging purposes. The metadata
	// will be added to StreamInfo's filter state under the namespace corresponding to the
	// ext_proc filter name.
	FilterMetadata *structpb.Struct `protobuf:"bytes,13,opt,name=filter_metadata,json=filterMetadata,proto3" json:"filter_metadata,omitempty"`
	// If “allow_mode_override“ is set to true, the filter config :ref:`processing_mode
	// <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.processing_mode>`
	// can be overridden by the response message from the external processing server
	// :ref:`mode_override <envoy_v3_api_field_service.ext_proc.v3.ProcessingResponse.mode_override>`.
	// If not set, “mode_override“ API in the response message will be ignored.
	AllowModeOverride bool `protobuf:"varint,14,opt,name=allow_mode_override,json=allowModeOverride,proto3" json:"allow_mode_override,omitempty"`
	// If set to true, ignore the
	// :ref:`immediate_response <envoy_v3_api_field_service.ext_proc.v3.ProcessingResponse.immediate_response>`
	// message in an external processor response. In such case, no local reply will be sent.
	// Instead, the stream to the external processor will be closed. There will be no
	// more external processing for this stream from now on.
	DisableImmediateResponse bool `protobuf:"varint,15,opt,name=disable_immediate_response,json=disableImmediateResponse,proto3" json:"disable_immediate_response,omitempty"`
	// Options related to the sending and receiving of dynamic metadata.
	MetadataOptions *MetadataOptions `protobuf:"bytes,16,opt,name=metadata_options,json=metadataOptions,proto3" json:"metadata_options,omitempty"`
	// If true, send each part of the HTTP request or response specified by ProcessingMode
	// without pausing on filter chain iteration. It is "Send and Go" mode that can be used
	// by external processor to observe Envoy data and status. In this mode:
	//
	// 1. Only STREAMED body processing mode is supported and any other body processing modes will be
	// ignored. NONE mode(i.e., skip body processing) will still work as expected.
	//
	// 2. External processor should not send back processing response, as any responses will be ignored.
	// This also means that
	// :ref:`message_timeout <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.message_timeout>`
	// restriction doesn't apply to this mode.
	//
	// 3. External processor may still close the stream to indicate that no more messages are needed.
	//
	// .. warning::
	//
	//	Flow control is necessary mechanism to prevent the fast sender (either downstream client or upstream server)
	//	from overwhelming the external processor when its processing speed is slower.
	//	This protective measure is being explored and developed but has not been ready yet, so please use your own
	//	discretion when enabling this feature.
	//	This work is currently tracked under https://github.com/envoyproxy/envoy/issues/33319.
	ObservabilityMode bool `protobuf:"varint,17,opt,name=observability_mode,json=observabilityMode,proto3" json:"observability_mode,omitempty"`
	// Prevents clearing the route-cache when the
	// :ref:`clear_route_cache <envoy_v3_api_field_service.ext_proc.v3.CommonResponse.clear_route_cache>`
	// field is set in an external processor response.
	// Only one of “disable_clear_route_cache“ or “route_cache_action“ can be set.
	// It is recommended to set “route_cache_action“ which supersedes “disable_clear_route_cache“.
	DisableClearRouteCache bool `protobuf:"varint,11,opt,name=disable_clear_route_cache,json=disableClearRouteCache,proto3" json:"disable_clear_route_cache,omitempty"`
	// Specifies the action to be taken when an external processor response is
	// received in response to request headers. It is recommended to set this field than set
	// :ref:`disable_clear_route_cache <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.disable_clear_route_cache>`.
	// Only one of “disable_clear_route_cache“ or “route_cache_action“ can be set.
	RouteCacheAction ExternalProcessor_RouteCacheAction `protobuf:"varint,18,opt,name=route_cache_action,json=routeCacheAction,proto3,enum=envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor_RouteCacheAction" json:"route_cache_action,omitempty"`
	// Specifies the deferred closure timeout for gRPC stream that connects to external processor. Currently, the deferred stream closure
	// is only used in :ref:`observability_mode <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.observability_mode>`.
	// In observability mode, gRPC streams may be held open to the external processor longer than the lifetime of the regular client to
	// backend stream lifetime. In this case, Envoy will eventually timeout the external processor stream according to this time limit.
	// The default value is 5000 milliseconds (5 seconds) if not specified.
	DeferredCloseTimeout *durationpb.Duration `protobuf:"bytes,19,opt,name=deferred_close_timeout,json=deferredCloseTimeout,proto3" json:"deferred_close_timeout,omitempty"`
	// Send body to the side stream server once it arrives without waiting for the header response from that server.
	// It only works for STREAMED body processing mode. For any other body processing modes, it is ignored.
	// The server has two options upon receiving a header request:
	//
	// 1. Instant Response: send the header response as soon as the header request is received.
	//
	// 2. Delayed Response: wait for the body before sending any response.
	//
	// In all scenarios, the header-body ordering must always be maintained.
	//
	// If enabled Envoy will ignore the
	// :ref:`mode_override <envoy_v3_api_field_service.ext_proc.v3.ProcessingResponse.mode_override>`
	// value that the server sends in the header response. This is because Envoy may have already
	// sent the body to the server, prior to processing the header response.
	SendBodyWithoutWaitingForHeaderResponse bool `protobuf:"varint,21,opt,name=send_body_without_waiting_for_header_response,json=sendBodyWithoutWaitingForHeaderResponse,proto3" json:"send_body_without_waiting_for_header_response,omitempty"`
	// When :ref:`allow_mode_override
	// <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.allow_mode_override>` is enabled and
	// “allowed_override_modes“ is configured, the filter config :ref:`processing_mode
	// <envoy_v3_api_field_extensions.filters.http.ext_proc.v3.ExternalProcessor.processing_mode>`
	// can only be overridden by the response message from the external processing server iff the
	// :ref:`mode_override <envoy_v3_api_field_service.ext_proc.v3.ProcessingResponse.mode_override>` is allowed by
	// the “allowed_override_modes“ allow-list below.
	AllowedOverrideModes []*ProcessingMode `protobuf:"bytes,22,rep,name=allowed_override_modes,json=allowedOverrideModes,proto3" json:"allowed_override_modes,omitempty"`
}

func (x *ExternalProcessor) Reset() {
	*x = ExternalProcessor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalProcessor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalProcessor) ProtoMessage() {}

func (x *ExternalProcessor) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalProcessor.ProtoReflect.Descriptor instead.
func (*ExternalProcessor) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP(), []int{0}
}

func (x *ExternalProcessor) GetGrpcService() *v3.GrpcService {
	if x != nil {
		return x.GrpcService
	}
	return nil
}

func (x *ExternalProcessor) GetHttpService() *ExtProcHttpService {
	if x != nil {
		return x.HttpService
	}
	return nil
}

func (x *ExternalProcessor) GetFailureModeAllow() bool {
	if x != nil {
		return x.FailureModeAllow
	}
	return false
}

func (x *ExternalProcessor) GetProcessingMode() *ProcessingMode {
	if x != nil {
		return x.ProcessingMode
	}
	return nil
}

func (x *ExternalProcessor) GetRequestAttributes() []string {
	if x != nil {
		return x.RequestAttributes
	}
	return nil
}

func (x *ExternalProcessor) GetResponseAttributes() []string {
	if x != nil {
		return x.ResponseAttributes
	}
	return nil
}

func (x *ExternalProcessor) GetMessageTimeout() *durationpb.Duration {
	if x != nil {
		return x.MessageTimeout
	}
	return nil
}

func (x *ExternalProcessor) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *ExternalProcessor) GetMutationRules() *v31.HeaderMutationRules {
	if x != nil {
		return x.MutationRules
	}
	return nil
}

func (x *ExternalProcessor) GetMaxMessageTimeout() *durationpb.Duration {
	if x != nil {
		return x.MaxMessageTimeout
	}
	return nil
}

func (x *ExternalProcessor) GetForwardRules() *HeaderForwardingRules {
	if x != nil {
		return x.ForwardRules
	}
	return nil
}

func (x *ExternalProcessor) GetFilterMetadata() *structpb.Struct {
	if x != nil {
		return x.FilterMetadata
	}
	return nil
}

func (x *ExternalProcessor) GetAllowModeOverride() bool {
	if x != nil {
		return x.AllowModeOverride
	}
	return false
}

func (x *ExternalProcessor) GetDisableImmediateResponse() bool {
	if x != nil {
		return x.DisableImmediateResponse
	}
	return false
}

func (x *ExternalProcessor) GetMetadataOptions() *MetadataOptions {
	if x != nil {
		return x.MetadataOptions
	}
	return nil
}

func (x *ExternalProcessor) GetObservabilityMode() bool {
	if x != nil {
		return x.ObservabilityMode
	}
	return false
}

func (x *ExternalProcessor) GetDisableClearRouteCache() bool {
	if x != nil {
		return x.DisableClearRouteCache
	}
	return false
}

func (x *ExternalProcessor) GetRouteCacheAction() ExternalProcessor_RouteCacheAction {
	if x != nil {
		return x.RouteCacheAction
	}
	return ExternalProcessor_DEFAULT
}

func (x *ExternalProcessor) GetDeferredCloseTimeout() *durationpb.Duration {
	if x != nil {
		return x.DeferredCloseTimeout
	}
	return nil
}

func (x *ExternalProcessor) GetSendBodyWithoutWaitingForHeaderResponse() bool {
	if x != nil {
		return x.SendBodyWithoutWaitingForHeaderResponse
	}
	return false
}

func (x *ExternalProcessor) GetAllowedOverrideModes() []*ProcessingMode {
	if x != nil {
		return x.AllowedOverrideModes
	}
	return nil
}

// ExtProcHttpService is used for HTTP communication between the filter and the external processing service.
type ExtProcHttpService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sets the HTTP service which the external processing requests must be sent to.
	HttpService *v3.HttpService `protobuf:"bytes,1,opt,name=http_service,json=httpService,proto3" json:"http_service,omitempty"`
}

func (x *ExtProcHttpService) Reset() {
	*x = ExtProcHttpService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtProcHttpService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtProcHttpService) ProtoMessage() {}

func (x *ExtProcHttpService) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtProcHttpService.ProtoReflect.Descriptor instead.
func (*ExtProcHttpService) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP(), []int{1}
}

func (x *ExtProcHttpService) GetHttpService() *v3.HttpService {
	if x != nil {
		return x.HttpService
	}
	return nil
}

// The MetadataOptions structure defines options for the sending and receiving of
// dynamic metadata. Specifically, which namespaces to send to the server, whether
// metadata returned by the server may be written, and how that metadata may be written.
type MetadataOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes which typed or untyped dynamic metadata namespaces to forward to
	// the external processing server.
	ForwardingNamespaces *MetadataOptions_MetadataNamespaces `protobuf:"bytes,1,opt,name=forwarding_namespaces,json=forwardingNamespaces,proto3" json:"forwarding_namespaces,omitempty"`
	// Describes which typed or untyped dynamic metadata namespaces to accept from
	// the external processing server. Set to empty or leave unset to disallow writing
	// any received dynamic metadata. Receiving of typed metadata is not supported.
	ReceivingNamespaces *MetadataOptions_MetadataNamespaces `protobuf:"bytes,2,opt,name=receiving_namespaces,json=receivingNamespaces,proto3" json:"receiving_namespaces,omitempty"`
}

func (x *MetadataOptions) Reset() {
	*x = MetadataOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataOptions) ProtoMessage() {}

func (x *MetadataOptions) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataOptions.ProtoReflect.Descriptor instead.
func (*MetadataOptions) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP(), []int{2}
}

func (x *MetadataOptions) GetForwardingNamespaces() *MetadataOptions_MetadataNamespaces {
	if x != nil {
		return x.ForwardingNamespaces
	}
	return nil
}

func (x *MetadataOptions) GetReceivingNamespaces() *MetadataOptions_MetadataNamespaces {
	if x != nil {
		return x.ReceivingNamespaces
	}
	return nil
}

// The HeaderForwardingRules structure specifies what headers are
// allowed to be forwarded to the external processing server.
//
// This works as below:
//
//  1. If neither “allowed_headers“ nor “disallowed_headers“ is set, all headers are forwarded.
//  2. If both “allowed_headers“ and “disallowed_headers“ are set, only headers in the
//     “allowed_headers“ but not in the “disallowed_headers“ are forwarded.
//  3. If “allowed_headers“ is set, and “disallowed_headers“ is not set, only headers in
//     the “allowed_headers“ are forwarded.
//  4. If “disallowed_headers“ is set, and “allowed_headers“ is not set, all headers except
//     headers in the “disallowed_headers“ are forwarded.
type HeaderForwardingRules struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, specifically allow any header in this list to be forwarded to the external
	// processing server. This can be overridden by the below “disallowed_headers“.
	AllowedHeaders *v32.ListStringMatcher `protobuf:"bytes,1,opt,name=allowed_headers,json=allowedHeaders,proto3" json:"allowed_headers,omitempty"`
	// If set, specifically disallow any header in this list to be forwarded to the external
	// processing server. This overrides the above “allowed_headers“ if a header matches both.
	DisallowedHeaders *v32.ListStringMatcher `protobuf:"bytes,2,opt,name=disallowed_headers,json=disallowedHeaders,proto3" json:"disallowed_headers,omitempty"`
}

func (x *HeaderForwardingRules) Reset() {
	*x = HeaderForwardingRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeaderForwardingRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeaderForwardingRules) ProtoMessage() {}

func (x *HeaderForwardingRules) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeaderForwardingRules.ProtoReflect.Descriptor instead.
func (*HeaderForwardingRules) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP(), []int{3}
}

func (x *HeaderForwardingRules) GetAllowedHeaders() *v32.ListStringMatcher {
	if x != nil {
		return x.AllowedHeaders
	}
	return nil
}

func (x *HeaderForwardingRules) GetDisallowedHeaders() *v32.ListStringMatcher {
	if x != nil {
		return x.DisallowedHeaders
	}
	return nil
}

// Extra settings that may be added to per-route configuration for a
// virtual host or cluster.
type ExtProcPerRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Override:
	//
	//	*ExtProcPerRoute_Disabled
	//	*ExtProcPerRoute_Overrides
	Override isExtProcPerRoute_Override `protobuf_oneof:"override"`
}

func (x *ExtProcPerRoute) Reset() {
	*x = ExtProcPerRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtProcPerRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtProcPerRoute) ProtoMessage() {}

func (x *ExtProcPerRoute) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtProcPerRoute.ProtoReflect.Descriptor instead.
func (*ExtProcPerRoute) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP(), []int{4}
}

func (m *ExtProcPerRoute) GetOverride() isExtProcPerRoute_Override {
	if m != nil {
		return m.Override
	}
	return nil
}

func (x *ExtProcPerRoute) GetDisabled() bool {
	if x, ok := x.GetOverride().(*ExtProcPerRoute_Disabled); ok {
		return x.Disabled
	}
	return false
}

func (x *ExtProcPerRoute) GetOverrides() *ExtProcOverrides {
	if x, ok := x.GetOverride().(*ExtProcPerRoute_Overrides); ok {
		return x.Overrides
	}
	return nil
}

type isExtProcPerRoute_Override interface {
	isExtProcPerRoute_Override()
}

type ExtProcPerRoute_Disabled struct {
	// Disable the filter for this particular vhost or route.
	// If disabled is specified in multiple per-filter-configs, the most specific one will be used.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3,oneof"`
}

type ExtProcPerRoute_Overrides struct {
	// Override aspects of the configuration for this route. A set of
	// overrides in a more specific configuration will override a "disabled"
	// flag set in a less-specific one.
	Overrides *ExtProcOverrides `protobuf:"bytes,2,opt,name=overrides,proto3,oneof"`
}

func (*ExtProcPerRoute_Disabled) isExtProcPerRoute_Override() {}

func (*ExtProcPerRoute_Overrides) isExtProcPerRoute_Override() {}

// Overrides that may be set on a per-route basis
// [#next-free-field: 8]
type ExtProcOverrides struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set a different processing mode for this route than the default.
	ProcessingMode *ProcessingMode `protobuf:"bytes,1,opt,name=processing_mode,json=processingMode,proto3" json:"processing_mode,omitempty"`
	// [#not-implemented-hide:]
	// Set a different asynchronous processing option than the default.
	AsyncMode bool `protobuf:"varint,2,opt,name=async_mode,json=asyncMode,proto3" json:"async_mode,omitempty"`
	// [#not-implemented-hide:]
	// Set different optional attributes than the default setting of the
	// “request_attributes“ field.
	RequestAttributes []string `protobuf:"bytes,3,rep,name=request_attributes,json=requestAttributes,proto3" json:"request_attributes,omitempty"`
	// [#not-implemented-hide:]
	// Set different optional properties than the default setting of the
	// “response_attributes“ field.
	ResponseAttributes []string `protobuf:"bytes,4,rep,name=response_attributes,json=responseAttributes,proto3" json:"response_attributes,omitempty"`
	// Set a different gRPC service for this route than the default.
	GrpcService *v3.GrpcService `protobuf:"bytes,5,opt,name=grpc_service,json=grpcService,proto3" json:"grpc_service,omitempty"`
	// Options related to the sending and receiving of dynamic metadata.
	// Lists of forwarding and receiving namespaces will be overridden in their entirety,
	// meaning the most-specific config that specifies this override will be the final
	// config used. It is the prerogative of the control plane to ensure this
	// most-specific config contains the correct final overrides.
	MetadataOptions *MetadataOptions `protobuf:"bytes,6,opt,name=metadata_options,json=metadataOptions,proto3" json:"metadata_options,omitempty"`
	// Additional metadata to include into streams initiated to the ext_proc gRPC
	// service. This can be used for scenarios in which additional ad hoc
	// authorization headers (e.g. “x-foo-bar: baz-key“) are to be injected or
	// when a route needs to partially override inherited metadata.
	GrpcInitialMetadata []*v3.HeaderValue `protobuf:"bytes,7,rep,name=grpc_initial_metadata,json=grpcInitialMetadata,proto3" json:"grpc_initial_metadata,omitempty"`
}

func (x *ExtProcOverrides) Reset() {
	*x = ExtProcOverrides{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtProcOverrides) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtProcOverrides) ProtoMessage() {}

func (x *ExtProcOverrides) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtProcOverrides.ProtoReflect.Descriptor instead.
func (*ExtProcOverrides) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP(), []int{5}
}

func (x *ExtProcOverrides) GetProcessingMode() *ProcessingMode {
	if x != nil {
		return x.ProcessingMode
	}
	return nil
}

func (x *ExtProcOverrides) GetAsyncMode() bool {
	if x != nil {
		return x.AsyncMode
	}
	return false
}

func (x *ExtProcOverrides) GetRequestAttributes() []string {
	if x != nil {
		return x.RequestAttributes
	}
	return nil
}

func (x *ExtProcOverrides) GetResponseAttributes() []string {
	if x != nil {
		return x.ResponseAttributes
	}
	return nil
}

func (x *ExtProcOverrides) GetGrpcService() *v3.GrpcService {
	if x != nil {
		return x.GrpcService
	}
	return nil
}

func (x *ExtProcOverrides) GetMetadataOptions() *MetadataOptions {
	if x != nil {
		return x.MetadataOptions
	}
	return nil
}

func (x *ExtProcOverrides) GetGrpcInitialMetadata() []*v3.HeaderValue {
	if x != nil {
		return x.GrpcInitialMetadata
	}
	return nil
}

type MetadataOptions_MetadataNamespaces struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies a list of metadata namespaces whose values, if present,
	// will be passed to the ext_proc service as an opaque *protobuf::Struct*.
	Untyped []string `protobuf:"bytes,1,rep,name=untyped,proto3" json:"untyped,omitempty"`
	// Specifies a list of metadata namespaces whose values, if present,
	// will be passed to the ext_proc service as a *protobuf::Any*. This allows
	// envoy and the external processing server to share the protobuf message
	// definition for safe parsing.
	Typed []string `protobuf:"bytes,2,rep,name=typed,proto3" json:"typed,omitempty"`
}

func (x *MetadataOptions_MetadataNamespaces) Reset() {
	*x = MetadataOptions_MetadataNamespaces{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataOptions_MetadataNamespaces) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataOptions_MetadataNamespaces) ProtoMessage() {}

func (x *MetadataOptions_MetadataNamespaces) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataOptions_MetadataNamespaces.ProtoReflect.Descriptor instead.
func (*MetadataOptions_MetadataNamespaces) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP(), []int{2, 0}
}

func (x *MetadataOptions_MetadataNamespaces) GetUntyped() []string {
	if x != nil {
		return x.Untyped
	}
	return nil
}

func (x *MetadataOptions_MetadataNamespaces) GetTyped() []string {
	if x != nil {
		return x.Typed
	}
	return nil
}

var File_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto protoreflect.FileDescriptor

var file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDesc = []byte{
	0x0a, 0x38, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x29, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x33, 0x1a, 0x3a, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x27, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76,
	0x33, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68,
	0x74, 0x74, 0x70, 0x2f, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x78, 0x64, 0x73, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x75, 0x64, 0x70, 0x61, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64, 0x70, 0x61, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xb7, 0x0e, 0x0a, 0x11, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x63, 0x0a, 0x0c, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x33, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42,
	0x1d, 0xf2, 0x98, 0xfe, 0x8f, 0x05, 0x17, 0x12, 0x15, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x63, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x52, 0x0b,
	0x67, 0x72, 0x70, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x0c,
	0x68, 0x74, 0x74, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x2e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x45,
	0x78, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x48, 0x74, 0x74, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x42, 0x25, 0xf2, 0x98, 0xfe, 0x8f, 0x05, 0x17, 0x12, 0x15, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x63, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0xd2, 0xc6, 0xa4, 0xe1, 0x06, 0x02, 0x08, 0x01, 0x52, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x41, 0x6c,
	0x6c, 0x6f, 0x77, 0x12, 0x62, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0d, 0xfa, 0x42, 0x0a,
	0xaa, 0x01, 0x07, 0x22, 0x03, 0x08, 0x90, 0x1c, 0x32, 0x00, 0x52, 0x0e, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74,
	0x61, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x74, 0x61, 0x74, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x61, 0x0a, 0x0e, 0x6d,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x52,
	0x0d, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x58,
	0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0d, 0xfa, 0x42, 0x0a, 0xaa, 0x01, 0x07, 0x22, 0x03,
	0x08, 0x90, 0x1c, 0x32, 0x00, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x65, 0x0a, 0x0d, 0x66, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x52, 0x0c, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0x40, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x5f,
	0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x6f, 0x64, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x12, 0x3c, 0x0a, 0x1a, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6d,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x65, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x72,
	0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x11, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x59, 0x0a, 0x19, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x1e, 0xf2, 0x98, 0xfe, 0x8f, 0x05, 0x18,
	0x12, 0x16, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x52, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65,
	0x12, 0x9b, 0x01, 0x0a, 0x12, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x1e, 0xf2, 0x98,
	0xfe, 0x8f, 0x05, 0x18, 0x12, 0x16, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x52, 0x10, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f,
	0x0a, 0x16, 0x64, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x6f, 0x73, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x64, 0x65, 0x66, 0x65, 0x72,
	0x72, 0x65, 0x64, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12,
	0x5e, 0x0a, 0x2d, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x5f, 0x77, 0x69, 0x74,
	0x68, 0x6f, 0x75, 0x74, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x6f, 0x72,
	0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x52, 0x27, 0x73, 0x65, 0x6e, 0x64, 0x42, 0x6f, 0x64, 0x79,
	0x57, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x57, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x46, 0x6f,
	0x72, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x6f, 0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x73,
	0x22, 0x36, 0x0a, 0x10, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x4c, 0x45, 0x41, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x52, 0x45, 0x54, 0x41, 0x49, 0x4e, 0x10, 0x02, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x52, 0x0a,
	0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x5a, 0x0a, 0x12, 0x45, 0x78,
	0x74, 0x50, 0x72, 0x6f, 0x63, 0x48, 0x74, 0x74, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x44, 0x0a, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x74,
	0x74, 0x70, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0xdf, 0x02, 0x0a, 0x0f, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x82, 0x01, 0x0a, 0x15, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x14, 0x66, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12,
	0x80, 0x01, 0x0a, 0x14, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x13, 0x72,
	0x65, 0x63, 0x65, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x73, 0x1a, 0x44, 0x0a, 0x12, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x6e, 0x74, 0x79,
	0x70, 0x65, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x75, 0x6e, 0x74, 0x79, 0x70,
	0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65, 0x64, 0x22, 0xc3, 0x01, 0x0a, 0x15, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0x51, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x57, 0x0a, 0x12, 0x64, 0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x11, 0x64, 0x69, 0x73,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x22, 0xa6,
	0x01, 0x0a, 0x0f, 0x45, 0x78, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x50, 0x65, 0x72, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x12, 0x25, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x6a, 0x02, 0x08, 0x01, 0x48, 0x00, 0x52,
	0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x09, 0x6f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x48, 0x00, 0x52, 0x09, 0x6f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x42, 0x0f, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0xf9, 0x03, 0x0a, 0x10, 0x45, 0x78, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x62, 0x0a, 0x0f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65,
	0x52, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x2d, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x2f,
	0x0a, 0x13, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x44, 0x0a, 0x0c, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x72, 0x70,
	0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0b, 0x67, 0x72, 0x70, 0x63, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x65, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x15,
	0x67, 0x72, 0x70, 0x63, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x33, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13,
	0x67, 0x72, 0x70, 0x63, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0xae, 0x01, 0xba, 0x80, 0xc8, 0xd1, 0x06, 0x02, 0x10, 0x02, 0x0a, 0x37,
	0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x33, 0x42, 0x0c, 0x45, 0x78, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2f, 0x67,
	0x6f, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2d, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2f,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x33, 0x3b, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x72,
	0x6f, 0x63, 0x76, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescData = file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDesc
)

func file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescData)
	})
	return file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDescData
}

var file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_goTypes = []interface{}{
	(ExternalProcessor_RouteCacheAction)(0),    // 0: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.RouteCacheAction
	(*ExternalProcessor)(nil),                  // 1: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor
	(*ExtProcHttpService)(nil),                 // 2: envoy.extensions.filters.http.ext_proc.v3.ExtProcHttpService
	(*MetadataOptions)(nil),                    // 3: envoy.extensions.filters.http.ext_proc.v3.MetadataOptions
	(*HeaderForwardingRules)(nil),              // 4: envoy.extensions.filters.http.ext_proc.v3.HeaderForwardingRules
	(*ExtProcPerRoute)(nil),                    // 5: envoy.extensions.filters.http.ext_proc.v3.ExtProcPerRoute
	(*ExtProcOverrides)(nil),                   // 6: envoy.extensions.filters.http.ext_proc.v3.ExtProcOverrides
	(*MetadataOptions_MetadataNamespaces)(nil), // 7: envoy.extensions.filters.http.ext_proc.v3.MetadataOptions.MetadataNamespaces
	(*v3.GrpcService)(nil),                     // 8: envoy.config.core.v3.GrpcService
	(*ProcessingMode)(nil),                     // 9: envoy.extensions.filters.http.ext_proc.v3.ProcessingMode
	(*durationpb.Duration)(nil),                // 10: google.protobuf.Duration
	(*v31.HeaderMutationRules)(nil),            // 11: envoy.config.common.mutation_rules.v3.HeaderMutationRules
	(*structpb.Struct)(nil),                    // 12: google.protobuf.Struct
	(*v3.HttpService)(nil),                     // 13: envoy.config.core.v3.HttpService
	(*v32.ListStringMatcher)(nil),              // 14: envoy.type.matcher.v3.ListStringMatcher
	(*v3.HeaderValue)(nil),                     // 15: envoy.config.core.v3.HeaderValue
}
var file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_depIdxs = []int32{
	8,  // 0: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.grpc_service:type_name -> envoy.config.core.v3.GrpcService
	2,  // 1: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.http_service:type_name -> envoy.extensions.filters.http.ext_proc.v3.ExtProcHttpService
	9,  // 2: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.processing_mode:type_name -> envoy.extensions.filters.http.ext_proc.v3.ProcessingMode
	10, // 3: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.message_timeout:type_name -> google.protobuf.Duration
	11, // 4: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.mutation_rules:type_name -> envoy.config.common.mutation_rules.v3.HeaderMutationRules
	10, // 5: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.max_message_timeout:type_name -> google.protobuf.Duration
	4,  // 6: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.forward_rules:type_name -> envoy.extensions.filters.http.ext_proc.v3.HeaderForwardingRules
	12, // 7: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.filter_metadata:type_name -> google.protobuf.Struct
	3,  // 8: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.metadata_options:type_name -> envoy.extensions.filters.http.ext_proc.v3.MetadataOptions
	0,  // 9: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.route_cache_action:type_name -> envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.RouteCacheAction
	10, // 10: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.deferred_close_timeout:type_name -> google.protobuf.Duration
	9,  // 11: envoy.extensions.filters.http.ext_proc.v3.ExternalProcessor.allowed_override_modes:type_name -> envoy.extensions.filters.http.ext_proc.v3.ProcessingMode
	13, // 12: envoy.extensions.filters.http.ext_proc.v3.ExtProcHttpService.http_service:type_name -> envoy.config.core.v3.HttpService
	7,  // 13: envoy.extensions.filters.http.ext_proc.v3.MetadataOptions.forwarding_namespaces:type_name -> envoy.extensions.filters.http.ext_proc.v3.MetadataOptions.MetadataNamespaces
	7,  // 14: envoy.extensions.filters.http.ext_proc.v3.MetadataOptions.receiving_namespaces:type_name -> envoy.extensions.filters.http.ext_proc.v3.MetadataOptions.MetadataNamespaces
	14, // 15: envoy.extensions.filters.http.ext_proc.v3.HeaderForwardingRules.allowed_headers:type_name -> envoy.type.matcher.v3.ListStringMatcher
	14, // 16: envoy.extensions.filters.http.ext_proc.v3.HeaderForwardingRules.disallowed_headers:type_name -> envoy.type.matcher.v3.ListStringMatcher
	6,  // 17: envoy.extensions.filters.http.ext_proc.v3.ExtProcPerRoute.overrides:type_name -> envoy.extensions.filters.http.ext_proc.v3.ExtProcOverrides
	9,  // 18: envoy.extensions.filters.http.ext_proc.v3.ExtProcOverrides.processing_mode:type_name -> envoy.extensions.filters.http.ext_proc.v3.ProcessingMode
	8,  // 19: envoy.extensions.filters.http.ext_proc.v3.ExtProcOverrides.grpc_service:type_name -> envoy.config.core.v3.GrpcService
	3,  // 20: envoy.extensions.filters.http.ext_proc.v3.ExtProcOverrides.metadata_options:type_name -> envoy.extensions.filters.http.ext_proc.v3.MetadataOptions
	15, // 21: envoy.extensions.filters.http.ext_proc.v3.ExtProcOverrides.grpc_initial_metadata:type_name -> envoy.config.core.v3.HeaderValue
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_init() }
func file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_init() {
	if File_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto != nil {
		return
	}
	file_envoy_extensions_filters_http_ext_proc_v3_processing_mode_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternalProcessor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtProcHttpService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeaderForwardingRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtProcPerRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtProcOverrides); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetadataOptions_MetadataNamespaces); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ExtProcPerRoute_Disabled)(nil),
		(*ExtProcPerRoute_Overrides)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_depIdxs,
		EnumInfos:         file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_enumTypes,
		MessageInfos:      file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto = out.File
	file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_rawDesc = nil
	file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_goTypes = nil
	file_envoy_extensions_filters_http_ext_proc_v3_ext_proc_proto_depIdxs = nil
}
