/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flow;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet resultSet) {
        FlowJSServerService service;
        if (parameters2 == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((service = FlowJSCompletionContributor.checkAndGetService(parameters2.getOriginalFile())) == null) {
            return;
        }
        Document document = parameters2.getEditor().getDocument();
        Map<String, String> names = service.getCompletionOfElement(parameters2.getOriginalFile(), document, parameters2, parameters2.getPosition().getContainingFile().getText());
        HashSet entrySet = new HashSet();
        resultSet.runRemainingContributors(parameters2, result2 -> entrySet.add(result2.getLookupElement()));
        HashMap entryMap = new HashMap();
        entrySet.forEach(element -> entryMap.put(element.getLookupString(), element));
        HashSet<LookupElement> elementsToAdd = new HashSet<LookupElement>();
        for (Map.Entry<String, String> entry : names.entrySet()) {
            LookupElement element2 = (LookupElement)entryMap.get(entry.getKey());
            JSLookupPriority priority = JSLookupPriority.SMART_PRIORITY;
            if (element2 != null) {
                elementsToAdd.add(JSLookupUtilImpl.withPartial(JSCompletionUtil.withJSLookupPriority(element2, priority), false));
                entryMap.remove(entry.getKey());
                entrySet.remove(element2);
                continue;
            }
            LookupElementBuilder lookupElement = LookupElementBuilder.create((String)entry.getKey()).withTypeText(entry.getValue(), false).withIcon(PlatformIcons.PROPERTY_ICON);
            elementsToAdd.add(JSCompletionUtil.withJSLookupPriority((LookupElement)lookupElement, priority));
        }
        elementsToAdd.addAll(entrySet);
        FlowJSCompletionContributor.removeIncorrectCompletionElements(parameters2.getPosition(), elementsToAdd);
        resultSet.addAllElements(elementsToAdd);
        resultSet.stopHere();
    }

    @Nullable
    private static FlowJSServerService checkAndGetService(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(2);
        }
        if (!FlowJSSettingsManager.areOtherServicesEnabled(originalFile)) {
            return null;
        }
        return FlowJSServerManager.getService(originalFile);
    }

    private static void removeIncorrectCompletionElements(@NotNull PsiElement element, @NotNull Set<LookupElement> results) {
        PsiElement importKeyword;
        if (element == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(3);
        }
        if (results == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((importKeyword = FlowJSCompletionContributor.checkImport(element)) != null) {
            if (ES6ReferenceExpressionsInfo.isTypeImport(importKeyword)) {
                FlowJSCompletionContributor.removeImportSuggestions(results, true);
            } else {
                FlowJSCompletionContributor.removeImportSuggestions(results, false);
            }
        }
    }

    private static void removeImportSuggestions(@NotNull Set<LookupElement> results, boolean isType) {
        if (results == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(5);
        }
        HashSet<LookupElement> copyOfSet = new HashSet<LookupElement>(results);
        results.forEach(element -> {
            PsiElement psiElement = element.getPsiElement();
            if (psiElement != null) {
                if (isType) {
                    if (!(psiElement instanceof TypeScriptCompileTimeType) && !(psiElement instanceof ES6Class)) {
                        copyOfSet.remove(element);
                    }
                } else if (psiElement instanceof TypeScriptTypeAlias) {
                    copyOfSet.remove(element);
                }
            }
        });
        results.clear();
        results.addAll(copyOfSet);
    }

    @Nullable
    private static PsiElement checkImport(@NotNull PsiElement element) {
        PsiElement importKeyWord;
        PsiElement importElement;
        if (element == null) {
            FlowJSCompletionContributor.$$$reportNull$$$0(6);
        }
        if ((importElement = PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class)) != null && (importKeyWord = importElement.getFirstChild()).getNode().getElementType() == JSTokenTypes.IMPORT_KEYWORD) {
            return importKeyWord;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/flow/FlowJSCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAndGetService";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeIncorrectCompletionElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeImportSuggestions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

