/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.download;

import com.intellij.javascript.nodejs.interpreter.download.Metadata;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadVersionInfo;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadVersionList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.text.SemVer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@kotlin.Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"URL", "", "downloadAndParse", "Lcom/intellij/javascript/nodejs/interpreter/download/NodeDownloadVersionList;", "parseLines", "lines", "Lkotlin/sequences/Sequence;", "parseMetadata", "Lcom/intellij/javascript/nodejs/interpreter/download/Metadata;", "firstLine", "parseLine", "Lcom/intellij/javascript/nodejs/interpreter/download/NodeDownloadVersionInfo;", "line", "metadata", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeDownloadVersionList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeDownloadVersionList.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeDownloadVersionListKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n15#2:90\n15#2:91\n15#2:92\n*S KotlinDebug\n*F\n+ 1 NodeDownloadVersionList.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeDownloadVersionListKt\n*L\n35#1:90\n75#1:91\n55#1:92\n*E\n"})
public final class NodeDownloadVersionListKt {
    @NotNull
    private static final String URL = "https://nodejs.org/dist/index.tab";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final NodeDownloadVersionList downloadAndParse() throws IOException {
        Path tempFile = Files.createTempFile("nodejs-versions", ".dat", new FileAttribute[0]);
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        try {
            NodeDownloadVersionList nodeDownloadVersionList;
            DownloadUtil.downloadContentToFile((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (String)URL, (File)tempFile.toFile());
            Intrinsics.checkNotNull((Object)tempFile);
            Path path2 = tempFile;
            Closeable closeable = Files.newBufferedReader(path2, Charsets.UTF_8);
            Throwable throwable = null;
            try {
                BufferedReader bufferedReader = (BufferedReader)closeable;
                Intrinsics.checkNotNull((Object)bufferedReader);
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
                boolean bl = false;
                NodeDownloadVersionList versionList2 = NodeDownloadVersionListKt.parseLines((Sequence<String>)it);
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(NodeDownloadVersionList.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Downloaded " + versionList2.getSortedVersions().size() + " Node.js versions from https://nodejs.org/dist/index.tab in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime), (DurationUnit)DurationUnit.MILLISECONDS, (int)0));
                nodeDownloadVersionList = versionList2;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)closeable, throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            NodeDownloadVersionList nodeDownloadVersionList2 = nodeDownloadVersionList;
            return nodeDownloadVersionList2;
        }
        finally {
            Files.delete(tempFile);
        }
    }

    private static final NodeDownloadVersionList parseLines(Sequence<String> lines) {
        Ref.ObjectRef metadata = new Ref.ObjectRef();
        metadata.element = new Metadata(0, 0, 0, 0, 15, null);
        List versions = SequencesKt.toList((Sequence)SequencesKt.mapIndexedNotNull(lines, (arg_0, arg_1) -> NodeDownloadVersionListKt.parseLines$lambda$2(metadata, arg_0, arg_1)));
        return new NodeDownloadVersionList(versions);
    }

    private static final Metadata parseMetadata(String firstLine) {
        Metadata metadata;
        Metadata metadata2;
        String[] stringArray = new String[]{"\t"};
        List parts = StringsKt.split$default((CharSequence)firstLine, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Metadata it = metadata2 = new Metadata(parts.indexOf("version"), parts.indexOf("date"), parts.indexOf("npm"), parts.indexOf("lts"));
        boolean bl = false;
        Metadata metadata3 = metadata = it.getVersionIndex() != -1 && it.getDateIndex() != -1 && it.getNpmIndex() != -1 && it.getLtsIndex() != -1 ? metadata2 : null;
        if (metadata == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(NodeDownloadVersionList.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot parse metadata from " + firstLine);
        }
        return metadata;
    }

    private static final NodeDownloadVersionInfo parseLine(String line, Metadata metadata) {
        String[] stringArray = new String[]{"\t"};
        List parts = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string = (String)CollectionsKt.getOrNull((List)parts, (int)metadata.getVersionIndex());
        if (string == null) {
            return null;
        }
        String versionStr = string;
        String string2 = (String)CollectionsKt.getOrNull((List)parts, (int)metadata.getDateIndex());
        if (string2 == null) {
            return null;
        }
        String date = string2;
        String string3 = (String)CollectionsKt.getOrNull((List)parts, (int)metadata.getNpmIndex());
        if (string3 == null) {
            return null;
        }
        String npm = string3;
        String string4 = (String)CollectionsKt.getOrNull((List)parts, (int)metadata.getLtsIndex());
        if (string4 == null) {
            return null;
        }
        String lts = string4;
        SemVer semVer = SemVer.parseFromText((String)StringsKt.removePrefix((String)versionStr, (CharSequence)"v"));
        if (semVer == null) {
            return null;
        }
        SemVer version2 = semVer;
        return new NodeDownloadVersionInfo(version2, date, npm, Intrinsics.areEqual((Object)lts, (Object)"-") ? null : lts);
    }

    private static final NodeDownloadVersionInfo parseLines$lambda$2(Ref.ObjectRef $metadata, int index, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        NodeDownloadVersionInfo versionInfo = NodeDownloadVersionListKt.parseLine(line, (Metadata)$metadata.element);
        if (versionInfo == null && index == 0) {
            Metadata metadata = NodeDownloadVersionListKt.parseMetadata(line);
            if (metadata != null) {
                Metadata it = metadata;
                boolean bl = false;
                $metadata.element = it;
            }
        }
        if (index > 0 && versionInfo == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(NodeDownloadVersionList.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot parse Node.js version from line: " + line);
        }
        return versionInfo;
    }
}

