/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.interfaces.mochaTdd;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.AbstractMochaTddElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.CollectMochaTddStructureElementPathsKt;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddSuite;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddTest;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTddFileStructure
extends AbstractTestFileStructure {
    private final List<MochaTddSuite> myChildren;
    private final Map<PsiElement, AbstractMochaTddElement> myLeafElementToInfoMap;
    @Nullable
    Set<String> elementPathsCache;
    @Nullable
    String lastElementsPathsDelimiterCache;

    public MochaTddFileStructure(@NotNull JSFile jsFile, @NotNull List<AbstractMochaTddElement> children) {
        if (jsFile == null) {
            MochaTddFileStructure.$$$reportNull$$$0(0);
        }
        if (children == null) {
            MochaTddFileStructure.$$$reportNull$$$0(1);
        }
        super(jsFile);
        this.myLeafElementToInfoMap = new IdentityHashMap<PsiElement, AbstractMochaTddElement>();
        this.elementPathsCache = null;
        this.lastElementsPathsDelimiterCache = null;
        this.myChildren = MochaTddFileStructure.filterSuites(children);
        for (MochaTddSuite child : this.myChildren) {
            this.registerRecursively(child);
        }
    }

    public void forEachTest(@NotNull Consumer<MochaTddTest> testConsumer) {
        if (testConsumer == null) {
            MochaTddFileStructure.$$$reportNull$$$0(2);
        }
        for (MochaTddSuite child : this.myChildren) {
            child.forEachTest(testConsumer);
        }
    }

    @NotNull
    private static List<MochaTddSuite> filterSuites(@NotNull List<AbstractMochaTddElement> children) {
        if (children == null) {
            MochaTddFileStructure.$$$reportNull$$$0(3);
        }
        if (children.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                MochaTddFileStructure.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.filter(children, MochaTddSuite.class));
        if (immutableList == null) {
            MochaTddFileStructure.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @Override
    public boolean isEmpty() {
        if (!this.myChildren.isEmpty()) {
            for (MochaTddSuite child : this.myChildren) {
                if (child.getChildren().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public List<MochaTddSuite> getTopLevelSuites() {
        List<MochaTddSuite> list = this.myChildren;
        if (list == null) {
            MochaTddFileStructure.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean hasMochaTypeScriptDeclarations() {
        for (MochaTddSuite child : this.myChildren) {
            if (!(child.getEnclosingPsiElement() instanceof TypeScriptClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull List<String> suiteNames, @Nullable String testName) {
        if (suiteNames == null) {
            MochaTddFileStructure.$$$reportNull$$$0(7);
        }
        if (suiteNames.isEmpty()) {
            return null;
        }
        String firstSuiteName = suiteNames.get(0);
        MochaTddSuite currentSuite = null;
        for (MochaTddSuite suite : this.myChildren) {
            if (!suite.getName().equals(firstSuiteName)) continue;
            currentSuite = suite;
            break;
        }
        if (currentSuite == null) {
            return null;
        }
        for (int i = 1; i < suiteNames.size(); ++i) {
            if ((currentSuite = currentSuite.findSuiteByName(suiteNames.get(i))) != null) continue;
            return null;
        }
        if (testName != null) {
            MochaTddTest test = currentSuite.findTestByName(testName);
            return test == null ? null : test.getEnclosingPsiElement();
        }
        return currentSuite.getEnclosingPsiElement();
    }

    @Override
    @Nullable
    public PsiElement findPsiElement(@NotNull JsTestSelector testSelector) {
        if (testSelector == null) {
            MochaTddFileStructure.$$$reportNull$$$0(8);
        }
        return this.findPsiElement(testSelector.getSuitNames(), testSelector.getTestName());
    }

    @Nullable
    public AbstractMochaTddElement findDeepestElementContainingElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            MochaTddFileStructure.$$$reportNull$$$0(9);
        }
        for (MochaTddSuite suite : this.myChildren) {
            AbstractMochaTddElement result2 = suite.findDeepestElementContainingRange(textRange);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull TextRange range) {
        if (range == null) {
            MochaTddFileStructure.$$$reportNull$$$0(10);
        }
        return MochaTddFileStructure.toTestElementPath(this.findDeepestElementContainingElement(range));
    }

    @Override
    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull PsiElement testIdentifierLeafElement) {
        if (testIdentifierLeafElement == null) {
            MochaTddFileStructure.$$$reportNull$$$0(11);
        }
        return MochaTddFileStructure.toTestElementPath(this.myLeafElementToInfoMap.get(testIdentifierLeafElement));
    }

    public List<MochaTddSuite> getChildren() {
        return this.myChildren;
    }

    @Nullable
    private static JsTestElementPath toTestElementPath(@Nullable AbstractMochaTddElement element) {
        PsiElement psiElement;
        String testName;
        MochaTddSuite suite;
        if (element == null) {
            return null;
        }
        if (element instanceof MochaTddSuite) {
            suite = (MochaTddSuite)element;
            testName = null;
            psiElement = suite.getEnclosingPsiElement();
        } else {
            MochaTddTest test = (MochaTddTest)element;
            suite = (MochaTddSuite)element.getParent();
            testName = element.getName();
            psiElement = test.getEnclosingPsiElement();
        }
        SmartList suites = new SmartList();
        while (suite != null) {
            suites.add(suite.getName());
            suite = (MochaTddSuite)suite.getParent();
        }
        Collections.reverse(suites);
        return new JsTestElementPath((List<String>)suites, testName, psiElement);
    }

    private void registerRecursively(@NotNull MochaTddSuite suite) {
        if (suite == null) {
            MochaTddFileStructure.$$$reportNull$$$0(12);
        }
        this.register(suite.getEnclosingPsiElement(), suite);
        for (AbstractMochaTddElement element : suite.getChildren()) {
            if (element instanceof MochaTddSuite) {
                this.registerRecursively((MochaTddSuite)element);
                continue;
            }
            this.register(element.getEnclosingPsiElement(), element);
        }
    }

    private void register(@NotNull PsiElement psiElement, @NotNull AbstractMochaTddElement element) {
        PsiElement identifierElement;
        if (psiElement == null) {
            MochaTddFileStructure.$$$reportNull$$$0(13);
        }
        if (element == null) {
            MochaTddFileStructure.$$$reportNull$$$0(14);
        }
        if (psiElement instanceof JSCallExpression) {
            JSCallExpression callExpression = (JSCallExpression)psiElement;
            PsiElement identifierLeafElement = JsPsiUtils.getMethodNameLeafElement(callExpression);
            if (identifierLeafElement != null) {
                this.myLeafElementToInfoMap.put(identifierLeafElement, element);
            }
        } else if (psiElement instanceof TypeScriptClass) {
            PsiElement identifierElement2 = ((TypeScriptClass)psiElement).getNameIdentifier();
            if (identifierElement2 != null) {
                this.myLeafElementToInfoMap.put(MochaTddFileStructure.toLeafElement(identifierElement2), element);
            }
        } else if (psiElement instanceof TypeScriptFunction && (identifierElement = ((TypeScriptFunction)psiElement).getNameIdentifier()) != null) {
            this.myLeafElementToInfoMap.put(MochaTddFileStructure.toLeafElement(identifierElement), element);
        }
    }

    @NotNull
    private static PsiElement toLeafElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MochaTddFileStructure.$$$reportNull$$$0(15);
        }
        if (psiElement instanceof JSReferenceExpression) {
            for (PsiElement child : psiElement.getChildren()) {
                if (!child.getTextRange().equals((Object)psiElement.getTextRange())) continue;
                PsiElement psiElement2 = child;
                if (psiElement2 == null) {
                    MochaTddFileStructure.$$$reportNull$$$0(16);
                }
                return psiElement2;
            }
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement3 == null) {
            MochaTddFileStructure.$$$reportNull$$$0(17);
        }
        return psiElement3;
    }

    @NotNull
    public Set<String> collectElementPaths(@NotNull String elementsPathsDelimiter) {
        if (elementsPathsDelimiter == null) {
            MochaTddFileStructure.$$$reportNull$$$0(18);
        }
        if (this.elementPathsCache == null || this.lastElementsPathsDelimiterCache == null || !this.lastElementsPathsDelimiterCache.equals(elementsPathsDelimiter)) {
            this.lastElementsPathsDelimiterCache = elementsPathsDelimiter;
            this.elementPathsCache = CollectMochaTddStructureElementPathsKt.collectMochaTddStructureElementPaths(this, elementsPathsDelimiter);
        }
        Set<String> set = this.elementPathsCache;
        if (set == null) {
            MochaTddFileStructure.$$$reportNull$$$0(19);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 16, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConsumer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSelector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testIdentifierLeafElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsPathsDelimiter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSuites";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelSuites";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toLeafElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElementPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forEachTest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterSuites";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPsiElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestElementContainingElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTestElementPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerRecursively";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toLeafElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectElementPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 16, 17, 19 -> new IllegalStateException(string);
        };
    }
}

