/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.arrangement.ES6Rearranger;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSRearrangerBase;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptRearranger
extends ES6Rearranger {
    public TypeScriptRearranger() {
        super(JavaScriptSupportLoader.TYPESCRIPT, ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PRIVATE}), Arrays.asList(StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.ABSTRACT, StdArrangementTokens.Modifier.READONLY));
    }

    @Override
    protected boolean isAcceptableElement(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptRearranger.$$$reportNull$$$0(0);
        }
        return DialectDetector.isTypeScript(element);
    }

    @Override
    @NotNull
    protected JSRearrangerBase.Visitor createVisitor(@NotNull JSRearrangerBase.ArrangementInfo arrangementInfo) {
        if (arrangementInfo == null) {
            TypeScriptRearranger.$$$reportNull$$$0(1);
        }
        return new MyVisitor(arrangementInfo);
    }

    @Override
    protected boolean isModifierEnabled(@NotNull ArrangementSettingsToken modifier, @NotNull ArrangementSettingsToken entryType, @NotNull Set<ArrangementSettingsToken> existingModifiers) {
        if (modifier == null) {
            TypeScriptRearranger.$$$reportNull$$$0(2);
        }
        if (entryType == null) {
            TypeScriptRearranger.$$$reportNull$$$0(3);
        }
        if (existingModifiers == null) {
            TypeScriptRearranger.$$$reportNull$$$0(4);
        }
        if (entryType == StdArrangementTokens.EntryType.CONSTRUCTOR) {
            return false;
        }
        if (modifier == StdArrangementTokens.Modifier.READONLY) {
            return entryType == StdArrangementTokens.EntryType.FIELD;
        }
        if (entryType == StdArrangementTokens.EntryType.METHOD || entryType == StdArrangementTokens.EntryType.FIELD || entryType == StdArrangementTokens.EntryType.PROPERTY) {
            return !(existingModifiers.contains(StdArrangementTokens.Modifier.STATIC) && modifier == StdArrangementTokens.Modifier.ABSTRACT || existingModifiers.contains(StdArrangementTokens.Modifier.ABSTRACT) && modifier == StdArrangementTokens.Modifier.STATIC || existingModifiers.contains(StdArrangementTokens.Modifier.PRIVATE) && modifier == StdArrangementTokens.Modifier.ABSTRACT) && (!existingModifiers.contains(StdArrangementTokens.Modifier.ABSTRACT) || modifier != StdArrangementTokens.Modifier.PRIVATE);
        }
        return false;
    }

    @Override
    @NotNull
    protected Set<ArrangementSettingsToken> detectModifiers(@NotNull JSAttributeListOwner fieldOrMethod) {
        if (fieldOrMethod == null) {
            TypeScriptRearranger.$$$reportNull$$$0(5);
        }
        HashSet<ArrangementSettingsToken> modifiers = new HashSet<ArrangementSettingsToken>(super.detectModifiers(fieldOrMethod));
        if (fieldOrMethod.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
            modifiers.add(StdArrangementTokens.Modifier.ABSTRACT);
        }
        HashSet<ArrangementSettingsToken> hashSet = modifiers;
        if (hashSet == null) {
            TypeScriptRearranger.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    protected int getBlankLines(@NotNull CommonCodeStyleSettings commonSettings, @Nullable ArrangementSettingsToken type2, @Nullable JSElementArrangementEntry parent) {
        if (commonSettings == null) {
            TypeScriptRearranger.$$$reportNull$$$0(7);
        }
        if (parent != null && parent.getType() == StdArrangementTokens.EntryType.INTERFACE) {
            return type2 == StdArrangementTokens.EntryType.FIELD ? commonSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE : commonSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
        }
        return super.getBlankLines(commonSettings, type2, parent);
    }

    @NotNull
    private static PsiElement getEndElement(@NotNull JSElement element) {
        ASTNode sibling;
        if (element == null) {
            TypeScriptRearranger.$$$reportNull$$$0(8);
        }
        if ((sibling = element.getNode().getTreeNext()) != null && (sibling.getElementType() == JSTokenTypes.COMMA || sibling.getElementType() == JSTokenTypes.SEMICOLON)) {
            PsiElement psiElement = sibling.getPsi();
            if (psiElement == null) {
                TypeScriptRearranger.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        JSElement jSElement = element;
        if (jSElement == null) {
            TypeScriptRearranger.$$$reportNull$$$0(10);
        }
        return jSElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrangementInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingModifiers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOrMethod";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/arrangement/TypeScriptRearranger";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/arrangement/TypeScriptRearranger";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectModifiers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModifierEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectModifiers";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBlankLines";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEndElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 10 -> new IllegalStateException(string);
        };
    }

    private class MyVisitor
    extends JSRearrangerBase.Visitor {
        MyVisitor(JSRearrangerBase.ArrangementInfo arrangementInfo) {
            super(arrangementInfo);
        }

        @Override
        public void visitTypeScriptInterface(@NotNull TypeScriptInterface typeScriptInterface) {
            JSElementArrangementEntry interfaceEntry;
            if (typeScriptInterface == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if ((interfaceEntry = this.myArrangementInfo.addContainerEntry(typeScriptInterface, StdArrangementTokens.EntryType.INTERFACE)) == null) {
                return;
            }
            this.myArrangementInfo.processWithCurrentEntry(interfaceEntry, typeScriptInterface, anInterface -> {
                for (JSElement jSElement : anInterface.getMembers()) {
                    ArrangementSettingsToken type2;
                    PsiElement endElement = TypeScriptRearranger.getEndElement(jSElement);
                    ArrangementSettingsToken arrangementSettingsToken = type2 = jSElement instanceof TypeScriptPropertySignature ? StdArrangementTokens.EntryType.FIELD : StdArrangementTokens.EntryType.METHOD;
                    JSElementArrangementEntry entry = this.myArrangementInfo.addEntryFromRange((PsiElement)jSElement, endElement, type2, ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC}), jSElement.getName());
                    if (entry == null) continue;
                    this.visitWithCurrentEntry(jSElement, entry);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeScriptInterface", "com/intellij/lang/javascript/arrangement/TypeScriptRearranger$MyVisitor", "visitTypeScriptInterface"));
        }
    }
}

