/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.completion.ml.MLWeigherUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSTextReferenceCompletionProvider;
import com.intellij.lang.javascript.completion.ml.JSMLTrackingCompletionProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.impl.FlexPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompletionContributor
extends CompletionContributor {
    private boolean myDoingSmartCodeCompleteAction;
    private Set<String> myAlreadyUsedClassesSet;

    public boolean isDoingSmartCodeCompleteAction() {
        return this.myDoingSmartCodeCompleteAction;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        String text;
        PsiReference[] references;
        int i;
        boolean insideJs;
        if (parameters2 == null) {
            JSCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!(insideJs = JSCompletionContributor.getElementLanguage(parameters2).isKindOf((Language)JavascriptLanguage.INSTANCE))) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        PsiReference ref2 = position.getContainingFile().findReferenceAt(parameters2.getOffset());
        if (ref2 instanceof FlexPropertyReference || ref2 instanceof FileReference) {
            return;
        }
        this.myDoingSmartCodeCompleteAction = parameters2.getCompletionType() == CompletionType.SMART;
        this.myAlreadyUsedClassesSet = null;
        PrefixMatcher prefixMatcher = result2.getPrefixMatcher();
        String prefix = prefixMatcher.getPrefix();
        if (ref2 == null) {
            for (i = prefix.length() - 1; i >= 0 && Character.isJavaIdentifierPart(prefix.charAt(i)); --i) {
            }
            if (i != -1) {
                prefixMatcher = prefixMatcher.cloneWithPrefix(prefix.substring(i + 1));
            }
        }
        CompletionSorter sorter = JSCompletionContributor.createOwnSorter(parameters2);
        CompletionResultSet completionResultSet = result2.withRelevanceSorter(sorter).withPrefixMatcher(prefixMatcher);
        completionResultSet.runRemainingContributors(parameters2, completionResult -> {
            LookupElement item = completionResult.getLookupElement();
            JSMLTrackingCompletionProvider.Kind kind = JSMLTrackingCompletionProvider.JS_PROVIDER.get();
            if (kind != null) {
                item.putUserData(JSMLTrackingCompletionProvider.JS_PROVIDER_KEY, (Object)kind);
            }
            completionResultSet.withPrefixMatcher(completionResult.getPrefixMatcher()).addElement(item);
        });
        if (position.getNode().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA && !(ref2 instanceof JSDocReference) && !(ref2 instanceof JSDocParamReference) && (references = new JSDocReferenceSet(position, (text = position.getText()).substring(0, i + 2), 0, true).getReferences()).length > 0) {
            JSTextReferenceCompletionProvider.addVariants((JSTextReference)references[references.length - 1], parameters2, completionResultSet);
        }
        this.myAlreadyUsedClassesSet = null;
        this.myDoingSmartCodeCompleteAction = false;
        result2.stopHere();
    }

    public static CompletionSorter createOwnSorter(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            JSCompletionContributor.$$$reportNull$$$0(2);
        }
        final CompletionLocation location = new CompletionLocation(parameters2);
        CompletionSorterImpl sorter = ((CompletionSorterImpl)CompletionService.getCompletionService().emptySorter()).weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh((LookupElementWeigher)new PreferStartMatching()).weigh(new LookupElementWeigher("priority", true, false){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                Double d = JSCompletionUtil.getLookupElementPriority(element);
                if (d == null) {
                    4.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionContributor$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionContributor$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }).weigh(new LookupElementWeigher("js_priority", true, false){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                Double d = JSCompletionUtil.getLookupElementPriority(element);
                if (d == null) {
                    3.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionContributor$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }).weigh(new LookupElementWeigher("js_deprecated", true, false){

            @Nullable
            public Integer weigh(@NotNull LookupElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                return JSDocumentationUtils.isDeprecated(JSLookupElementRenderer.getValidElement(element)) ? -1 : 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSCompletionContributor$2", "weigh"));
            }
        }).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher()).withClassifier((ClassifierFactory)new ClassifierFactory<LookupElement>("stat"){

            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
            }
        }).weigh(new LookupElementWeigher("js_minor_priority", true, false){

            @NotNull
            public Integer weigh(@NotNull LookupElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                Integer n = JSCompletionUtil.getLookupElementProximity(element);
                if (n == null) {
                    1.$$$reportNull$$$0(1);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionContributor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        LookupElementWeigher mlWeigher = MLWeigherUtil.findMLWeigher((CompletionLocation)location);
        if (mlWeigher != null) {
            sorter = MLWeigherUtil.addWeighersToNonDefaultSorter((CompletionSorter)sorter, (CompletionLocation)location, (String[])new String[]{"proximity"});
            sorter = sorter.weigh(mlWeigher);
        }
        return sorter;
    }

    public void setAlreadyUsedClassesSet(Set<String> alreadyUsedClassesSet) {
        this.myAlreadyUsedClassesSet = alreadyUsedClassesSet;
    }

    public Set<String> getAlreadyUsedClassesSet() {
        return this.myAlreadyUsedClassesSet;
    }

    private static Language getElementLanguage(CompletionParameters parameters2) {
        return (Language)ReadAction.compute(() -> PsiUtilCore.getLanguageAtOffset((PsiFile)parameters2.getPosition().getContainingFile(), (int)parameters2.getOffset()));
    }

    public static JSCompletionContributor getInstance() {
        return JSCompletionContributorHolder.ourInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createOwnSorter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSCompletionContributorHolder {
        private static final JSCompletionContributor ourInstance;

        private JSCompletionContributorHolder() {
        }

        static {
            JSCompletionContributor instance = null;
            for (CompletionContributor c : CompletionContributor.forLanguage((Language)JavascriptLanguage.INSTANCE)) {
                if (!(c instanceof JSCompletionContributor)) continue;
                instance = (JSCompletionContributor)c;
                break;
            }
            assert (instance != null);
            ourInstance = instance;
        }
    }
}

