/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSParameterInfoHandlerKt;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupContext;
import com.intellij.lang.javascript.completion.JSLookupElementInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.generation.TypeScriptImplementMembersHandler;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6DecoratorDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTemplateLiteralJSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import icons.JavaScriptPsiIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLookupUtilImpl {
    static final Key<JSLookupElementFunctionData> POSSIBLE_FUNCTION_DATA_KEY = Key.create((String)"js.completion.possible.function.and.has.signature");
    private static final JSLookupPriority MY_LAST_VALUE_WITHOUT_PRIORITY = JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY;
    @NotNull
    private static final InsertHandler<LookupElement> PARAM_LIST_INSERT_HANDLER = (context2, item) -> {
        int startOffset = context2.getTailOffset();
        int endOffset = CharArrayUtil.shiftForwardUntil((CharSequence)context2.getDocument().getImmutableCharSequence(), (int)startOffset, (String)")");
        context2.getDocument().deleteString(startOffset, endOffset);
    };
    public static final Icon SEVERAL_DEFINITIONS_ICON = AllIcons.Nodes.MultipleTypeDefinitions;

    @NotNull
    public static LookupElement createMultiparamCompletionItem(PsiElement element, String lookupString) {
        LookupElementBuilder lookupElementBuilder = (element == null ? LookupElementBuilder.create((String)lookupString) : LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)element)).withIcon(IconHolder.ourParamParamIcon).withInsertHandler(PARAM_LIST_INSERT_HANDLER);
        if (lookupElementBuilder == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(0);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static TypeAndTail getTypeAndTailTexts(@NotNull PsiElement element, @NotNull JSLookupContext lookupContext) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(1);
        }
        if (lookupContext == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(2);
        }
        return JSLookupUtilImpl.getTypeAndTailTexts(null, element, lookupContext);
    }

    @NotNull
    public static TypeAndTail getTypeAndTailTexts(@Nullable LookupElement lookupElement, @NotNull PsiElement element, @NotNull JSLookupContext lookupContext) {
        PsiElement psiLocation;
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(3);
        }
        if (lookupContext == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(4);
        }
        TypeAndTail typeAndTail = (TypeAndTail)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((psiLocation = lookupContext.getLocation()) != null ? psiLocation : element, () -> JSLookupUtilImpl.getTypeAndTailTextsWithLocation(lookupElement, element, lookupContext));
        if (typeAndTail == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(5);
        }
        return typeAndTail;
    }

    @NotNull
    private static TypeAndTail getTypeAndTailTextsWithLocation(@Nullable LookupElement lookupElement, @NotNull PsiElement element, @NotNull JSLookupContext lookupContext) {
        String s;
        JSImplicitElement implicitElement;
        JSFunctionItem original;
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(6);
        }
        if (lookupContext == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(7);
        }
        PsiElement psiLocation = lookupContext.getLocation();
        JSTypeSubstitutor typeSubstitutor = lookupContext.getTypeSubstitutor();
        String typeText = null;
        String tailText = null;
        JSFunctionItem possibleFunction = JSPsiImplUtils.calculatePossibleFunction(element, null, false);
        JSType type2 = null;
        if (possibleFunction != null && possibleFunction.isValid() && (original = (JSFunctionItem)CompletionUtil.getOriginalElement((PsiElement)possibleFunction)) != null) {
            possibleFunction = original;
        }
        boolean fallbackToDefault = false;
        if (possibleFunction != null && possibleFunction.isValid()) {
            JSType typeFromSetAccessor;
            JSType returnType2 = JSLookupUtilImpl.expandAndOptimizeTypeRecursive(possibleFunction.getReturnType(), DialectDetector.isTypeScript(element), psiLocation);
            if ((returnType2 instanceof JSVoidType || returnType2 == null) && possibleFunction.isSetProperty() && (typeFromSetAccessor = JSResolveUtil.getTypeFromSetAccessor(possibleFunction)) != null) {
                returnType2 = typeFromSetAccessor;
            }
            if (JSLookupUtilImpl.isTypeAcceptableForLookupElement(returnType2)) {
                returnType2 = JSTypeUtils.applyGenericArguments(returnType2, typeSubstitutor);
                typeText = returnType2.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
        } else if (element instanceof JSClass || element instanceof JSNamespaceDeclaration) {
            if (DialectDetector.isActionScript(element)) {
                typeText = JSItemPresentation.getFileName(element.getContainingFile());
            }
        } else if (element instanceof JSImplicitElement && (implicitElement = (JSImplicitElement)element).getType() == JSImplicitElement.Type.Function) {
            JSType jSType;
            List<JSType> funcTypes;
            type2 = implicitElement.getJSType();
            List<JSType> list = funcTypes = type2 == null ? ContainerUtil.emptyList() : type2.getFunctionTypes(new ProcessingContext(), false).toList();
            if (funcTypes.size() == 1 && (jSType = funcTypes.get(0)) instanceof JSFunctionType) {
                JSFunctionType functionType = (JSFunctionType)jSType;
                StringBuilder result2 = new StringBuilder();
                result2.append("(");
                List<JSParameterTypeDecorator> parameters2 = functionType.getParameters();
                for (int i = 0; i < parameters2.size(); ++i) {
                    JSParameterItem parameter = parameters2.get(i);
                    if (i != 0) {
                        result2.append(", ");
                    }
                    result2.append(JSParameterInfoHandlerKt.getSignatureForParameter(parameter, typeSubstitutor, (Function1<? super JSType, String>)((Function1)JSParameterInfoHandlerKt::describeType)));
                }
                result2.append(")");
                tailText = result2.toString();
                JSType returnType3 = functionType.getReturnType();
                typeText = returnType3 == null ? "any" : returnType3.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            } else {
                fallbackToDefault = true;
            }
        } else {
            fallbackToDefault = true;
        }
        if (fallbackToDefault && JSLookupUtilImpl.isTypeAcceptableForLookupElement(type2 = JSLookupUtilImpl.expandAndOptimizeTypeRecursive(JSLookupUtilImpl.getElementType(element), DialectDetector.isTypeScript(element), psiLocation))) {
            type2 = JSTypeUtils.applyGenericArguments(type2, typeSubstitutor);
            if (element instanceof JSOptionalOwner && ((JSOptionalOwner)element).isOptional()) {
                type2 = JSTypeGuardUtil.wrapWithUndefined(type2, type2.getSource());
            }
            typeText = type2.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }
        if (possibleFunction != null && possibleFunction.isValid() && (s = JSLookupUtilImpl.getFunctionTailText(possibleFunction, typeSubstitutor)) != null) {
            tailText = s;
        }
        String location = JSLookupUtilImpl.getPackageLocationString(element);
        if (lookupElement != null) {
            JSLookupElementFunctionData data = JSLookupUtilImpl.getPossibleFunctionData(element, possibleFunction, type2);
            lookupElement.putUserData(POSSIBLE_FUNCTION_DATA_KEY, (Object)data);
        }
        return new TypeAndTail(typeText, tailText, location);
    }

    @Nullable
    private static JSType getElementType(@NotNull PsiElement element) {
        JSType type2;
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(8);
        }
        if ((type2 = JSTypeUtils.getTypeOfElement(element)) == null && DialectDetector.isTypeScript(element) && JSTypeGuardUtil.isAcceptableForTypeGuard(element)) {
            type2 = JSResolveUtil.getElementJSType(element);
        }
        return type2;
    }

    @NotNull
    private static JSLookupElementFunctionData getPossibleFunctionData(@NotNull PsiElement element, @Nullable JSFunctionItem possibleFunction, @Nullable JSType type2) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(9);
        }
        if (element instanceof TypeScriptPropertySignature) {
            JSLookupElementFunctionData jSLookupElementFunctionData = JSLookupElementFunctionData.EMPTY;
            if (jSLookupElementFunctionData == null) {
                JSLookupUtilImpl.$$$reportNull$$$0(10);
            }
            return jSLookupElementFunctionData;
        }
        boolean hasOtherNonEmptySignature = false;
        if (possibleFunction == null && type2 != null) {
            List<JSFunctionItem> candidates = JSTypeUtils.removeNullableComponents(type2).getFunctionTypes(new ProcessingContext(), false).filter(t -> t instanceof JSFunctionType).map(t -> ((JSFunctionType)t).getSourceFunctionItem()).filter(t -> t != null).limit(2L).toList();
            if (!candidates.isEmpty()) {
                possibleFunction = candidates.get(0);
            }
            if (candidates.size() > 1) {
                hasOtherNonEmptySignature = true;
            }
        }
        if (possibleFunction == null || !possibleFunction.isValid()) {
            JSLookupElementFunctionData jSLookupElementFunctionData = JSLookupElementFunctionData.EMPTY;
            if (jSLookupElementFunctionData == null) {
                JSLookupUtilImpl.$$$reportNull$$$0(11);
            }
            return jSLookupElementFunctionData;
        }
        boolean hasPropertySignature = false;
        if (type2 != null) {
            JSRecordType record = type2.asRecordType();
            for (JSRecordType.TypeMember member : record.getTypeMembers()) {
                if (TypeScriptPsiUtil.isObjectBuiltInTypeProperty(member) || member instanceof JSRecordType.CallSignature) continue;
                hasPropertySignature = true;
                break;
            }
        }
        return new JSLookupElementFunctionData(possibleFunction, hasPropertySignature, hasOtherNonEmptySignature);
    }

    @Nullable
    private static JSType expandAndOptimizeTypeRecursive(@Nullable JSType sourceType, boolean typeScript, @Nullable PsiElement location) {
        return typeScript ? TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(sourceType, location) : sourceType;
    }

    @Contract(value="null -> false")
    private static boolean isTypeAcceptableForLookupElement(@Nullable JSType type2) {
        if (type2 instanceof TypeScriptTemplateLiteralJSTypeImpl) {
            return true;
        }
        if (type2 instanceof JSNamedType) {
            String text = type2.getTypeText();
            return !text.endsWith("Constructor") || !JSCorePredefinedLibrariesProvider.isLibraryElement(type2.getSourceElement());
        }
        return type2 != null && !JSTypeUtils.hasTypes(type2, JSEvaluableType.class, JSRecordType.class);
    }

    @Nullable
    public static String getPackageLocationString(@NotNull PsiElement original) {
        JSQualifiedName namespace;
        if (original == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(12);
        }
        if (!(original instanceof JSQualifiedNamedElement)) {
            return JSLookupUtilImpl.getLocationStringFromPresentation(original);
        }
        JSQualifiedNamedElement elt = (JSQualifiedNamedElement)original;
        PsiElement parent = JSResolveUtil.findParent(original);
        if ((parent instanceof JSPackageStatement || parent instanceof JSFile || elt instanceof XmlBackedJSClass) && (namespace = elt.getNamespace()) != null) {
            String namespaceName = namespace.getQualifiedName();
            return "(" + namespaceName + ")";
        }
        return JSLookupUtilImpl.getLocationStringFromPresentation(original);
    }

    @Nullable
    public static Icon getLookupElementIcon(@Nullable PsiElement element) {
        if (element instanceof JSClass) {
            if (element instanceof TypeScriptInterface) {
                return com.intellij.util.PlatformIcons.INTERFACE_ICON;
            }
            if (element instanceof TypeScriptTypeAlias) {
                return JavaScriptPsiIcons.Classes.Alias;
            }
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Class);
        }
        return element instanceof JSElement || element instanceof CssClass || element instanceof PsiFile ? element.getIcon(0) : (element instanceof XmlElement ? IconManager.getInstance().getPlatformIcon(PlatformIcons.Tag) : JSLookupUtilImpl.getEmptyIcon());
    }

    @Nullable
    public static String getFunctionTailText(JSFunctionItem function, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (!function.isGetProperty() && !function.isSetProperty()) {
            Object[] typeParameters2;
            StringBuilder result2 = new StringBuilder();
            if (function instanceof TypeScriptTypeParameterListOwner && (typeParameters2 = ((TypeScriptTypeParameterListOwner)((Object)function)).getTypeParameters()).length > 0 && !JSLookupUtilImpl.hasAllSubstitutions(typeSubstitutor, (TypeScriptTypeParameter[])typeParameters2)) {
                result2.append('<').append(StringUtil.join((Object[])typeParameters2, PsiNamedElement::getName, (String)", ")).append('>');
            }
            result2.append("(");
            JSParameterItem[] parameters2 = function.getParameters();
            for (int i = 0; i < parameters2.length; ++i) {
                JSParameterItem parameter = parameters2[i];
                if (i != 0) {
                    result2.append(", ");
                }
                result2.append(JSParameterInfoHandlerKt.getSignatureForParameter(parameter, typeSubstitutor, (Function1<? super JSType, String>)((Function1)JSParameterInfoHandlerKt::describeType)));
            }
            result2.append(")");
            return result2.toString();
        }
        return null;
    }

    private static boolean hasAllSubstitutions(@Nullable JSTypeSubstitutor typeSubstitutor, TypeScriptTypeParameter[] typeParameters2) {
        if (typeSubstitutor == null) {
            return false;
        }
        for (TypeScriptTypeParameter p : typeParameters2) {
            if (typeSubstitutor.containsId(p.getGenericId())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getLocationStringFromPresentation(@Nullable PsiElement element) {
        if (!(element instanceof NavigationItem)) {
            return null;
        }
        ItemPresentation presentation = ((NavigationItem)element).getPresentation();
        if (presentation != null) {
            Object locationString;
            Object object = locationString = presentation instanceof JSItemPresentation ? ((JSItemPresentation)presentation).getLocationString(true) : presentation.getLocationString();
            if (locationString != null) {
                boolean needBraces;
                boolean bl = needBraces = !((String)locationString).startsWith("(");
                if (needBraces) {
                    locationString = "(" + (String)locationString + ")";
                }
                return locationString;
            }
        }
        return "";
    }

    public static boolean willCreateLookupElement(@NotNull JSLookupPriority priority) {
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(13);
        }
        return priority.compareTo(MY_LAST_VALUE_WITHOUT_PRIORITY) > 0 || !JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction();
    }

    public static String getShortName(String qName) {
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(qName);
        Object textToRender = signature != null ? signature.elementType + ".<" + JSLookupUtilImpl.getShortName(signature.genericType) + ">" : (!StringUtil.containsAnyChar((String)qName, (String)"<[(={") ? qName.substring(qName.lastIndexOf(46) + 1) : qName);
        return textToRender;
    }

    @NotNull
    public static LookupElementBuilder createLookupElement(@NotNull PsiNamedElement element) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(14);
        }
        return JSLookupUtilImpl.createLookupElement((PsiElement)element, StringUtil.notNullize((String)element.getName()));
    }

    @NotNull
    public static LookupElementBuilder createLookupElement(@NotNull PsiElement element, String name) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(15);
        }
        LookupElementBuilder builder2 = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element);
        LookupElementBuilder lookupElementBuilder = new JSLookupElementRenderer(name, JSLookupPriority.MAX_PRIORITY, false, new JSLookupContext(null, null)).applyToBuilder(builder2);
        if (lookupElementBuilder == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(16);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElement createPrioritizedLookupElement(@NotNull PsiNamedElement element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(17);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(18);
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)JSLookupUtilImpl.createLookupElement(element), (double)priority.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(19);
        }
        return lookupElement;
    }

    public static LookupElement toBoldLookupElement(@NotNull Object lookupElement) {
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(20);
        }
        if (lookupElement instanceof LookupElement) {
            return JSLookupUtilImpl.setBold((LookupElement)lookupElement, true);
        }
        return LookupElementBuilder.create((String)lookupElement.toString()).bold();
    }

    @Contract(value="null, _ -> true; _, null -> true")
    public static boolean matchElementWithContext(@Nullable PsiElement element, @Nullable PsiElement place) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(place);
        if (holder == null) {
            return true;
        }
        return !(element instanceof ES6DecoratorDeclaration) || holder.hasFeature(JSLanguageFeature.DECORATOR_DECLARATIONS) && JSUtils.isDecoratorAccessContext(place);
    }

    @NotNull
    public static LookupElement createLookupItemForStaticCall(@NotNull JSElement methodElement, @NotNull JSElement ownerElement) {
        if (methodElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(21);
        }
        if (ownerElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(22);
        }
        LookupElementBuilder builder2 = JSLookupUtilImpl.createLookupElement((PsiElement)methodElement, ownerElement.getName() + "." + methodElement.getName());
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder2.withInsertHandler((c, i) -> {
            JSInsertHandler.insertBracesIfNeeded(c, 1);
            new ShowParameterInfoHandler().invoke(c.getProject(), c.getEditor(), c.getFile());
        }), (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(23);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createImplementAbstractOrInterfaceLookupItem(@NotNull PsiElement namedElement, @NotNull String className) {
        if (namedElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(24);
        }
        if (className == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(25);
        }
        String extendsWord = namedElement instanceof JSClass && ((JSClass)namedElement).isInterface() ? "implements" : "extends";
        LookupElementBuilder builder2 = JSLookupUtilImpl.createLookupElement(namedElement, "class " + extendsWord + " " + className + " {}");
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder2.withLookupString(className).withPresentableText(className + "{...}").withInsertHandler((c, i) -> JSLookupUtilImpl.generateMissingMembersForItem(c)), (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(26);
        }
        return lookupElement;
    }

    private static String elementOrNullDesc(Object element) {
        return element == null ? "(null)" : element.getClass().getName();
    }

    private static void generateMissingMembersForItem(@NotNull InsertionContext c) {
        if (c == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(27);
        }
        Editor editor = c.getEditor();
        int startOffset = c.getStartOffset();
        editor.getCaretModel().moveToOffset(startOffset);
        PsiElement element = c.getFile().findElementAt(startOffset);
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
        if (jsClass == null) {
            Logger.getInstance(JSLookupUtilImpl.class).error("Class not found, element: " + JSLookupUtilImpl.elementOrNullDesc(element) + "context: " + JSLookupUtilImpl.elementOrNullDesc(PsiTreeUtil.getParentOfType((PsiElement)element, JSExecutionScope.class)));
            return;
        }
        TypeScriptImplementMembersHandler handler = new TypeScriptImplementMembersHandler();
        handler.setSkipMemberChooserDialog(true);
        handler.invoke(c.getProject(), editor, c.getFile());
        editor.getCaretModel().moveToOffset(jsClass.getTextRange().getEndOffset());
    }

    public static boolean isBold(@Nullable LookupElement element) {
        if (element instanceof PrioritizedLookupElement) {
            element = ((PrioritizedLookupElement)element).getDelegate();
        }
        if (element instanceof LookupElementBuilder) {
            BoldCheckingLookupElementPresentation presentation = new BoldCheckingLookupElementPresentation();
            element.renderElement((LookupElementPresentation)presentation);
            return presentation.isItemTextBold();
        }
        return false;
    }

    @NotNull
    public static LookupElement withPartial(@NotNull LookupElement element, boolean partial) {
        LookupElementRenderer renderer;
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(28);
        }
        LookupElement delegate = element;
        if (element instanceof PrioritizedLookupElement) {
            delegate = ((PrioritizedLookupElement)element).getDelegate();
        }
        if (delegate instanceof LookupElementBuilder && (renderer = ((LookupElementBuilder)delegate).getRenderer()) instanceof JSLookupElementRenderer) {
            LookupElementBuilder newElement = ((JSLookupElementRenderer)renderer).applyToBuilderWithPartial((LookupElementBuilder)delegate, partial);
            if (newElement == delegate) {
                LookupElement lookupElement = element;
                if (lookupElement == null) {
                    JSLookupUtilImpl.$$$reportNull$$$0(29);
                }
                return lookupElement;
            }
            LookupElement lookupElement = JSLookupUtilImpl.wrapWithPriority(element, newElement);
            if (lookupElement == null) {
                JSLookupUtilImpl.$$$reportNull$$$0(30);
            }
            return lookupElement;
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(31);
        }
        return lookupElement;
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    @Nullable
    public static LookupElement setBold(@Nullable LookupElement lookupElement, boolean boldness) {
        if (JSLookupUtilImpl.isBold(lookupElement) == boldness) {
            return lookupElement;
        }
        LookupElement actualElement = lookupElement;
        if (lookupElement instanceof PrioritizedLookupElement) {
            lookupElement = ((PrioritizedLookupElement)lookupElement).getDelegate();
        }
        if (lookupElement instanceof LookupElementBuilder) {
            LookupElementBuilder newElement = ((LookupElementBuilder)lookupElement).withBoldness(boldness);
            return JSLookupUtilImpl.wrapWithPriority(actualElement, newElement);
        }
        return actualElement;
    }

    public static LookupElement wrapWithPriority(@NotNull LookupElement oldActualElement, @NotNull LookupElementBuilder newElement) {
        if (oldActualElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(32);
        }
        if (newElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(33);
        }
        if (!(oldActualElement instanceof PrioritizedLookupElement)) {
            return newElement;
        }
        return PrioritizedLookupElement.withExplicitProximity((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)PrioritizedLookupElement.withPriority((LookupElement)newElement, (double)((PrioritizedLookupElement)oldActualElement).getPriority()), (int)((PrioritizedLookupElement)oldActualElement).getGrouping()), (int)((PrioritizedLookupElement)oldActualElement).getExplicitProximity());
    }

    public static void setForceQualify(@Nullable LookupElement lookupElement) {
        InsertHandler handler;
        if (lookupElement instanceof PrioritizedLookupElement) {
            lookupElement = ((PrioritizedLookupElement)lookupElement).getDelegate();
        }
        if (lookupElement instanceof LookupElementBuilder && (handler = ((LookupElementBuilder)lookupElement).getInsertHandler()) instanceof JSLookupElementInsertHandler) {
            ((JSLookupElementInsertHandler)handler).setForceQualify(true);
        }
    }

    public static Icon getEmptyIcon() {
        return IconHolder.ourEmptyIcon;
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, JSLookupPriority priority) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(34);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, false, JSLookupContext.EMPTY);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean partial, @NotNull JSLookupContext lookupContext) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(35);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(36);
        }
        if (lookupContext == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(37);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, partial, lookupContext, false);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean partial, @NotNull JSLookupContext lookupContext, boolean insertAsIndexer) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(38);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(39);
        }
        if (lookupContext == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(40);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, partial, lookupContext, insertAsIndexer, null);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean partial, @NotNull JSLookupContext lookupContext, boolean insertAsIndexer, @Nullable String lookupString) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(41);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(42);
        }
        if (lookupContext == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(43);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, partial, lookupContext, insertAsIndexer, lookupString, null);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean partial, @NotNull JSLookupContext lookupContext, boolean insertAsIndexer, @Nullable String lookupString, @Nullable Runnable insertHandlerAction) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(44);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(45);
        }
        if (lookupContext == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(46);
        }
        if (!JSLookupUtilImpl.willCreateLookupElement(priority)) {
            return null;
        }
        ProgressManager.checkCanceled();
        if (insertAsIndexer) {
            priority = JSLookupUtilImpl.getIndexerPriority(priority);
        }
        if (value instanceof JSImplicitPrototypeElement && priority.getPriorityValue() > JSLookupPriority.NESTING_LEVEL_REST.getPriorityValue()) {
            priority = JSLookupPriority.NESTING_LEVEL_REST;
        }
        LookupElementBuilder builder2 = value == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)value);
        builder2 = new JSLookupElementRenderer(name, priority, partial, lookupContext).applyToBuilder(builder2).withInsertHandler((InsertHandler)new JSLookupElementInsertHandler(insertAsIndexer, insertHandlerAction));
        if (lookupString == null && StringUtil.isQuotedString((String)name)) {
            lookupString = StringUtil.unquoteString((String)name);
        }
        if (lookupString != null) {
            builder2 = builder2.withLookupString(lookupString);
        }
        return JSCompletionUtil.withJSLookupPriority((LookupElement)builder2, priority);
    }

    public static boolean isExoticName(String name) {
        return name.startsWith("'") || name.startsWith("\"") || name.startsWith("[");
    }

    @NotNull
    public static JSLookupPriority getIndexerPriority(@NotNull JSLookupPriority priority) {
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(47);
        }
        if (priority.getPriorityValue() >= JSLookupPriority.NESTING_LEVEL_REST.getPriorityValue()) {
            JSLookupPriority jSLookupPriority = JSLookupPriority.NESTING_LEVEL_REST;
            if (jSLookupPriority == null) {
                JSLookupUtilImpl.$$$reportNull$$$0(48);
            }
            return jSLookupPriority;
        }
        JSLookupPriority jSLookupPriority = JSLookupPriority.LOWEST_PRIORITY;
        if (jSLookupPriority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(49);
        }
        return jSLookupPriority;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 12, 13, 14, 15, 17, 18, 20, 21, 22, 24, 25, 27, 28, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSLookupUtilImpl";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 37: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 13: 
            case 18: 
            case 36: 
            case 39: 
            case 42: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldActualElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiparamCompletionItem";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSLookupUtilImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAndTailTexts";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleFunctionData";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrioritizedLookupElement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupItemForStaticCall";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementAbstractOrInterfaceLookupItem";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "withPartial";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexerPriority";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAndTailTexts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAndTailTextsWithLocation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFunctionData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPackageLocationString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "willCreateLookupElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createPrioritizedLookupElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toBoldLookupElement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItemForStaticCall";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createImplementAbstractOrInterfaceLookupItem";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "generateMissingMembersForItem";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "withPartial";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPriority";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createPrioritizedLookupItem";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getIndexerPriority";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 12, 13, 14, 15, 17, 18, 20, 21, 22, 24, 25, 27, 28, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47 -> new IllegalArgumentException(string);
        };
    }

    public static final class IconHolder {
        public static final Icon ourEmptyIcon = EmptyIcon.create((Icon)IconManager.getInstance().getPlatformIcon(PlatformIcons.Class));
        public static final Icon ourParamParamIcon = IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter);
    }

    public static class TypeAndTail {
        @Nullable
        final String typeText;
        @Nullable
        final String tailText;
        @Nullable
        final String location;

        public TypeAndTail(@Nullable String typeText, @Nullable String tailText, @Nullable String location) {
            this.typeText = typeText;
            this.tailText = tailText;
            this.location = location;
        }

        public String toString() {
            return this.typeText + ";" + this.tailText + "@" + this.location;
        }

        public String getTailAndType() {
            return this.tailText + ":" + this.typeText;
        }
    }

    static class JSLookupElementFunctionData {
        static final JSLookupElementFunctionData EMPTY = new JSLookupElementFunctionData(null, false, false);
        @Nullable
        final SmartPsiElementPointer<JSFunctionItem> possibleFunction;
        final boolean hasProperty;
        final boolean hasOtherNonEmptySignature;

        JSLookupElementFunctionData(@Nullable JSFunctionItem possibleFunction, boolean hasProperty, boolean hasOtherNonEmptySignature) {
            this.possibleFunction = possibleFunction != null ? SmartPointerManager.createPointer((PsiElement)possibleFunction) : null;
            this.hasProperty = hasProperty;
            this.hasOtherNonEmptySignature = hasOtherNonEmptySignature;
        }
    }

    public static class BoldCheckingLookupElementPresentation
    extends LookupElementPresentation {
    }
}

