/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPredefinedLibrariesData {
    private static final Logger LOG = Logger.getInstance(JSPredefinedLibrariesData.class);
    private final Set<ScriptingLibraryModel> myLibraryModels;
    private final NotNullLazyValue<Set<VirtualFile>> myLibraryFilesForResolve;
    private final NotNullLazyValue<Set<VirtualFile>> myLibraryFiles;
    private final NotNullLazyValue<Map<String, VirtualFile>> myLibraryFileByNameMap;
    private final Set<VirtualFile> myRequiredLibraryFilesForResolve;
    private final Set<VirtualFile> myRequiredLibraryFilesForResolveES5;

    private JSPredefinedLibrariesData(@NotNull Project project, @NotNull Set<ScriptingLibraryModel> models, @NotNull Set<VirtualFile> requiredLibraryFilesToIndex, @NotNull Set<VirtualFile> requiredLibraryFilesForResolve, @NotNull Set<VirtualFile> requiredLibraryFilesForResolveES5) {
        if (project == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(0);
        }
        if (models == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(1);
        }
        if (requiredLibraryFilesToIndex == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(2);
        }
        if (requiredLibraryFilesForResolve == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(3);
        }
        if (requiredLibraryFilesForResolveES5 == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(4);
        }
        this.myLibraryModels = models;
        this.myRequiredLibraryFilesForResolve = Collections.unmodifiableSet(requiredLibraryFilesForResolve);
        this.myRequiredLibraryFilesForResolveES5 = Collections.unmodifiableSet(requiredLibraryFilesForResolveES5);
        this.myLibraryFilesForResolve = NotNullLazyValue.lazy(() -> {
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
            JSPredefinedLibrariesData.addValidFiles(requiredLibraryFilesForResolve.iterator(), result2);
            JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
            for (ScriptingLibraryModel model : models) {
                if (!model.shouldIndexSourcesWithoutMappings() && mappings.getMappingsByLibraryName(model.getName()).isEmpty()) continue;
                JSPredefinedLibrariesData.addValidFiles(model.getSourceFiles().iterator(), result2);
            }
            return Collections.unmodifiableSet(result2);
        });
        this.myLibraryFiles = NotNullLazyValue.lazy(() -> {
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>((Collection)this.myLibraryFilesForResolve.getValue());
            JSPredefinedLibrariesData.addValidFiles(requiredLibraryFilesToIndex.iterator(), result2);
            return Collections.unmodifiableSet(result2);
        });
        this.myLibraryFileByNameMap = NotNullLazyValue.lazy(() -> {
            Set files = (Set)this.myLibraryFiles.getValue();
            HashMap<String, VirtualFile> map2 = new HashMap<String, VirtualFile>(files.size());
            for (VirtualFile file : files) {
                map2.put(file.getName(), file);
            }
            return map2;
        });
    }

    public static void addValidFiles(@NotNull Iterator<VirtualFile> srcIterator, @NotNull Set<VirtualFile> dest) {
        if (srcIterator == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(5);
        }
        if (dest == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(6);
        }
        while (srcIterator.hasNext()) {
            VirtualFile file = srcIterator.next();
            if (file.isValid()) {
                dest.add(file);
                continue;
            }
            LOG.warn("Skipping invalid file " + String.valueOf(file));
        }
    }

    @NotNull
    public Set<VirtualFile> getLibraryFiles() {
        Set set = (Set)this.myLibraryFiles.getValue();
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<ScriptingLibraryModel> getLibraryModels() {
        Set<ScriptingLibraryModel> set = this.myLibraryModels;
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public VirtualFile findPredefinedFileByName(@NotNull String fileName) {
        if (fileName == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(9);
        }
        return (VirtualFile)((Map)this.myLibraryFileByNameMap.getValue()).get(fileName);
    }

    public boolean isPredefinedFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(10);
        }
        return ((Set)this.myLibraryFiles.getValue()).contains(file);
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve() {
        Set<VirtualFile> set = this.myRequiredLibraryFilesForResolve;
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolveES5() {
        Set<VirtualFile> set = this.myRequiredLibraryFilesForResolveES5;
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getLibraryFilesForResolve() {
        Set set = (Set)this.myLibraryFilesForResolve.getValue();
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public static JSPredefinedLibrariesData create(@NotNull Project project) {
        if (project == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(14);
        }
        HashSet<ScriptingLibraryModel> models = new HashSet<ScriptingLibraryModel>();
        HashSet<VirtualFile> requiredFilesToIndex = new HashSet<VirtualFile>();
        HashSet<VirtualFile> requiredFilesForResolve = new HashSet<VirtualFile>();
        HashSet<VirtualFile> requiredFilesForResolveES5 = new HashSet<VirtualFile>();
        for (JSPredefinedLibraryProvider provider : JSPredefinedLibraryProvider.EP_NAME.getExtensionList()) {
            models.addAll(Arrays.asList(provider.getPredefinedLibraries(project)));
            requiredFilesToIndex.addAll(provider.getRequiredLibraryFilesToIndex());
            requiredFilesForResolve.addAll(provider.getRequiredLibraryFilesForResolve());
            requiredFilesForResolveES5.addAll(provider.getRequiredLibraryFilesForResolveES5());
        }
        return new JSPredefinedLibrariesData(project, models, requiredFilesToIndex, requiredFilesForResolve, requiredFilesForResolveES5);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredLibraryFilesToIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredLibraryFilesForResolve";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredLibraryFilesForResolveES5";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcIterator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSPredefinedLibrariesData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSPredefinedLibrariesData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryModels";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolveES5";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFilesForResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addValidFiles";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPredefinedFileByName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

