/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProviderFacade;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.structure.JSTypeStructure;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSType
extends JSTypeStructure,
UserDataHolder {
    public static final LocalTypeKey SUBSTITUTE_COMPLETE = JSType.createLocalTypeKey("substitute.with.complete");
    public static final String COMMENT_DELIMITERS = "|/";

    public static boolean isEquivalentToSafe(@Nullable JSType lType, @Nullable JSType rType, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        return lType == rType || lType != null && lType.isEquivalentTo(rType, processingContext, allowResolve);
    }

    @NotNull
    public static LocalTypeKey createLocalTypeKey(@NotNull String name) {
        if (name == null) {
            JSType.$$$reportNull$$$0(0);
        }
        return new LocalTypeKey(name);
    }

    @NotNull
    public JSResolvedTypeId getResolvedTypeId();

    @NotNull
    @NlsSafe
    public String getTypeText(@NotNull TypeTextFormat var1);

    @NotNull
    default public String getTypeText() {
        String string = this.getTypeText(TypeTextFormat.SIMPLE);
        if (string == null) {
            JSType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    default public String getResolvedTypeText() {
        String string = this.getTypeText(TypeTextFormat.RESOLVED);
        if (string == null) {
            JSType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    default public JSType withNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSType.$$$reportNull$$$0(3);
        }
        JSType jSType = this;
        if (jSType == null) {
            JSType.$$$reportNull$$$0(4);
        }
        return jSType;
    }

    default public void buildTypeText(@NotNull TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSType.$$$reportNull$$$0(5);
        }
        if (builder2 == null) {
            JSType.$$$reportNull$$$0(6);
        }
        builder2.append(this.getTypeText(format));
    }

    public void accept(@NotNull JSRecursiveTypeVisitor var1);

    public void acceptChildren(@NotNull JSRecursiveTypeVisitor var1);

    @Deprecated
    @Nullable
    default public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public JSTypeSource getSource();

    public boolean isDirectlyAssignableType(@Nullable JSType var1, @Nullable ProcessingContext var2);

    public boolean isEquivalentTo(@Nullable JSType var1, @Nullable ProcessingContext var2, boolean var3);

    public boolean isEquivalentTo(@Nullable JSType var1, @Nullable ProcessingContext var2);

    @NotNull
    public JSType transformTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> var1);

    @NotNull
    public JSType transformTypeHierarchy(@NotNull JSRecursiveTypeTransformer var1);

    @NotNull
    public JSType substituteCompilerTypesInTypeHierarchy();

    @NotNull
    public JSType copyWithStrict(boolean var1);

    @NotNull
    public JSType substitute();

    @NotNull
    public JSType substitute(@Nullable PsiElement var1);

    @NotNull
    public JSType substitute(@NotNull ProcessingContext var1);

    @Nullable
    default public JSType substitute(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            JSType.$$$reportNull$$$0(7);
        }
        return this;
    }

    @NotNull
    public JSRecordType asRecordType();

    @NotNull
    default public JSRecordType asRecordType(@Nullable PsiElement evaluationLocation) {
        JSRecordType jSRecordType = JSTypeEvaluationLocationProviderFacade.withTypeEvaluationLocation(evaluationLocation, () -> this.asRecordType());
        if (jSRecordType == null) {
            JSType.$$$reportNull$$$0(8);
        }
        return jSRecordType;
    }

    @NotNull
    default public Stream<JSType> getFunctionTypes(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSType.$$$reportNull$$$0(9);
        }
        Stream<JSType> stream = Stream.empty();
        if (stream == null) {
            JSType.$$$reportNull$$$0(10);
        }
        return stream;
    }

    default public boolean isTypeScript() {
        return this.getSource().isTypeScript();
    }

    default public boolean isEcma() {
        return this.getSource().isEcma();
    }

    default public boolean isJavaScript() {
        return this.getSource().isJavaScript();
    }

    default public boolean isSourceStrict() {
        return this.getSource().isStrict();
    }

    @Nullable
    default public PsiElement getSourceElement() {
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        return element == null || !element.isValid() ? null : element;
    }

    @NotNull
    default public JSType getResolveCachedType(@NotNull Supplier<? extends JSType> factory, @NotNull LocalTypeKey cacheKey) {
        JSType type2;
        if (factory == null) {
            JSType.$$$reportNull$$$0(11);
        }
        if (cacheKey == null) {
            JSType.$$$reportNull$$$0(12);
        }
        JSType jSType = (type2 = factory.get()) == null ? this : type2;
        if (jSType == null) {
            JSType.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    default public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSType.$$$reportNull$$$0(14);
        }
    }

    @NotNull
    default public String getDefaultValue() {
        return "undefined";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 8, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withNewSource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveCachedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLocalTypeKey";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withNewSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolveCachedType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 8, 10, 13 -> new IllegalStateException(string);
        };
    }

    public static final class LocalTypeKey
    extends Key<JSType> {
        public LocalTypeKey(@NotNull String name) {
            if (name == null) {
                LocalTypeKey.$$$reportNull$$$0(0);
            }
            super(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/JSType$LocalTypeKey", "<init>"));
        }
    }

    public static enum TypeTextFormat {
        SIMPLE,
        RESOLVED,
        PRESENTABLE,
        CODE;

    }
}

