/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.literal;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementCustomProvider;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class JSLiteralImplicitElementProvidersRegistry {
    private final Map<String, Collection<JSLiteralImplicitElementProvider>> ourCallArgumentsProvidersRegistry = new HashMap<String, Collection<JSLiteralImplicitElementProvider>>();
    private final Collection<JSLiteralImplicitElementCustomProvider> ourCustomProvidersRegistry = new SmartList();

    public JSLiteralImplicitElementProvidersRegistry() {
        this.registerHandlers();
        FrameworkIndexingHandler.EP_NAME.addChangeListener(() -> this.registerHandlers(), null);
    }

    private void registerHandlers() {
        this.ourCallArgumentsProvidersRegistry.clear();
        this.ourCustomProvidersRegistry.clear();
        this.addImplicitElementProvider("defineProperty", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                String name;
                JSExpression[] arguments;
                if (argument == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((arguments = callExpression.getArguments()).length >= 3 && argument == arguments[1] && (name = argument.getValueAsPropertyName()) != null) {
                    JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally(arguments[0]);
                    JSQualifiedName qualifiedName = ns != null ? ns.getQualifiedName() : null;
                    JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(name, (PsiElement)argument).setNamespace(qualifiedName).setJSType(JSTypeParser.createTypeFromJSDoc(callExpression.getProject(), JSDocumentationUtils.findType((PsiElement)callExpression), JSTypeSource.EMPTY));
                    outIndexingData.addImplicitElement(new JSImplicitElementImpl(builder2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$1";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JSLiteralImplicitElementProvider type2 = new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                String name;
                JSExpression[] arguments;
                if (argument == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    2.$$$reportNull$$$0(2);
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (arguments = callExpression.getArguments()).length == 2 && arguments[0] == argument && (name = argument.getValueAsPropertyName()) != null) {
                    JSQualifiedName namespace = JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    outIndexingData.addImplicitElement(new JSImplicitElementImpl(name, namespace, (PsiElement)argument));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$2";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.addImplicitElementProvider("__defineGetter__", type2);
        this.addImplicitElementProvider("__defineSetter__", type2);
        this.addImplicitElementProvider("method", type2);
        this.addImplicitElementProvider("provide", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                if (argument == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    3.$$$reportNull$$$0(2);
                }
                JSLiteralImplicitElementProvidersRegistry.this.addClassFromArgument(argument, callExpression, null, null, outIndexingData);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$3";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.addImplicitElementProvider("addProperty", new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSExpression[] jsExpressions;
                if (argument == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    4.$$$reportNull$$$0(2);
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (jsExpressions = callExpression.getArguments()).length == 2 && jsExpressions[0] == argument) {
                    JSQualifiedName namespace = JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    String propertyName = argument.getValueAsPropertyName();
                    String type2 = StringUtil.toLowerCase((String)jsExpressions[1].getText());
                    if (propertyName != null) {
                        JSImplicitElementImpl.Builder builder2;
                        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)callExpression);
                        String typeString = null;
                        if (comment instanceof JSDocComment) {
                            typeString = ((JSDocComment)comment).getType();
                        }
                        if (type2.contains("read")) {
                            builder2 = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestGetterName(propertyName), (PsiElement)argument).setType(JSImplicitElement.Type.Function).setJSType(JSTypeParser.createTypeFromJSDoc(argument.getProject(), typeString, JSTypeSource.EMPTY)).setNamespace(namespace);
                            outIndexingData.addImplicitElement(builder2.toImplicitElement());
                        }
                        if (type2.contains("write")) {
                            builder2 = new JSImplicitElementImpl.Builder(JSSymbolUtil.suggestSetterName(propertyName), (PsiElement)argument).setType(JSImplicitElement.Type.Function).setParameters(Collections.singletonList(new JSImplicitParameterStructure(propertyName, typeString, false, false, true))).setNamespace(namespace);
                            outIndexingData.addImplicitElement(builder2.toImplicitElement());
                        }
                        builder2 = new JSImplicitElementImpl.Builder("_" + propertyName, (PsiElement)argument).setNamespace(namespace).setJSType(JSTypeParser.createTypeFromJSDoc(argument.getProject(), typeString, JSTypeSource.EMPTY));
                        outIndexingData.addImplicitElement(builder2.toImplicitElement());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$4";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        type2 = JSLiteralImplicitElementProvidersRegistry.createClassImplicitElementProvider(true);
        this.addImplicitElementProvider("namespace", type2);
        this.addImplicitElementProvider("ns", type2);
        type2 = JSLiteralImplicitElementProvidersRegistry.createClassImplicitElementProvider(false);
        this.addImplicitElementProvider("defineClass", type2);
        this.addImplicitElementProvider("define", type2);
        type2 = new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSExpression[] jsExpressions;
                if (argument == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    5.$$$reportNull$$$0(2);
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier instanceof JSReferenceExpression && (jsExpressions = callExpression.getArguments()).length == 2 && jsExpressions[0] == argument) {
                    JSReferenceExpression refExpr = (JSReferenceExpression)qualifier;
                    JSQualifiedName namespace = "Window".equals(refExpr.getReferencedName()) && refExpr.getQualifier() == null ? null : JSSymbolUtil.evaluateReferencedNamespace(qualifier);
                    String propertyName = argument.getValueAsPropertyName();
                    if (propertyName != null) {
                        outIndexingData.addImplicitElement(new JSImplicitElementImpl(propertyName, namespace, (PsiElement)argument));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$5";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.addImplicitElementProvider("extend", type2);
        this.addImplicitElementProvider("implement", type2);
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            for (String methodName : handler.implicitProviderMethodNames()) {
                this.addImplicitElementProvider(methodName, handler.createLiteralImplicitElementProvider(methodName));
            }
            JSLiteralImplicitElementCustomProvider customProvider = handler.createLiteralImplicitElementCustomProvider();
            if (customProvider == null) continue;
            this.ourCustomProvidersRegistry.add(customProvider);
        }
    }

    public void addClassFromArgument(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @Nullable FrameworkIndexingHandler indexingHandler, @Nullable String userStringFromIndexingHandler, @NotNull JSElementIndexingData outIndexingData) {
        JSQualifiedName qualifiedName;
        JSExpression[] jsExpressions;
        if (argument == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(0);
        }
        if (callExpression == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(1);
        }
        if (outIndexingData == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(2);
        }
        if ((jsExpressions = callExpression.getArguments()).length == 1 && jsExpressions[0] == argument && (qualifiedName = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
            JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(qualifiedName.getName(), (PsiElement)argument).setNamespace(qualifiedName.getParent()).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Class);
            if (userStringFromIndexingHandler != null && indexingHandler != null) {
                builder2.setUserString(indexingHandler, userStringFromIndexingHandler);
            }
            JSImplicitElementImpl element = builder2.toImplicitElement();
            outIndexingData.addImplicitElement(element);
            JSStubIndexingUtils.addImplicitNamespaces(qualifiedName.getParent(), outIndexingData.getImplicitElements(), (PsiElement)argument);
        }
    }

    @NotNull
    private static JSLiteralImplicitElementProvider createClassImplicitElementProvider(final boolean isNamespace) {
        return new JSLiteralImplicitElementProvider(){

            @Override
            public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                JSQualifiedName qualifiedName;
                if (argument == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (callExpression == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (outIndexingData == null) {
                    6.$$$reportNull$$$0(2);
                }
                JSExpression methodExpression = callExpression.getMethodExpression();
                assert (methodExpression instanceof JSReferenceExpression);
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier != null && (qualifiedName = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
                    if ((!"YAHOO".equals(qualifiedName.getName()) || qualifiedName.getParent() == null) && "YAHOO".equals(qualifier.getText())) {
                        qualifiedName = JSQualifiedNameImpl.concat(JSQualifiedNameImpl.create("YAHOO", null), qualifiedName);
                    }
                    JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(qualifiedName.getName(), (PsiElement)argument).setNamespace(qualifiedName.getParent()).setType(isNamespace ? JSImplicitElement.Type.Namespace : JSImplicitElement.Type.Class);
                    outIndexingData.addImplicitElement(new JSImplicitElementImpl(builder2));
                    JSStubIndexingUtils.addImplicitNamespaces(qualifiedName.getParent(), outIndexingData.getImplicitElements(), (PsiElement)argument);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "argument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outIndexingData";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry$6";
                objectArray[2] = "fillIndexingData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void addImplicitElementProvider(String methodName, JSLiteralImplicitElementProvider type2) {
        SmartList list = this.ourCallArgumentsProvidersRegistry.get(methodName);
        if (list == null) {
            list = new SmartList();
            this.ourCallArgumentsProvidersRegistry.put(methodName, (Collection<JSLiteralImplicitElementProvider>)list);
        }
        list.add((JSLiteralImplicitElementProvider)type2);
    }

    @Nullable
    public JSElementIndexingData calculateIndexingData(@NotNull JSLiteralExpression literalExpression) {
        String name;
        JSExpression methodExpression;
        PsiElement grandParent;
        PsiElement parent;
        if (literalExpression == null) {
            JSLiteralImplicitElementProvidersRegistry.$$$reportNull$$$0(3);
        }
        if ((parent = literalExpression.getParent()) instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && (name = ((JSReferenceExpression)methodExpression).getReferencedName()) != null && this.ourCallArgumentsProvidersRegistry.containsKey(name)) {
            Collection<JSLiteralImplicitElementProvider> elementProviderTypes = this.ourCallArgumentsProvidersRegistry.get(name);
            JSElementIndexingDataImpl data = new JSElementIndexingDataImpl();
            for (JSLiteralImplicitElementProvider type2 : elementProviderTypes) {
                type2.fillIndexingData(literalExpression, (JSCallExpression)grandParent, data);
            }
            return data;
        }
        JSElementIndexingDataImpl result2 = null;
        ASTNode node = literalExpression.getNode();
        for (JSLiteralImplicitElementCustomProvider provider : this.ourCustomProvidersRegistry) {
            if (!provider.checkIfCandidate(node)) continue;
            if (result2 == null) {
                result2 = new JSElementIndexingDataImpl();
            }
            provider.fillIndexingDataForCandidate(literalExpression, result2);
        }
        return result2;
    }

    public boolean shouldCreateStub(ASTNode node) {
        String name;
        ASTNode methodExpression;
        ASTNode grandParent;
        ASTNode parent = node.getTreeParent();
        if (parent != null && parent.getElementType() == JSElementTypes.ARGUMENT_LIST && (grandParent = parent.getTreeParent()) != null && grandParent.getElementType() == JSStubElementTypes.CALL_EXPRESSION && (methodExpression = grandParent.getFirstChildNode()) != null && methodExpression.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && this.ourCallArgumentsProvidersRegistry.containsKey(name = JSReferenceExpressionImpl.getReferenceName(methodExpression))) {
            return true;
        }
        for (JSLiteralImplicitElementCustomProvider customProvider : this.ourCustomProvidersRegistry) {
            if (!customProvider.checkIfCandidate(node)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outIndexingData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/literal/JSLiteralImplicitElementProvidersRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addClassFromArgument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateIndexingData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

