/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;

public class JSReferenceResolver {
    @NotNull
    protected final PsiElement myRef;

    public JSReferenceResolver(@NotNull PsiElement ref2) {
        if (ref2 == null) {
            JSReferenceResolver.$$$reportNull$$$0(0);
        }
        this.myRef = ref2;
    }

    public ResolveResult @NotNull [] doResolveQualifiedName(@NotNull JSQualifiedName qualifiedName, boolean ignorePerformanceLimit) {
        ResolveResult[] localResults;
        if (qualifiedName == null) {
            JSReferenceResolver.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = this.myRef.getContainingFile();
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(qualifiedName.getName(), psiFile, this.myRef);
        JSQualifiedName qualifier = qualifiedName.getParent();
        if (qualifier != null) {
            JSReferenceResolver.addTypeInHierarchyOrRecordType(processor, JSNamedTypeFactory.createNamespace(qualifier, JSContext.UNKNOWN, this.myRef, true));
        }
        processor.allowPartialResults();
        String str = qualifiedName.getQualifiedName();
        if (qualifier == null) {
            SinkResolveProcessor<ResolveResultSink> localProcessor = new SinkResolveProcessor<ResolveResultSink>(str, new ResolveResultSink(this.myRef, str));
            this.processLocalVariants(localProcessor);
            processor.addLocalResults(localProcessor);
        }
        if ((localResults = processor.getResults()).length > 0) {
            if (localResults == null) {
                JSReferenceResolver.$$$reportNull$$$0(2);
            }
            return localResults;
        }
        JSIndexBasedResolveUtil.processAllSymbols(processor, ignorePerformanceLimit);
        ResolveResult[] results = processor.getResults();
        if (results.length == 0 && "undefined".equals(str)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(this.myRef)};
            if (resolveResultArray == null) {
                JSReferenceResolver.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (results == null) {
            JSReferenceResolver.$$$reportNull$$$0(4);
        }
        return results;
    }

    protected void processLocalVariants(@NotNull SinkResolveProcessor<?> processor) {
        if (processor == null) {
            JSReferenceResolver.$$$reportNull$$$0(5);
        }
    }

    public static void addTypeInHierarchyOrRecordType(@NotNull BaseJSSymbolProcessor processor, @NotNull JSType namespaceCandidate) {
        JSType candidate;
        if (processor == null) {
            JSReferenceResolver.$$$reportNull$$$0(6);
        }
        if (namespaceCandidate == null) {
            JSReferenceResolver.$$$reportNull$$$0(7);
        }
        if (!((candidate = namespaceCandidate.substitute((PsiElement)processor.myTargetFile)) instanceof JSNamespace)) {
            JSRecordType type2 = candidate.asRecordType();
            if (type2.hasProperties()) {
                processor.getTypeInfo().addRecordType(type2);
            }
        } else {
            processor.addTypeHierarchy((JSNamespace)candidate);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSReferenceResolver";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceCandidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSReferenceResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doResolveQualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processLocalVariants";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTypeInHierarchyOrRecordType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

