/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.evaluation.JSExpressionTypeFactory;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyResolveResultsWithOverloadsType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyThisContextType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeStructuralPartEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyCallType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSCallItem {
    @NotNull
    private final JSType myType;
    @NotNull
    protected final List<JSType> myArgumentTypes;
    @Nullable
    private final JSType myForcedQualifierType;

    public JSApplyCallType(@NotNull JSType baseType, @NotNull JSCallLikeExpression sourceElement) {
        if (baseType == null) {
            JSApplyCallType.$$$reportNull$$$0(0);
        }
        if (sourceElement == null) {
            JSApplyCallType.$$$reportNull$$$0(1);
        }
        super((PsiElement)sourceElement);
        this.myType = baseType;
        JSTypeSource source = this.getSource();
        this.myArgumentTypes = JSApplyCallType.initArgumentTypes(Collections.singletonList(new JSSpreadTypeImpl(source, JSAnyType.get(source))), source);
        this.myForcedQualifierType = null;
    }

    public JSApplyCallType(@NotNull JSType baseType, @NotNull JSTypeSource source) {
        if (baseType == null) {
            JSApplyCallType.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSApplyCallType.$$$reportNull$$$0(3);
        }
        this(baseType, Collections.singletonList(new JSSpreadTypeImpl(source, JSAnyType.get(source))), source);
    }

    public JSApplyCallType(@NotNull JSType baseType, @NotNull List<JSType> argumentTypes, @NotNull JSCallLikeExpression sourceElement) {
        if (baseType == null) {
            JSApplyCallType.$$$reportNull$$$0(4);
        }
        if (argumentTypes == null) {
            JSApplyCallType.$$$reportNull$$$0(5);
        }
        if (sourceElement == null) {
            JSApplyCallType.$$$reportNull$$$0(6);
        }
        super((PsiElement)sourceElement);
        this.myType = baseType;
        this.myArgumentTypes = JSApplyCallType.initArgumentTypes(argumentTypes, this.getSource());
        this.myForcedQualifierType = null;
    }

    public JSApplyCallType(@NotNull JSType baseType, @NotNull List<JSType> argumentTypes, @NotNull JSTypeSource source) {
        if (baseType == null) {
            JSApplyCallType.$$$reportNull$$$0(7);
        }
        if (argumentTypes == null) {
            JSApplyCallType.$$$reportNull$$$0(8);
        }
        if (source == null) {
            JSApplyCallType.$$$reportNull$$$0(9);
        }
        this(baseType, argumentTypes, null, source);
    }

    private JSApplyCallType(@NotNull JSType baseType, @NotNull List<JSType> argumentTypes, @Nullable JSType forcedQualifierType, @NotNull JSTypeSource source) {
        if (baseType == null) {
            JSApplyCallType.$$$reportNull$$$0(10);
        }
        if (argumentTypes == null) {
            JSApplyCallType.$$$reportNull$$$0(11);
        }
        if (source == null) {
            JSApplyCallType.$$$reportNull$$$0(12);
        }
        super(source);
        this.myType = baseType;
        this.myArgumentTypes = JSApplyCallType.initArgumentTypes(argumentTypes, source);
        this.myForcedQualifierType = forcedQualifierType;
    }

    @NotNull
    private static List<JSType> initArgumentTypes(@NotNull List<JSType> argumentTypes, @NotNull JSTypeSource source) {
        if (argumentTypes == null) {
            JSApplyCallType.$$$reportNull$$$0(13);
        }
        if (source == null) {
            JSApplyCallType.$$$reportNull$$$0(14);
        }
        List list = argumentTypes.contains(null) ? ContainerUtil.map(argumentTypes, type2 -> (JSType)ObjectUtils.notNull((Object)type2, (Object)JSAnyType.get(source))) : argumentTypes;
        if (list == null) {
            JSApplyCallType.$$$reportNull$$$0(15);
        }
        return list;
    }

    public JSApplyCallType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSApplyCallType.$$$reportNull$$$0(16);
        }
        if (inputStream == null) {
            JSApplyCallType.$$$reportNull$$$0(17);
        }
        super(source);
        this.myType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myArgumentTypes = JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream);
        this.myForcedQualifierType = null;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSApplyCallType.$$$reportNull$$$0(18);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myArgumentTypes, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSApplyCallType.$$$reportNull$$$0(19);
        }
        this.myType.accept(visitor);
        for (JSType type2 : this.myArgumentTypes) {
            if (type2 == null) continue;
            type2.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSApplyCallType.$$$reportNull$$$0(20);
        }
        return new JSApplyCallType(this.myType, this.myArgumentTypes, source);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myType, JSTypeHashCodeUtil.getHashCode(this.myArgumentTypes));
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            JSApplyCallType.$$$reportNull$$$0(21);
        }
        return this.myType.isEquivalentTo(((JSApplyCallType)type2).myType, context2, allowResolve) && JSTypeCastUtil.areListsEquivalent(this.myArgumentTypes, ((JSApplyCallType)type2).myArgumentTypes, context2, allowResolve);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            JSApplyCallType.$$$reportNull$$$0(22);
        }
        if (newSource == null) {
            JSApplyCallType.$$$reportNull$$$0(23);
        }
        JSType newBaseType = this.myType.transformTypeHierarchy(childTransform);
        List newArguments = ContainerUtil.map(this.myArgumentTypes, el -> el.transformTypeHierarchy(childTransform));
        if (ContainerUtil.equalsIdentity((List)newArguments, this.myArgumentTypes) && this.myType == newBaseType) {
            JSApplyCallType jSApplyCallType = this;
            if (jSApplyCallType == null) {
                JSApplyCallType.$$$reportNull$$$0(24);
            }
            return jSApplyCallType;
        }
        return new JSApplyCallType(newBaseType, (List<JSType>)newArguments, newSource);
    }

    @NotNull
    public JSType getBaseType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSApplyCallType.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @Override
    @NotNull
    public List<JSType> getArgumentTypes(@NotNull JSExpressionTypeFactory argumentTypeFactory) {
        if (argumentTypeFactory == null) {
            JSApplyCallType.$$$reportNull$$$0(26);
        }
        List<JSType> list = this.myArgumentTypes;
        if (list == null) {
            JSApplyCallType.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Override
    public int getArgumentSize() {
        return this.myArgumentTypes.size();
    }

    @Override
    public JSTypeDeclaration @NotNull [] getTypeArguments() {
        PsiElement sourceElement = this.getSourceElement();
        JSTypeDeclaration[] jSTypeDeclarationArray = sourceElement instanceof JSCallItem ? ((JSCallItem)sourceElement).getTypeArguments() : JSTypeDeclaration.EMPTY_ARRAY;
        if (jSTypeDeclarationArray == null) {
            JSApplyCallType.$$$reportNull$$$0(28);
        }
        return jSTypeDeclarationArray;
    }

    @Override
    @Nullable
    public PsiElement getPsiContext() {
        return this.getSourceElement();
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        JSCallItem callItem;
        if (evaluateContext == null) {
            JSApplyCallType.$$$reportNull$$$0(29);
        }
        JSExpression methodExpression = (callItem = this.getCallItem(evaluateContext)) instanceof JSCallLikeExpression ? ((JSCallLikeExpression)callItem).getMethodExpression() : null;
        JSType baseType = this.getBaseType();
        ArrayList<JSEvaluationTask> tasks = new ArrayList<JSEvaluationTask>();
        tasks.add(new JSApplyCallTypeEvaluator(callItem).evaluate(baseType, evaluateContext));
        if (methodExpression instanceof JSReferenceExpression) {
            tasks.add(JSTypeEvaluator.getAdditionalTypes((PsiElement)methodExpression, (JSReferenceExpression)methodExpression, evaluateContext));
        }
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(tasks);
        if (jSEvaluationTask == null) {
            JSApplyCallType.$$$reportNull$$$0(30);
        }
        return jSEvaluationTask;
    }

    @NotNull
    private JSCallItem getCallItem(@NotNull JSEvaluateContext evaluateContext) {
        PsiElement sourceElement;
        if (evaluateContext == null) {
            JSApplyCallType.$$$reportNull$$$0(31);
        }
        JSCallItem jSCallItem = (sourceElement = this.getSourceElement()) instanceof JSCallItem && this.isAstAccessAllowedForCall(evaluateContext, sourceElement) ? (JSCallItem)sourceElement : this;
        if (jSCallItem == null) {
            JSApplyCallType.$$$reportNull$$$0(32);
        }
        return jSCallItem;
    }

    private boolean isAstAccessAllowedForCall(@NotNull JSEvaluateContext evaluateContext, @NotNull PsiElement sourceElement) {
        if (evaluateContext == null) {
            JSApplyCallType.$$$reportNull$$$0(33);
        }
        if (sourceElement == null) {
            JSApplyCallType.$$$reportNull$$$0(34);
        }
        if (evaluateContext.isAstAccessAllowed(sourceElement)) {
            return true;
        }
        JSType methodExpressionType = this.getBaseType();
        return methodExpressionType instanceof JSPsiBasedTypeOfType && ((JSPsiBasedTypeOfType)methodExpressionType).getEvaluateContext().isAstAccessAllowed(sourceElement);
    }

    @Override
    @Nullable
    public JSType getQualifierType() {
        return this.myForcedQualifierType != null ? this.myForcedQualifierType : this.getQualifierTypeFromBaseType(null);
    }

    @Nullable
    private JSType getQualifierTypeFromBaseType(@Nullable JSEvaluateContext evaluateContext) {
        JSType baseType = this.getBaseType();
        if (baseType instanceof JSQualifiedReferenceType) {
            return ((JSQualifiedReferenceType)baseType).getQualifierType();
        }
        if (evaluateContext != null) {
            JSExpression qualifier;
            JSExpression methodExpression;
            JSCallItem callItem = this.getCallItem(evaluateContext);
            JSExpression jSExpression = methodExpression = callItem instanceof JSCallLikeExpression ? ((JSCallLikeExpression)callItem).getMethodExpression() : null;
            if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
                return JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)qualifier, evaluateContext);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 24, 25, 27, 28, 30, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 1: 
            case 6: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 15: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSApplyCallType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypeFactory";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSApplyCallType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "initArgumentTypes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initArgumentTypes";
                break;
            }
            case 15: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypes";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCallItem";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAstAccessAllowedForCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 24, 25, 27, 28, 30, 32 -> new IllegalStateException(string);
        };
    }

    class JSApplyCallTypeEvaluator
    extends JSTypeStructuralPartEvaluator {
        @NotNull
        protected final JSCallItem myCallItem;

        protected JSApplyCallTypeEvaluator(JSCallItem callItem) {
            if (callItem == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(0);
            }
            this.myCallItem = callItem;
        }

        @Override
        protected boolean processSpecialTypes(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext, @NotNull List<JSEvaluationTask> outTasks) {
            JSType typeForRegexpGroups;
            JSLiteralExpression literalRegexpExecCalled;
            JSReferenceExpression expression;
            PsiElement resolveResult;
            Object element;
            if (type2 == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(1);
            }
            if (evaluateContext == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(2);
            }
            if (outTasks == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(3);
            }
            if (!this.processOptimized(type2, evaluateContext, outTasks)) {
                return false;
            }
            if (JSApplyCallType.this.getSource().isEcma() && type2 instanceof JSTypeOfPsiElementBase && (element = ((JSTypeOfPsiElementBase)type2).getElement()) instanceof JSReferenceExpression && (resolveResult = (expression = (JSReferenceExpression)element).resolve()) instanceof ActionScriptClassImpl) {
                JSType typeFromClass = ActionScriptResolveUtil.getTypeFromClass(expression, (ActionScriptClassImpl)resolveResult);
                if (typeFromClass != null) {
                    outTasks.add(new JSEvaluationResultElement(typeFromClass, false, evaluateContext));
                }
                return false;
            }
            if ((type2 instanceof JSReferenceExpressionType || type2 instanceof JSPsiBasedTypeOfType) && (element = ((JSTypeOfPsiElementBase)type2).getElement()) instanceof JSReferenceExpression && (literalRegexpExecCalled = ES6TypeEvaluator.findLiteralForRegexpExecCall((JSReferenceExpression)element)) != null && (typeForRegexpGroups = ES6TypeEvaluator.getTypeForRegexpGroups(literalRegexpExecCalled)) != null) {
                outTasks.add(JSEvaluationResultElement.fromAdditionalType(typeForRegexpGroups, evaluateContext));
            }
            if (type2 instanceof JSPsiBasedTypeOfType || type2 instanceof JSStubBasedExpressionType) {
                Object object = element = type2 instanceof JSPsiBasedTypeOfType ? ((JSPsiBasedTypeOfType)type2).getElement() : ((JSStubBasedExpressionType)type2).findAssociatedExpression();
                if (element instanceof JSFunction) {
                    JSType newTypeFromFunction = this.applyToFunction((JSFunction)element, evaluateContext);
                    if (newTypeFromFunction != null && ((JSFunction)element).isGetProperty()) {
                        newTypeFromFunction = this.applyToFunctionType(newTypeFromFunction);
                    }
                    if (newTypeFromFunction != null) {
                        JSType alias = JSTypeEvaluator.findAliasTypeFromDocComment(element);
                        if (alias != null) {
                            List<JSType> types = this.applyToType(alias);
                            outTasks.addAll(ContainerUtil.map(types, t -> JSEvaluationResultElement.fromType(t, evaluateContext)));
                        }
                        JSEvaluateContext functionContext = evaluateContext;
                        JSType qualifierType = JSApplyCallType.this.myForcedQualifierType;
                        if (qualifierType == null) {
                            qualifierType = JSApplyCallType.this.getQualifierTypeFromBaseType(evaluateContext);
                        }
                        if (qualifierType != null) {
                            JSType currentThisType = evaluateContext.getThisContext();
                            JSType newThisType = currentThisType != null ? new JSApplyThisContextType(qualifierType, currentThisType, qualifierType.getSource()) : qualifierType;
                            functionContext = evaluateContext.withThisContext(newThisType);
                        }
                        outTasks.add(new JSEvaluationResultElement(newTypeFromFunction, false, functionContext));
                        return false;
                    }
                }
            }
            PsiElement sourceElement = JSApplyCallType.this.getPsiContext();
            if (type2 instanceof JSApplyResolveResultsWithOverloadsType && sourceElement != null) {
                JSEvaluationTask filteredOverloads = ((JSApplyResolveResultsWithOverloadsType)type2).filterOverloads(this.myCallItem, sourceElement, evaluateContext);
                outTasks.add(this.applyToBaseType(filteredOverloads, evaluateContext));
                return false;
            }
            return true;
        }

        protected boolean processOptimized(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext, @NotNull List<JSEvaluationTask> outTasks) {
            if (type2 == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(4);
            }
            if (evaluateContext == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(5);
            }
            if (outTasks == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(6);
            }
            if (type2 instanceof JSModuleTypeImpl) {
                List<JSPsiBasedTypeOfType> typesFromExportedElements = ((JSModuleTypeImpl)type2).getTypesFromExportedElements(evaluateContext);
                List tasks = ContainerUtil.map(typesFromExportedElements, t -> {
                    JSEvaluationTask task = (JSEvaluationTask)JSEvaluationRecursionGuard.compute(t, evaluateContext, () -> this.evaluate((JSType)t, evaluateContext));
                    return task != null ? task : JSEvaluationTasks.EMPTY;
                });
                outTasks.add(JSEvaluationTasks.fromSet(tasks, type2.isJavaScript()));
                return false;
            }
            return true;
        }

        @Nullable
        protected JSType applyToFunction(@NotNull JSFunction function, @NotNull JSEvaluateContext context2) {
            JSQualifiedName namespace;
            if (function == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(7);
            }
            if (context2 == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(8);
            }
            if (!context2.isAstAccessAllowed(function, true)) {
                JSType returnType2 = JSFunctionImpl.evaluateReturnTypeFromHierarchy(function);
                if (returnType2 != null) {
                    returnType2 = this.applyGenerics(function, returnType2);
                }
                return returnType2;
            }
            JSType jsType = JSFunctionImpl.getReturnTypeInContext(function, (PsiElement)context2.getProcessedExpression(), context2.getContextualExpectedTypeKind());
            if (jsType != null) {
                jsType = this.applyGenerics(function, jsType);
            }
            if ((namespace = function.getJSNamespace().getQualifiedName()) instanceof JSQualifiedNameImpl && ((JSQualifiedNameImpl)namespace).matches("jQuery")) {
                JSType jQueryType = JSTypeEvaluator.getJQueryType(function);
                jsType = jsType == null ? jQueryType : JSCompositeTypeFactory.createContextualUnionType(Arrays.asList(jsType, jQueryType), jsType.getSource());
            }
            return jsType;
        }

        @Override
        @NotNull
        protected List<JSType> applyToType(@NotNull JSType type2) {
            if (type2 == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(9);
            }
            List list = ContainerUtil.createMaybeSingletonList((Object)this.applyToFunctionType(type2));
            if (list == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(10);
            }
            return list;
        }

        @Nullable
        protected JSType applyToFunctionType(@NotNull JSType type2) {
            List<JSType> types;
            JSExpression methodExpression;
            if (type2 == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(11);
            }
            JSType returnType2 = JSTypeUtils.getReturnType(type2, this.myCallItem);
            JSExpression jSExpression = methodExpression = this.myCallItem instanceof JSCallLikeExpression ? ((JSCallLikeExpression)this.myCallItem).getMethodExpression() : null;
            if (returnType2 == null) {
                returnType2 = JSAnyType.get((PsiElement)methodExpression);
            }
            if (returnType2 instanceof JSAnyType && JSNamedType.isNamedTypeWithNames(type2, JSCommonTypeNames.NODE_REQUIRE_FUNCTIONS) && (types = this.myCallItem.getArgumentTypes(JSPsiBasedTypeOfType.getArgumentTypeFactory(false))).size() == 1) {
                JSTypeSource source = type2.isJavaScript() ? type2.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)methodExpression, true);
                JSType module = types.get(0);
                if (module != null) {
                    return new JSRequireCallExpressionType(module, source);
                }
            }
            return returnType2;
        }

        @NotNull
        protected JSType applyGenerics(@Nullable JSFunction function, @NotNull JSType jsType) {
            if (jsType == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(12);
            }
            JSType jSType = JSGenericTypesEvaluator.getEvaluator(JSApplyCallType.this.getSourceElement()).evaluateGenerics(jsType, this.myCallItem, (PsiElement)function, JSGenericTypesEvaluator.DEFAULT_CONTEXT);
            if (jSType == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(13);
            }
            return jSType;
        }

        @Override
        @NotNull
        protected JSType copyOwnerType(@NotNull JSType baseType, @NotNull JSEvaluateContext evaluateContext) {
            if (baseType == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(14);
            }
            if (evaluateContext == null) {
                JSApplyCallTypeEvaluator.$$$reportNull$$$0(15);
            }
            return new JSApplyCallType(baseType, JSApplyCallType.this.myArgumentTypes, JSApplyCallType.this.myForcedQualifierType != null ? JSApplyCallType.this.myForcedQualifierType : JSApplyCallType.this.getQualifierTypeFromBaseType(evaluateContext), JSApplyCallType.this.getSource());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callItem";
                    break;
                }
                case 1: 
                case 4: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 5: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outTasks";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSApplyCallType$JSApplyCallTypeEvaluator";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsType";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSApplyCallType$JSApplyCallTypeEvaluator";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyToType";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyGenerics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processSpecialTypes";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processOptimized";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "applyToFunction";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "applyToType";
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "applyToFunctionType";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "applyGenerics";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "copyOwnerType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10, 13 -> new IllegalStateException(string);
            };
        }
    }
}

