/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypescriptTypeInliner
extends JSInlineHandler.Inliner {
    @NotNull
    private final JSClass myToInline;

    TypescriptTypeInliner(@NotNull JSClass toInline) {
        if (toInline == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(0);
        }
        super(toInline);
        this.myToInline = toInline;
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.typescript.inline.type";
    }

    @Nullable
    public static JSInlineHandler.Settings tryCreateSettings(@NotNull JSClass element, @Nullable Editor editor, boolean invokedOnReference, @NotNull NotNullLazyValue<Collection<PsiReference>> elementUsages) {
        if (element == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(1);
        }
        if (elementUsages == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(2);
        }
        if (element.getExtendsList() != null && element.getExtendsList().getExpressions().length > 0 || element.getImplementsList() != null && element.getImplementsList().getExpressions().length > 0) {
            JSInlineHandler.showErrorHint(element, editor, JavaScriptBundle.message("inline.cannot.inline.has.supers", new JSNamedElementPresenter(element).describeElementKind()));
            return null;
        }
        if (element.isInterface() && !PsiTreeUtil.processElements((PsiElement)element, t -> !(t instanceof TypeScriptThisType))) {
            JSInlineHandler.showErrorHint(element, editor, JavaScriptBundle.message("inline.cannot.inline.references.this.type", new Object[0]));
            return null;
        }
        return new JSInlineHandler.Settings(elementUsages, invokedOnReference);
    }

    @Override
    public void checkConflicts(@NotNull PsiReference reference, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (reference == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(4);
        }
        super.checkConflicts(reference, conflicts);
        PsiElement referenceElement = reference.getElement();
        if (referenceElement.getParent() instanceof JSReferenceListMember) {
            boolean isImplements = referenceElement.getParent().getParent().getNode().getElementType() == JSStubElementTypes.IMPLEMENTS_LIST;
            conflicts.putValue((Object)referenceElement, (Object)JavaScriptBundle.message("inline.type.used.in.reference.list", isImplements ? "implements" : "extends"));
        }
    }

    @Override
    @NotNull
    JSInlineHandler.Inliner.JSInlineHandlerResult doInlineUsage(@NotNull JSReferenceExpression usageElement) {
        if (usageElement == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(5);
        }
        TypeScriptSingleType typeUsageElement = (TypeScriptSingleType)ObjectUtils.tryCast((Object)usageElement.getParent(), TypeScriptSingleType.class);
        JSClass namedType = this.myToInline;
        TypeScriptType typeDeclaration = TypescriptTypeInliner.getTypeDeclarationFromReferenced(namedType);
        if (typeUsageElement == null || typeDeclaration == null) {
            JSInlineHandler.Inliner.JSInlineHandlerResult jSInlineHandlerResult = JSInlineHandler.Inliner.JSInlineHandlerResult.EMPTY;
            if (jSInlineHandlerResult == null) {
                TypescriptTypeInliner.$$$reportNull$$$0(6);
            }
            return jSInlineHandlerResult;
        }
        String replacementText = TypescriptTypeInliner.getTypeTextWithAppliedGenerics(typeUsageElement, (TypeScriptTypeParameterListOwner)((Object)namedType), typeDeclaration);
        TypeScriptType usageParent = (TypeScriptType)ObjectUtils.tryCast((Object)typeUsageElement.getParent(), TypeScriptType.class);
        boolean needParens = usageParent != null && !(usageParent instanceof TypeScriptParenthesizedType) && !(typeDeclaration instanceof TypeScriptSingleType) && TypeScriptUtil.getTypePrecedence(usageParent) < TypeScriptUtil.getTypePrecedence(typeDeclaration);
        Object text = needParens ? "(" + replacementText + ")" : replacementText;
        PsiElement replace = typeUsageElement.replace((PsiElement)JSPsiElementFactory.createTypeScriptType((String)text, (PsiElement)typeUsageElement));
        return new JSInlineHandler.Inliner.JSInlineHandlerResult(replace);
    }

    private static String getTypeTextWithAppliedGenerics(@NotNull TypeScriptSingleType typeUsageElement, @NotNull TypeScriptTypeParameterListOwner namedType, @NotNull JSTypeDeclaration replacementTypeDeclaration) {
        JSType usageJSType;
        JSTypeSubstitutor substitutor;
        if (typeUsageElement == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(7);
        }
        if (namedType == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(8);
        }
        if (replacementTypeDeclaration == null) {
            TypescriptTypeInliner.$$$reportNull$$$0(9);
        }
        if ((substitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(namedType, usageJSType = typeUsageElement.getJSType())) == null || substitutor.isEmpty()) {
            return replacementTypeDeclaration.getText();
        }
        final StringBuilder result2 = new StringBuilder();
        replacementTypeDeclaration.accept(new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                PsiElement resolve2;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((resolve2 = node.resolve()) instanceof TypeScriptTypeParameter) {
                    JSTypeGenericId id = ((TypeScriptTypeParameter)resolve2).getGenericId();
                    JSType type2 = substitutor.get(id);
                    if (type2 != null) {
                        result2.append(type2.getTypeText(JSType.TypeTextFormat.CODE));
                    } else {
                        result2.append(node.getText());
                    }
                } else {
                    super.visitJSReferenceExpression(node);
                }
            }

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof LeafPsiElement) {
                    result2.append(element.getText());
                } else {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/TypescriptTypeInliner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result2.toString();
    }

    @Nullable
    private static TypeScriptType getTypeDeclarationFromReferenced(@Nullable JSClass referenced) {
        if (referenced instanceof TypeScriptTypeAlias) {
            return ((TypeScriptTypeAlias)referenced).getTypeDeclaration();
        }
        if (referenced instanceof TypeScriptInterface) {
            return ((TypeScriptInterface)referenced).getBody();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInline";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementUsages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/TypescriptTypeInliner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeUsageElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementTypeDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/TypescriptTypeInliner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doInlineUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doInlineUsage";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextWithAppliedGenerics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

