/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSNodeServicesProfilerActionKt;
import com.intellij.lang.javascript.service.MessageStreamLogger;
import com.intellij.lang.javascript.service.MessageStreamLoggerService;
import com.intellij.lang.typescript.lsp.LspServerActivationRule;
import com.intellij.lang.typescript.lsp.LspServerLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.platform.lsp.impl.connector.LspCommunicationLogger;
import com.intellij.platform.lsp.impl.connector.LspCommunicationLoggerProvider;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerInfo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\bH\u0014J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010'\u001a\u00020\bH\u0014J\u001a\u0010(\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010%\u0018\u00010)2\u0006\u0010'\u001a\u00020\bH\u0007J\u000e\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020%R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lcom/intellij/lang/typescript/lsp/JSLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "Lcom/intellij/platform/lsp/impl/connector/LspCommunicationLoggerProvider;", "project", "Lcom/intellij/openapi/project/Project;", "activationRule", "Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "presentableName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;Ljava/lang/String;)V", "getActivationRule", "()Lcom/intellij/lang/typescript/lsp/LspServerActivationRule;", "nodeTarget", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "getNodeTarget", "()Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "setNodeTarget", "(Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;)V", "value", "Lcom/intellij/util/text/SemVer;", "version", "getVersion", "()Lcom/intellij/util/text/SemVer;", "setVersion", "(Lcom/intellij/util/text/SemVer;)V", "messageStreamLogger", "Lcom/intellij/lang/javascript/service/MessageStreamLogger;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "createCommunicationLogger", "Lcom/intellij/platform/lsp/impl/connector/LspCommunicationLogger;", "getCommandLineArgsFromRegistry", "getFilePath", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findLocalFileByPath", "path", "findLocalFileByPathAsync", "Ljava/util/concurrent/CompletableFuture;", "isSupportedFile", "", "lspServerListener", "Lcom/intellij/platform/lsp/api/LspServerListener;", "getLspServerListener", "()Lcom/intellij/platform/lsp/api/LspServerListener;", "intellij.javascript.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nJSLspServerDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLspServerDescriptor.kt\ncom/intellij/lang/typescript/lsp/JSLspServerDescriptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,148:1\n11476#2,9:149\n13402#2:158\n13403#2:160\n11485#2:161\n1#3:159\n1#3:162\n40#4,3:163\n*S KotlinDebug\n*F\n+ 1 JSLspServerDescriptor.kt\ncom/intellij/lang/typescript/lsp/JSLspServerDescriptor\n*L\n68#1:149,9\n68#1:158\n68#1:160\n68#1:161\n68#1:159\n96#1:163,3\n*E\n"})
public abstract class JSLspServerDescriptor
extends ProjectWideLspServerDescriptor
implements LspCommunicationLoggerProvider {
    @NotNull
    private final LspServerActivationRule activationRule;
    @Nullable
    private NodeTargetRun nodeTarget;
    @Nullable
    private SemVer version;
    @Nullable
    private MessageStreamLogger messageStreamLogger;
    @NotNull
    private final LspServerListener lspServerListener;

    public JSLspServerDescriptor(@NotNull Project project, @NotNull LspServerActivationRule activationRule, @NotNull String presentableName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activationRule, (String)"activationRule");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        super(project, presentableName);
        this.activationRule = activationRule;
        this.lspServerListener = new LspServerListener(this){
            final /* synthetic */ JSLspServerDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public void serverInitialized(InitializeResult params) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    ServerInfo serverInfo = params.getServerInfo();
                    SemVer semVer = SemVer.parseFromText((String)(serverInfo != null ? serverInfo.getVersion() : null));
                    if (semVer == null) break block0;
                    SemVer semVer2 = semVer;
                    JSLspServerDescriptor jSLspServerDescriptor = this.this$0;
                    SemVer it = semVer2;
                    boolean bl = false;
                    jSLspServerDescriptor.setVersion(it);
                }
            }

            public void serverStopped(boolean shutdownNormally) {
                block1: {
                    MessageStreamLogger messageStreamLogger = JSLspServerDescriptor.access$getMessageStreamLogger$p(this.this$0);
                    if (messageStreamLogger == null) break block1;
                    MessageStreamLogger it = messageStreamLogger;
                    boolean bl = false;
                    boolean $i$f$service = false;
                    Class<MessageStreamLoggerService> serviceClass$iv = MessageStreamLoggerService.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    ((MessageStreamLoggerService)object).disconnect(it);
                }
            }
        };
    }

    @NotNull
    protected LspServerActivationRule getActivationRule() {
        return this.activationRule;
    }

    @Nullable
    protected final NodeTargetRun getNodeTarget() {
        return this.nodeTarget;
    }

    protected final void setNodeTarget(@Nullable NodeTargetRun nodeTargetRun) {
        this.nodeTarget = nodeTargetRun;
    }

    @Nullable
    public final SemVer getVersion() {
        return this.version;
    }

    protected final void setVersion(@Nullable SemVer semVer) {
        this.version = semVer;
    }

    @NotNull
    public final GeneralCommandLine createCommandLine() {
        throw new RuntimeException();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OSProcessHandler startServerProcess() {
        void $this$mapNotNullTo$iv$iv;
        NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(this.getProject()).getInterpreter();
        if (!(interpreter2 instanceof NodeJsLocalInterpreter) && !(interpreter2 instanceof WslNodeInterpreter)) {
            throw new ExecutionException(JavaScriptBundle.message("lsp.interpreter.error", new Object[0]));
        }
        LspServerLoader loader = this.getActivationRule().getLspServerLoader();
        NodePackageRef selectedPackageRef = loader.getSelectedPackageRef(this.getProject());
        NodePackage nodePackage = selectedPackageRef.getConstantPackage();
        if (nodePackage == null) {
            Object[] objectArray = new Object[]{this.getPresentableName()};
            throw new ExecutionException(JavaScriptBundle.message("lsp.executable.error", objectArray));
        }
        NodePackage nodePackage2 = nodePackage;
        String executablePath = loader.getAbsolutePath(this.getProject());
        if (executablePath == null) {
            Object[] objectArray = new Object[]{nodePackage2.getName()};
            throw new ExecutionException(JavaScriptBundle.message("lsp.executable.error", objectArray));
        }
        NodeTargetRun target2 = new NodeTargetRun(interpreter2, this.getProject(), null, NodeTargetRunOptions.Companion.of$default(NodeTargetRunOptions.Companion, false, null, null, 6, null), null, 16, null);
        TargetedCommandLineBuilder builder2 = target2.getCommandLineBuilder();
        VirtualFile[] $this$mapNotNull$iv = this.getRoots();
        boolean $i$f$mapNotNull = false;
        VirtualFile[] virtualFileArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            VirtualFile virtualFile = it.findChild("node_modules");
            if ((virtualFile != null ? virtualFile.getPath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable iterable = (List)destination$iv$iv;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        String nodePath = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        if (((CharSequence)nodePath).length() > 0) {
            builder2.addEnvironmentVariable("NODE_PATH", nodePath);
        }
        JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(builder2, this.getPresentableName(), this::getCommandLineArgsFromRegistry);
        String string2 = this.getProject().getBasePath();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            builder2.setWorkingDirectory(target2.path(it));
        }
        if (JSNodeServicesProfilerActionKt.isNodeServicesProfilerEnabled(this.getProject())) {
            builder2.addParameter("--prof");
        }
        builder2.addParameter(target2.path(executablePath));
        builder2.addParameter("--stdio");
        builder2.setCharset(Charsets.UTF_8);
        LspServerDescriptor.LOG.info("Starting " + ((Object)((Object)this)).getClass().getName() + " LSP server. Node.js version " + interpreter2.getCachedVersion() + ", path: " + interpreter2.getPresentableName());
        ProcessWithCmdLine process2 = (ProcessWithCmdLine)NodeProgressUtil.withInvisibleProgress(() -> JSLspServerDescriptor.startServerProcess$lambda$2(target2));
        this.nodeTarget = target2;
        if (this.version == null) {
            this.version = nodePackage2.getVersion();
        }
        return (OSProcessHandler)process2.getProcessHandler();
    }

    @Nullable
    public LspCommunicationLogger createCommunicationLogger() {
        MessageStreamLogger logger;
        if (!Registry.Companion.is("js.language.service.log.messages")) {
            return null;
        }
        boolean $i$f$service = false;
        Class<MessageStreamLoggerService> serviceClass$iv = MessageStreamLoggerService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        MessageStreamLogger messageStreamLogger = ((MessageStreamLoggerService)object).connect(this.getPresentableName());
        if (messageStreamLogger == null) {
            return null;
        }
        this.messageStreamLogger = logger = messageStreamLogger;
        return new LspCommunicationLogger(logger){
            final /* synthetic */ MessageStreamLogger $logger;
            {
                this.$logger = $logger;
            }

            public void logInbound(CharSequence message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$logger.logInbound(message);
            }

            public void logOutbound(CharSequence message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$logger.logOutbound(message);
            }
        };
    }

    @Nullable
    protected String getCommandLineArgsFromRegistry() {
        return null;
    }

    @NotNull
    public String getFilePath(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            Object object2;
            block5: {
                block4: {
                    object2 = this.nodeTarget;
                    if (object2 == null) break block4;
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if ((object2 = ((NodeTargetRun)object2).convertLocalPathToTargetPath(string)) != null) break block5;
                }
                object2 = super.getFilePath(file);
            }
            object = object2;
        }
        catch (IllegalArgumentException e) {
            LspServerDescriptor.LOG.error((Throwable)e);
            object = super.getFilePath(file);
        }
        return object;
    }

    @Nullable
    protected VirtualFile findLocalFileByPath(@NotNull String path2) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            NodeTargetRun nodeTargetRun = this.nodeTarget;
            Intrinsics.checkNotNull((Object)nodeTargetRun);
            virtualFile = super.findLocalFileByPath(nodeTargetRun.convertTargetPathToLocalPath(path2));
        }
        catch (IllegalArgumentException e) {
            LspServerDescriptor.LOG.error((Throwable)e);
            virtualFile = super.findLocalFileByPath(path2);
        }
        return virtualFile;
    }

    @ApiStatus.Internal
    @Nullable
    public final CompletableFuture<VirtualFile> findLocalFileByPathAsync(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Promise<String> promise = this.nodeTarget;
        if (promise == null || (promise = promise.convertTargetPathToLocal(path2)) == null) {
            return null;
        }
        Promise<String> localPath = promise;
        Promise promise2 = localPath.then(arg_0 -> JSLspServerDescriptor.findLocalFileByPathAsync$lambda$4(arg_0 -> JSLspServerDescriptor.findLocalFileByPathAsync$lambda$3(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return Promises.asCompletableFuture((Promise)promise2);
    }

    public final boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getActivationRule().isFileAcceptableForLspServer(file);
    }

    @NotNull
    public LspServerListener getLspServerListener() {
        return this.lspServerListener;
    }

    private static final ProcessWithCmdLine startServerProcess$lambda$2(NodeTargetRun $target) {
        return $target.startProcessEx();
    }

    private static final VirtualFile findLocalFileByPathAsync$lambda$3(JSLspServerDescriptor this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        return super.findLocalFileByPath(it);
    }

    private static final VirtualFile findLocalFileByPathAsync$lambda$4(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ MessageStreamLogger access$getMessageStreamLogger$p(JSLspServerDescriptor $this) {
        return $this.messageStreamLogger;
    }
}

