/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSStubSafeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtilKt;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0006H\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\"\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J:\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\t2\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil;", "", "<init>", "()V", "getAugmentations", "", "Lcom/intellij/psi/PsiElement;", "context", "modules", "", "getModuleAugmentations", "module", "resolveAugmentation", "", "augmentation", "isExternalModuleAugmentation", "", "candidate", "calculateAugmentationScope", "getModuleAugmentationsImpl", "", "scopeElement", "hasVirtualFile", "element", "processExportDeclarations", "", "names", "", "result", "", "visitedModules", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptAugmentationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptAugmentationUtil.kt\ncom/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil\n+ 2 JSStubSafeUtil.kt\ncom/intellij/lang/javascript/psi/util/JSStubSafeUtil\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n44#2,5:172\n808#3,11:177\n1611#3,9:188\n1863#3:197\n1864#3:199\n1620#3:200\n1863#3,2:201\n1755#3,3:204\n1#4:198\n1#4:203\n*S KotlinDebug\n*F\n+ 1 TypeScriptAugmentationUtil.kt\ncom/intellij/lang/typescript/resolve/TypeScriptAugmentationUtil\n*L\n67#1:172,5\n68#1:177,11\n69#1:188,9\n69#1:197\n69#1:199\n69#1:200\n72#1:201,2\n163#1:204,3\n69#1:198\n*E\n"})
public final class TypeScriptAugmentationUtil {
    @NotNull
    public static final TypeScriptAugmentationUtil INSTANCE = new TypeScriptAugmentationUtil();

    private TypeScriptAugmentationUtil() {
    }

    @JvmStatic
    @NotNull
    public static final List<PsiElement> getAugmentations(@NotNull PsiElement context2, @NotNull Collection<? extends PsiElement> modules) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        if (modules.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)modules)), arg_0 -> TypeScriptAugmentationUtil.getAugmentations$lambda$0(context2, arg_0))), (Function1)((Function1)new Function1<PsiElement, Boolean>((Object)INSTANCE){

            public final Boolean invoke(PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return TypeScriptAugmentationUtil.access$hasVirtualFile((TypeScriptAugmentationUtil)this.receiver, p0);
            }
        })));
    }

    @JvmStatic
    @NotNull
    public static final Collection<PsiElement> getModuleAugmentations(@NotNull PsiElement context2, @NotNull PsiElement module) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        PsiElement psiElement = TypeScriptAugmentationUtil.calculateAugmentationScope(context2);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement scopeElement = psiElement;
        Map value = (Map)CachedValuesManager.getCachedValue((PsiElement)scopeElement, (Key)TypeScriptAugmentationUtilKt.access$getKEY$p(), () -> TypeScriptAugmentationUtil.getModuleAugmentations$lambda$1(scopeElement));
        return value.getOrDefault(module, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Collection<PsiElement> resolveAugmentation(@NotNull PsiElement augmentation) {
        Set set;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)augmentation, (String)"augmentation");
        Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences(augmentation);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveModuleReferences(...)");
        Collection<PsiElement> augmentedModules = collection;
        if (!Registry.Companion.is("typescript.augmentation.deep.resolving.enabled")) {
            return augmentedModules;
        }
        PsiElement $this$stubSafeChildren$iv = augmentation;
        boolean $i$f$getStubSafeChildrenProperty = false;
        Object $this$getStubSafeChildren$iv$iv = $this$stubSafeChildren$iv;
        boolean $i$f$getStubSafeChildren = false;
        Iterable $this$filterIsInstance$iv = JSStubSafeUtil.getStubSafeChildren($this$getStubSafeChildren$iv$iv, Reflection.getOrCreateKotlinClass(PsiElement.class));
        boolean $i$f$filterIsInstance = false;
        $this$getStubSafeChildren$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JSNamedElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JSNamedElement p0 = (JSNamedElement)element$iv$iv;
            boolean bl2 = false;
            if (p0.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List augmentedNames = (List)destination$iv$iv;
        Set $this$resolveAugmentation_u24lambda_u243 = set = CollectionsKt.toMutableSet((Iterable)augmentedModules);
        boolean bl = false;
        Iterable $this$forEach$iv = augmentedModules;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement module = (PsiElement)element$iv;
            boolean bl4 = false;
            Collection collection2 = augmentedNames;
            Intrinsics.checkNotNull((Object)module);
            INSTANCE.processExportDeclarations(collection2, module, $this$resolveAugmentation_u24lambda_u243, new LinkedHashSet());
        }
        return set;
    }

    @JvmStatic
    public static final boolean isExternalModuleAugmentation(@NotNull PsiElement candidate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        if (!(candidate instanceof TypeScriptModule) || !TypeScriptPsiUtil.isAmbientModule((TypeScriptModule)candidate)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope(candidate);
        if (container instanceof JSFile) {
            bl = ((JSFile)container).isCommonJSModule();
        } else {
            if (container instanceof TypeScriptModule) {
                if (!TypeScriptPsiUtil.isAmbientModule((TypeScriptModule)container)) {
                    return false;
                }
                JSElement secondLevelParent = ES6PsiUtil.getExportScope((PsiElement)container);
                return secondLevelParent != null && !ES6PsiUtil.isExternalModule((PsiElement)secondLevelParent);
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement calculateAugmentationScope(@NotNull PsiElement context2) {
        PsiFile file;
        VirtualFile virtualFile;
        TypeScriptConfig typeScriptConfig;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiFile containingFile = context2.getContainingFile();
        TypeScriptConfig typeScriptConfig2 = JSTypeEvaluationLocationProvider.getTypeEvaluationConfig();
        if (typeScriptConfig2 == null) {
            typeScriptConfig2 = TypeScriptConfigUtil.getConfigForPsiFile(containingFile, true);
        }
        if ((typeScriptConfig = typeScriptConfig2) != null && (virtualFile = typeScriptConfig.getConfigFile()) != null) {
            Project project = context2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile, (Project)project);
            if (psiFile != null) {
                PsiFile $this$calculateAugmentationScope_u24lambda_u244 = psiFile;
                boolean bl = false;
                return (PsiElement)$this$calculateAugmentationScope_u24lambda_u244;
            }
        }
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)context2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (JSCorePredefinedLibrariesProvider.getReactPredefinedLibraryFiles().contains(virtualFile3)) {
            return null;
        }
        VirtualFile packageJson = TypeScriptUtil.getPackageJsonOutsideNodeModules(virtualFile3);
        if (packageJson != null && (file = context2.getManager().findFile(packageJson)) != null) {
            return (PsiElement)file;
        }
        return (PsiElement)containingFile;
    }

    private final Map<PsiElement, Collection<PsiElement>> getModuleAugmentationsImpl(PsiElement scopeElement) {
        MultiMap multiMap;
        Project project = scopeElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Collection<TypeScriptModule> augmentationModules = TypeScriptUtil.getAllAugmentationModules(project2, scopeElement);
        if (augmentationModules.isEmpty()) {
            return MapsKt.emptyMap();
        }
        MultiMap $this$getModuleAugmentationsImpl_u24lambda_u245 = multiMap = MultiMap.create();
        boolean bl = false;
        for (TypeScriptModule augmentation : augmentationModules) {
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNull((Object)augmentation);
            Collection<PsiElement> elements = TypeScriptAugmentationUtil.resolveAugmentation(augmentation);
            for (PsiElement resolvedModule : elements) {
                ProgressManager.checkCanceled();
                $this$getModuleAugmentationsImpl_u24lambda_u245.putValue((Object)resolvedModule, (Object)augmentation);
            }
        }
        Map map2 = multiMap.freezeValues();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"freezeValues(...)");
        return map2;
    }

    private final boolean hasVirtualFile(PsiElement element) {
        ProgressManager.checkCanceled();
        PsiFile file = element.getContainingFile();
        PsiFile psiFile = file.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile;
        return originalFile.getVirtualFile() != null;
    }

    private final void processExportDeclarations(Collection<String> names, PsiElement module, Set<PsiElement> result2, Set<PsiElement> visitedModules) {
        visitedModules.add(module);
        PsiElement[] psiElementArray = JSStubBasedPsiTreeUtil.getChildrenByType(module, ES6PsiUtil.DECLARATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildrenByType(...)");
        for (PsiElement declaration : psiElementArray) {
            Collection<PsiElement> resolvedModules;
            String referenceText;
            ES6FromClause fromClause;
            if (!(declaration instanceof ES6ExportDeclaration) || !((ES6ExportDeclaration)declaration).isExportAll() || ((ES6ExportDeclaration)declaration).getFromClause() == null || fromClause.getReferenceText() == null) continue;
            Intrinsics.checkNotNullExpressionValue(JSFileReferencesUtil.resolveModuleReferenceWithoutMerge(declaration, referenceText), (String)"resolveModuleReferenceWithoutMerge(...)");
            for (PsiElement resolvedModule : resolvedModules) {
                boolean bl;
                block6: {
                    if (visitedModules.contains(resolvedModule)) continue;
                    Iterable $this$any$iv = names;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String name = (String)element$iv;
                            boolean bl2 = false;
                            if (!(JSStubBasedPsiTreeUtil.resolveLocally(name, resolvedModule) != null)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    Intrinsics.checkNotNull((Object)resolvedModule);
                    result2.add(resolvedModule);
                }
                Intrinsics.checkNotNull((Object)resolvedModule);
                this.processExportDeclarations(names, resolvedModule, result2, visitedModules);
            }
        }
    }

    private static final Sequence getAugmentations$lambda$0(PsiElement $context, PsiElement module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CollectionsKt.asSequence((Iterable)TypeScriptAugmentationUtil.getModuleAugmentations($context, module));
    }

    private static final CachedValueProvider.Result getModuleAugmentations$lambda$1(PsiElement $scopeElement) {
        Map<PsiElement, Collection<PsiElement>> map2 = INSTANCE.getModuleAugmentationsImpl($scopeElement);
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootModificationTracker.getInstance((Project)$scopeElement.getProject())};
        return CachedValueProvider.Result.create(map2, (Object[])objectArray);
    }

    public static final /* synthetic */ boolean access$hasVirtualFile(TypeScriptAugmentationUtil $this, PsiElement element) {
        return $this.hasVirtualFile(element);
    }
}

