/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class AnonymousFunctionJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("anonymous.function.error.string", new Object[0]);
        if (string == null) {
            AnonymousFunctionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/AnonymousFunctionJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression jsFunctionExpression) {
            if (jsFunctionExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionExpression(jsFunctionExpression);
            if (jsFunctionExpression.getOwnNameIdentifier() != null) {
                return;
            }
            PsiElement identifier = jsFunctionExpression.getNameIdentifier();
            if (identifier != null && !(identifier.getParent() instanceof JSReferenceExpression)) {
                return;
            }
            ASTNode arrowNode = JSPsiImplUtils.getFunctionArrowNode(jsFunctionExpression);
            this.registerError(arrowNode != null ? arrowNode.getPsi() : PsiTreeUtil.getChildOfType((PsiElement)jsFunctionExpression, LeafPsiElement.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFunctionExpression", "com/sixrr/inspectjs/confusing/AnonymousFunctionJSInspection$Visitor", "visitJSFunctionExpression"));
        }
    }
}

