/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MagicNumberJSInspection
extends JavaScriptInspection {
    private static final Set<String> s_specialCaseLiterals = Set.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "100", "1000", "0L", "1L", "2L", "0l", "1l", "2l", "0.0", "1.0", "0.0F", "1.0F", "0.0f", "1.0f");

    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("magic.number.problem.descriptor", new Object[0]);
        if (string == null) {
            MagicNumberJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    static boolean isSpecialCaseLiteral(@NotNull String text) {
        if (text == null) {
            MagicNumberJSInspection.$$$reportNull$$$0(1);
        }
        return s_specialCaseLiterals.contains(text);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MagicNumberVisitor();
    }

    private static boolean isNumeric(String text) {
        if (text.isEmpty()) {
            return false;
        }
        char firstChar = text.charAt(0);
        return Character.isDigit(firstChar) || firstChar == '.';
    }

    private static boolean isDeclaredConstant(JSLiteralExpression expression) {
        JSVariable[] variables;
        JSVarStatement varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSVarStatement.class);
        if (varStatement == null) {
            return false;
        }
        if (varStatement.getVarKeyword() == JSVarStatement.VarKeyword.CONST) {
            return true;
        }
        for (JSVariable variable : variables = varStatement.getVariables()) {
            if (!expression.equals(variable.getInitializer()) && (!(expression.getParent() instanceof JSPrefixExpression) || !expression.getParent().equals(variable.getInitializer()))) continue;
            JSFunction containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
            if (containingFunction != null) {
                PsiElement parent = JSResolveUtil.findParent(containingFunction);
                if (parent instanceof JSClass) {
                    return false;
                }
                if (containingFunction instanceof JSFunctionExpression && !(parent instanceof JSParenthesizedExpression)) {
                    PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)variable);
                    return docComment instanceof JSDocComment && ((JSDocComment)docComment).hasConstTag();
                }
                if (!(containingFunction instanceof JSFunctionExpression || parent instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof JSEmbeddedContent)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/confusing/MagicNumberJSInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/confusing/MagicNumberJSInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialCaseLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class MagicNumberVisitor
    extends BaseInspectionVisitor {
        private MagicNumberVisitor() {
        }

        @Override
        public void visitJSLiteralExpression(@NotNull JSLiteralExpression expression) {
            if (expression == null) {
                MagicNumberVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSLiteralExpression(expression);
            String text = expression.getText();
            if (text == null) {
                return;
            }
            if (!MagicNumberJSInspection.isNumeric(text)) {
                return;
            }
            if (MagicNumberJSInspection.isSpecialCaseLiteral(text)) {
                return;
            }
            if (MagicNumberJSInspection.isDeclaredConstant(expression)) {
                return;
            }
            if (MagicNumberVisitor.isPropertyValue(expression)) {
                return;
            }
            if (MagicNumberVisitor.radix16Argument(expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof JSPrefixExpression) {
                this.registerError(parent);
            } else {
                this.registerError((PsiElement)expression);
            }
        }

        private static boolean radix16Argument(JSLiteralExpression expression) {
            JSExpression jSExpression;
            PsiElement parent;
            if (!"16".equals(expression.getText().trim())) {
                return false;
            }
            JSLiteralExpression currentExpression = expression;
            while (currentExpression instanceof JSExpression) {
                currentExpression = currentExpression.getParent();
            }
            if (currentExpression instanceof JSArgumentList && (parent = currentExpression.getParent()) instanceof JSCallExpression && (jSExpression = ((JSCallExpression)parent).getMethodExpression()) instanceof JSReferenceExpression) {
                JSReferenceExpression methodExpression = (JSReferenceExpression)jSExpression;
                if (methodExpression.getQualifier() == null && "parseInt".equals(methodExpression.getReferenceName())) {
                    return true;
                }
                if (methodExpression.getQualifier() != null && "toString".equals(methodExpression.getReferenceName())) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isPropertyValue(JSLiteralExpression expression) {
            return expression.getParent() instanceof JSProperty;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/confusing/MagicNumberJSInspection$MagicNumberVisitor", "visitJSLiteralExpression"));
        }
    }
}

