/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.lsp.LspServerLoader;
import com.intellij.lang.typescript.lsp.LspServerPackageDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.typescript.service.VueLspServerPackageDescriptor;
import org.jetbrains.vuejs.options.VueSettings;
import org.jetbrains.vuejs.options.VueSettingsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VueLspServerLoader;", "Lcom/intellij/lang/typescript/lsp/LspServerLoader;", "<init>", "()V", "getSelectedPackageRef", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "project", "Lcom/intellij/openapi/project/Project;", "getAbsolutePathForDefaultKey", "", "getNewEvalPath", "intellij.vuejs"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nVueServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueServices.kt\norg/jetbrains/vuejs/lang/typescript/service/VueLspServerLoader\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,116:1\n31#2,2:117\n*S KotlinDebug\n*F\n+ 1 VueServices.kt\norg/jetbrains/vuejs/lang/typescript/service/VueLspServerLoader\n*L\n46#1:117,2\n*E\n"})
public final class VueLspServerLoader
extends LspServerLoader {
    @NotNull
    public static final VueLspServerLoader INSTANCE = new VueLspServerLoader();

    private VueLspServerLoader() {
        super((LspServerPackageDescriptor)VueLspServerPackageDescriptor.INSTANCE);
    }

    @NotNull
    public NodePackageRef getSelectedPackageRef(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return VueSettingsKt.getVueSettings(project).getPackageRef();
    }

    @Nullable
    protected String getAbsolutePathForDefaultKey(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<VueSettings> serviceClass$iv = VueSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (((VueSettings)((Object)object)).getUseTypesFromServer()) {
            return this.getNewEvalPath();
        }
        return super.getAbsolutePathForDefaultKey(project);
    }

    private final String getNewEvalPath() {
        String registryValue = Registry.Companion.stringValue("vue.language.server.default.version");
        String version = StringsKt.startsWith$default((String)registryValue, (String)"1", (boolean)false, (int)2, null) ? "tsc-vue1" : "tsc-vue";
        File file = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "typescript/node_modules/" + version + "/" + this.getPackageDescriptor().getDefaultPackageRelativePath());
        String path = file.getAbsolutePath();
        Intrinsics.checkNotNull((Object)path);
        return path;
    }
}

