/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabStub;
import com.jetbrains.plugins.webDeployment.ui.config.ExcludedPathsConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroupedDeployable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedPathsConfigurableTabProvider
implements DeploymentConfigurableTabProvider {
    private static final Key<Map<String, List<ExcludedPath>>> EXCLUDED_PATHS = Key.create((String)"excluded.paths.from.mappings.key");

    @Override
    public DeploymentConfigurableTab createTab(@Nullable Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(0);
        }
        if (project != null && !project.isDefault()) {
            return new ExcludedPathsConfigurableTab(project, serverStateProvider, sharedData);
        }
        return new DeploymentConfigurableTabStub(ExcludedPathsConfigurableTab.getText(), 2, WDBundle.message("excluded.paths.tab.stub.text", new Object[0]));
    }

    @Override
    public boolean dataIsEqual(Project project, SettingsDeployable o1, SettingsDeployable o2, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(1);
        }
        if (project == null || project.isDefault()) {
            return true;
        }
        List<ExcludedPath> ex1 = ExcludedPathsConfigurableTabProvider.getExcludedPaths(sharedData, o1.getId());
        List<ExcludedPath> ex2 = ExcludedPathsConfigurableTabProvider.getExcludedPaths(sharedData, o2.getId());
        return Comparing.equal(ex1, ex2);
    }

    @Override
    public void reset(Project project, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(2);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        HashMap<String, List<ExcludedPath>> excludedPaths = new HashMap<String, List<ExcludedPath>>();
        for (WebServerConfig server : GroupedServersConfigManager.getInstance(project).getFlattenedServers()) {
            excludedPaths.put(server.getId(), publishConfig.getExcludedPaths(server.getId()));
        }
        ExcludedPathsConfigurableTabProvider.setExcludedPaths(excludedPaths, sharedData);
    }

    @Override
    public void apply(Project project, List<SettingsGroupedDeployable> currentGroups, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(3);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig config = PublishConfig.getInstance(project);
        Map<String, List<ExcludedPath>> paths = ExcludedPathsConfigurableTabProvider.getExcludedPaths(sharedData);
        config.setExcludedPaths(DeploymentConfigurable.filterExistingServers(paths, currentGroups));
    }

    @Override
    public void onItemCreated(Project project, SettingsDeployable newItem, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void onItemDeleted(Project project, SettingsDeployable item, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(5);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        ExcludedPathsConfigurableTabProvider.removeExcludedPaths(sharedData, item.getId());
    }

    @NotNull
    private static Map<String, List<ExcludedPath>> getExcludedPaths(@NotNull UserDataHolder sharedData) {
        Map data;
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(6);
        }
        if ((data = (Map)sharedData.getUserData(EXCLUDED_PATHS)) == null) {
            ExcludedPathsConfigurableTabProvider.setExcludedPaths(new HashMap<String, List<ExcludedPath>>(), sharedData);
            return ExcludedPathsConfigurableTabProvider.getExcludedPaths(sharedData);
        }
        Map map = data;
        if (map == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(7);
        }
        return map;
    }

    @Nullable
    static List<ExcludedPath> getExcludedPaths(@NotNull UserDataHolder sharedData, String serverId) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(8);
        }
        return ExcludedPathsConfigurableTabProvider.getExcludedPaths(sharedData).get(serverId);
    }

    static void removeExcludedPaths(@NotNull UserDataHolder sharedData, String serverId) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(9);
        }
        ExcludedPathsConfigurableTabProvider.getExcludedPaths(sharedData).remove(serverId);
    }

    static void putExcludedPaths(String serverId, List<ExcludedPath> excludedPaths, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(10);
        }
        ExcludedPathsConfigurableTabProvider.getExcludedPaths(sharedData).put(serverId, excludedPaths);
    }

    private static void setExcludedPaths(Map<String, List<ExcludedPath>> excludedPaths, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            ExcludedPathsConfigurableTabProvider.$$$reportNull$$$0(11);
        }
        sharedData.putUserData(EXCLUDED_PATHS, excludedPaths);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTab";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dataIsEqual";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onItemCreated";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onItemDeleted";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedPaths";
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putExcludedPaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setExcludedPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

