/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CodeProcessorCheckinHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/checkin/RearrangeBeforeCheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CodeProcessorCheckinHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "isEnabled", "", "getProgressMessage", "", "createCodeProcessor", "Lcom/intellij/codeInsight/actions/AbstractLayoutCodeProcessor;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.vcs.impl.lang"})
@ApiStatus.Internal
public final class RearrangeBeforeCheckinHandler
extends CodeProcessorCheckinHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NlsSafe
    @NotNull
    public static final String COMMAND_NAME;

    public RearrangeBeforeCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        Project project = this.getProject();
        CheckinHandler checkinHandler = this;
        String string = VcsBundle.message((String)"checkbox.checkin.options.rearrange.code", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return BooleanCommitOption.Companion.create(project, checkinHandler, true, string, (KMutableProperty0)new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((VcsConfiguration)this.receiver).REARRANGE_BEFORE_PROJECT_COMMIT;
            }

            public void set(Object value) {
                ((VcsConfiguration)this.receiver).REARRANGE_BEFORE_PROJECT_COMMIT = (Boolean)value;
            }
        });
    }

    public boolean isEnabled() {
        return this.getSettings().REARRANGE_BEFORE_PROJECT_COMMIT;
    }

    @Override
    @NotNull
    protected String getProgressMessage() {
        String string = VcsBundle.message((String)"progress.text.rearranging.code", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected AbstractLayoutCodeProcessor createCodeProcessor(@NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return (AbstractLayoutCodeProcessor)new RearrangeCodeProcessor(this.getProject(), CheckinHandlerUtil.getPsiFiles((Project)this.getProject(), (Collection)files), COMMAND_NAME, null, true);
    }

    static {
        String string = CodeInsightBundle.message((String)"process.rearrange.code.before.commit", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        COMMAND_NAME = string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/checkin/RearrangeBeforeCheckinHandler$Companion;", "", "<init>", "()V", "COMMAND_NAME", "", "intellij.platform.vcs.impl.lang"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

