/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.editor.CssCommenter;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.tree.IElementType;
import org.intellij.plugins.postcss.PostCssLanguage;
import org.intellij.plugins.postcss.lexer.PostCssTokenTypes;
import org.intellij.plugins.postcss.settings.PostCssCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostCssCommentProvider
implements MultipleLangCommentProvider {
    private static final Commenter CSS_COMMENTER = new CssCommenter();
    private static final Commenter POST_CSS_COMMENTER = new CssCommenter(){

        public String getLineCommentPrefix() {
            return "//";
        }

        public IElementType getLineCommentTokenType() {
            return PostCssTokenTypes.POST_CSS_COMMENT;
        }
    };

    @Nullable
    public Commenter getLineCommenter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Language lineStartLanguage, @NotNull Language lineEndLanguage) {
        if (file == null) {
            PostCssCommentProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PostCssCommentProvider.$$$reportNull$$$0(1);
        }
        if (lineStartLanguage == null) {
            PostCssCommentProvider.$$$reportNull$$$0(2);
        }
        if (lineEndLanguage == null) {
            PostCssCommentProvider.$$$reportNull$$$0(3);
        }
        if (((PostCssCodeStyleSettings)CodeStyle.getSettings((PsiFile)file).getCustomSettings(PostCssCodeStyleSettings.class)).COMMENTS_INLINE_STYLE) {
            return POST_CSS_COMMENTER;
        }
        return CSS_COMMENTER;
    }

    public boolean canProcess(@NotNull PsiFile file, @NotNull FileViewProvider viewProvider) {
        if (file == null) {
            PostCssCommentProvider.$$$reportNull$$$0(4);
        }
        if (viewProvider == null) {
            PostCssCommentProvider.$$$reportNull$$$0(5);
        }
        return file.getLanguage() == PostCssLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStartLanguage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineEndLanguage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/postcss/PostCssCommentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommenter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

