/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.LinkAnnotation;
import androidx.compose.ui.text.ParagraphStyle;
import androidx.compose.ui.text.SaversKt;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TtsAnnotation;
import androidx.compose.ui.text.UrlAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 :2\u00020\u0001:\u00039:;B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nBY\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005\u0012\u0018\b\u0002\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u0096\u0002J\"\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\"\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J*\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010'\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\"\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J$\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00060\u00052\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013H\u0007J\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000J\u0016\u0010-\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\u001e\u0010.\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013J\b\u0010/\u001a\u00020\u0013H\u0016J\u0011\u00100\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0087\u0002J\u0018\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u000203\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105J\u0018\u00101\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013H\u0016J\b\u00108\u001a\u00020\u0003H\u0016R$\u0010\r\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\"\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\"\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006<"}, d2={"Landroidx/compose/ui/text/AnnotatedString;", "", "text", "", "spanStyles", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/SpanStyle;", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "spanStylesOrNull", "paragraphStylesOrNull", "annotations", "", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAnnotations$ui_text", "()Ljava/util/List;", "length", "", "getLength", "()I", "getParagraphStyles", "getParagraphStylesOrNull$ui_text", "getSpanStyles", "getSpanStylesOrNull$ui_text", "getText", "()Ljava/lang/String;", "equals", "", "other", "get", "", "index", "getLinkAnnotations", "Landroidx/compose/ui/text/LinkAnnotation;", "start", "end", "getStringAnnotations", "tag", "getTtsAnnotations", "Landroidx/compose/ui/text/TtsAnnotation;", "getUrlAnnotations", "Landroidx/compose/ui/text/UrlAnnotation;", "hasEqualAnnotations", "hasLinkAnnotations", "hasStringAnnotations", "hashCode", "plus", "subSequence", "range", "Landroidx/compose/ui/text/TextRange;", "subSequence-5zc-tL8", "(J)Landroidx/compose/ui/text/AnnotatedString;", "startIndex", "endIndex", "toString", "Builder", "Companion", "Range", "ui-text"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1270:1\n1045#2:1271\n33#3,6:1272\n235#3,3:1279\n33#3,4:1282\n238#3,2:1286\n38#3:1288\n240#3:1289\n101#3,2:1290\n33#3,6:1292\n103#3:1298\n235#3,3:1299\n33#3,4:1302\n238#3,2:1306\n38#3:1308\n240#3:1309\n235#3,3:1310\n33#3,4:1313\n238#3,2:1317\n38#3:1319\n240#3:1320\n235#3,3:1321\n33#3,4:1324\n238#3,2:1328\n38#3:1330\n240#3:1331\n235#3,3:1332\n33#3,4:1335\n238#3,2:1339\n38#3:1341\n240#3:1342\n101#3,2:1343\n33#3,6:1345\n103#3:1351\n1#4:1278\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString\n*L\n88#1:1271\n88#1:1272,6\n161#1:1279,3\n161#1:1282,4\n161#1:1286,2\n161#1:1288\n161#1:1289\n169#1:1290,2\n169#1:1292,6\n169#1:1298\n184#1:1299,3\n184#1:1302,4\n184#1:1306,2\n184#1:1308\n184#1:1309\n199#1:1310,3\n199#1:1313,4\n199#1:1317,2\n199#1:1319\n199#1:1320\n216#1:1321,3\n216#1:1324,4\n216#1:1328,2\n216#1:1330\n216#1:1331\n231#1:1332,3\n231#1:1335,4\n231#1:1339,2\n231#1:1341\n231#1:1342\n239#1:1343,2\n239#1:1345,6\n239#1:1351\n*E\n"})
public final class AnnotatedString
implements CharSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @Nullable
    private final List<Range<SpanStyle>> spanStylesOrNull;
    @Nullable
    private final List<Range<ParagraphStyle>> paragraphStylesOrNull;
    @Nullable
    private final List<Range<? extends Object>> annotations;
    public static final int $stable;
    @NotNull
    private static final Saver<AnnotatedString, ?> Saver;

    public AnnotatedString(@NotNull String text, @Nullable List<Range<SpanStyle>> spanStylesOrNull, @Nullable List<Range<ParagraphStyle>> paragraphStylesOrNull, @Nullable List<? extends Range<? extends Object>> annotations) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.spanStylesOrNull = spanStylesOrNull;
            this.paragraphStylesOrNull = paragraphStylesOrNull;
            this.annotations = annotations;
            int lastStyleEnd = 0;
            lastStyleEnd = -1;
            List list2 = this.paragraphStylesOrNull;
            if (list2 == null) break block4;
            Iterable $this$sortedBy$iv = list2;
            boolean $i$f$sortedBy = false;
            list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Range it = (Range)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStart());
                    it = (Range)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                }
            });
            if (list2 != null) {
                List $this$fastForEach$iv = list2;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    Object item$iv = $this$fastForEach$iv.get(index$iv);
                    Range paragraphStyle = (Range)item$iv;
                    boolean bl = false;
                    if (!(paragraphStyle.getStart() >= lastStyleEnd)) {
                        boolean $i$a$-require-AnnotatedString$4$32 = false;
                        String $i$a$-require-AnnotatedString$4$32 = "ParagraphStyle should not overlap";
                        throw new IllegalArgumentException($i$a$-require-AnnotatedString$4$32.toString());
                    }
                    if (!(paragraphStyle.getEnd() <= this.text.length())) {
                        boolean bl2 = false;
                        String string = "ParagraphStyle range [" + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ") is out of boundary";
                        throw new IllegalArgumentException(string.toString());
                    }
                    lastStyleEnd = paragraphStyle.getEnd();
                }
            }
        }
    }

    public /* synthetic */ AnnotatedString(String string, List list2, List list3, List list4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = null;
        }
        if ((n & 4) != 0) {
            list3 = null;
        }
        if ((n & 8) != 0) {
            list4 = null;
        }
        this(string, list2, list3, list4);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final List<Range<SpanStyle>> getSpanStylesOrNull$ui_text() {
        return this.spanStylesOrNull;
    }

    @Nullable
    public final List<Range<ParagraphStyle>> getParagraphStylesOrNull$ui_text() {
        return this.paragraphStylesOrNull;
    }

    @Nullable
    public final List<Range<? extends Object>> getAnnotations$ui_text() {
        return this.annotations;
    }

    @NotNull
    public final List<Range<SpanStyle>> getSpanStyles() {
        List list2 = this.spanStylesOrNull;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final List<Range<ParagraphStyle>> getParagraphStyles() {
        List list2 = this.paragraphStylesOrNull;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public AnnotatedString(@NotNull String text, @NotNull List<Range<SpanStyle>> spanStyles, @NotNull List<Range<ParagraphStyle>> paragraphStyles) {
        Collection collection;
        Collection collection2;
        List list2;
        AnnotatedString annotatedString;
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(spanStyles, (String)"spanStyles");
        Intrinsics.checkNotNullParameter(paragraphStyles, (String)"paragraphStyles");
        AnnotatedString annotatedString2 = this;
        String string2 = text;
        Collection collection3 = spanStyles;
        if (collection3.isEmpty()) {
            string = string2;
            annotatedString = annotatedString2;
            boolean bl = false;
            list2 = null;
            annotatedString2 = annotatedString;
            string2 = string;
            collection2 = list2;
        } else {
            collection2 = collection3;
        }
        List list3 = (List)collection2;
        collection3 = paragraphStyles;
        if (collection3.isEmpty()) {
            list2 = list3;
            string = string2;
            annotatedString = annotatedString2;
            boolean bl = false;
            Object var9_9 = null;
            annotatedString2 = annotatedString;
            string2 = string;
            list3 = list2;
            collection = var9_9;
        } else {
            collection = collection3;
        }
        annotatedString2(string2, list3, (List)collection, null);
    }

    public /* synthetic */ AnnotatedString(String string, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(string, list2, list3);
    }

    public int getLength() {
        return this.text.length();
    }

    public char get(int index2) {
        return this.text.charAt(index2);
    }

    @Override
    @NotNull
    public AnnotatedString subSequence(int startIndex, int endIndex) {
        if (!(startIndex <= endIndex)) {
            boolean bl = false;
            String string = "start (" + startIndex + ") should be less or equal to end (" + endIndex + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (startIndex == 0 && endIndex == this.text.length()) {
            return this;
        }
        String string = this.text.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String text = string;
        return new AnnotatedString(text, AnnotatedStringKt.access$filterRanges(this.spanStylesOrNull, startIndex, endIndex), AnnotatedStringKt.access$filterRanges(this.paragraphStylesOrNull, startIndex, endIndex), AnnotatedStringKt.access$filterRanges(this.annotations, startIndex, endIndex));
    }

    @NotNull
    public final AnnotatedString subSequence-5zc-tL8(long range) {
        return this.subSequence(TextRange.getMin-impl(range), TextRange.getMax-impl(range));
    }

    @Stable
    @NotNull
    public final AnnotatedString plus(@NotNull AnnotatedString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Builder $this$plus_u24lambda_u247 = new Builder(this);
        boolean bl = false;
        $this$plus_u24lambda_u247.append(other);
        return $this$plus_u24lambda_u247.toAnnotatedString();
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(@NotNull String tag, int start, int end2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof String && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list2;
    }

    public final boolean hasStringAnnotations(@NotNull String tag, int start, int end2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            List<Range<? extends Object>> list2 = this.annotations;
            if (list2 != null) {
                List<Range<? extends Object>> $this$fastAny$iv = list2;
                boolean $i$f$fastAny = false;
                List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Object> item$iv$iv;
                    Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Object> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof String && Intrinsics.areEqual((Object)tag, (Object)it.getTag()) && AnnotatedStringKt.intersect(start, end2, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<Range<String>> getStringAnnotations(int start, int end2) {
        List list2;
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof String && AnnotatedStringKt.intersect(start, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<kotlin.String>>");
        return list2;
    }

    @NotNull
    public final List<Range<TtsAnnotation>> getTtsAnnotations(int start, int end2) {
        List list2;
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof TtsAnnotation && AnnotatedStringKt.intersect(start, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.TtsAnnotation>>");
        return list2;
    }

    @Deprecated(message="Use LinkAnnotation API instead", replaceWith=@ReplaceWith(expression="getLinkAnnotations(start, end)", imports={}))
    @ExperimentalTextApi
    @NotNull
    public final List<Range<UrlAnnotation>> getUrlAnnotations(int start, int end2) {
        List list2;
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof UrlAnnotation && AnnotatedStringKt.intersect(start, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.UrlAnnotation>>");
        return list2;
    }

    @NotNull
    public final List<Range<LinkAnnotation>> getLinkAnnotations(int start, int end2) {
        List list2;
        List<Range<? extends Object>> list3 = this.annotations;
        if (list3 != null) {
            List<Range<? extends Object>> $this$fastFilter$iv = list3;
            boolean $i$f$fastFilter = false;
            ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
            List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastFilter$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Range<? extends Object> item$iv$iv;
                Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                Range<? extends Object> it = it$iv;
                boolean bl2 = false;
                if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end2, it.getStart(), it.getEnd()))) continue;
                ((Collection)target$iv).add(it$iv);
            }
            list2 = target$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<androidx.compose.ui.text.AnnotatedString.Range<androidx.compose.ui.text.LinkAnnotation>>");
        return list2;
    }

    public final boolean hasLinkAnnotations(int start, int end2) {
        boolean bl;
        block3: {
            List<Range<? extends Object>> list2 = this.annotations;
            if (list2 != null) {
                List<Range<? extends Object>> $this$fastAny$iv = list2;
                boolean $i$f$fastAny = false;
                List<Range<? extends Object>> $this$fastForEach$iv$iv = $this$fastAny$iv;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv$iv.size();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    Range<? extends Object> item$iv$iv;
                    Range<? extends Object> it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                    boolean bl2 = false;
                    Range<? extends Object> it = it$iv;
                    boolean bl3 = false;
                    if (!(it.getItem() instanceof LinkAnnotation && AnnotatedStringKt.intersect(start, end2, it.getStart(), it.getEnd()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((AnnotatedString)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.spanStylesOrNull, ((AnnotatedString)other).spanStylesOrNull)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paragraphStylesOrNull, ((AnnotatedString)other).paragraphStylesOrNull)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, ((AnnotatedString)other).annotations);
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        List<Range<SpanStyle>> list2 = this.spanStylesOrNull;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        List<Range<ParagraphStyle>> list3 = this.paragraphStylesOrNull;
        result2 = 31 * result2 + (list3 != null ? ((Object)list3).hashCode() : 0);
        List<Range<? extends Object>> list4 = this.annotations;
        result2 = 31 * result2 + (list4 != null ? ((Object)list4).hashCode() : 0);
        return result2;
    }

    @Override
    @NotNull
    public String toString() {
        return this.text;
    }

    public final boolean hasEqualAnnotations(@NotNull AnnotatedString other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual(this.annotations, other.annotations);
    }

    static {
        Saver = SaversKt.getAnnotatedStringSaver();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0001;B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ&\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ \u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J \u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0007J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0006J\u001e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tJ\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.H\u0016J\u0012\u0010,\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010/H\u0016J\"\u0010,\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010/2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u0004J\u0015\u00100\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0007\u00a2\u0006\u0002\b,J\u0006\u00101\u001a\u00020\u001aJ\u000e\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\tJ\u000e\u00103\u001a\u00020\t2\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u00107\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0013J\u000e\u00107\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0015J\u000e\u00108\u001a\u00020\t2\u0006\u0010'\u001a\u00020(J\u0010\u00109\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0007J\u0006\u0010:\u001a\u00020\u0006R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0017j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "text", "", "(Ljava/lang/String;)V", "Landroidx/compose/ui/text/AnnotatedString;", "(Landroidx/compose/ui/text/AnnotatedString;)V", "capacity", "", "(I)V", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "", "length", "getLength", "()I", "paragraphStyles", "Landroidx/compose/ui/text/ParagraphStyle;", "spanStyles", "Landroidx/compose/ui/text/SpanStyle;", "styleStack", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addLink", "", "clickable", "Landroidx/compose/ui/text/LinkAnnotation$Clickable;", "start", "end", "url", "Landroidx/compose/ui/text/LinkAnnotation$Url;", "addStringAnnotation", "tag", "annotation", "addStyle", "style", "addTtsAnnotation", "ttsAnnotation", "Landroidx/compose/ui/text/TtsAnnotation;", "addUrlAnnotation", "urlAnnotation", "Landroidx/compose/ui/text/UrlAnnotation;", "append", "char", "", "", "deprecated_append_returning_void", "pop", "index", "pushLink", "link", "Landroidx/compose/ui/text/LinkAnnotation;", "pushStringAnnotation", "pushStyle", "pushTtsAnnotation", "pushUrlAnnotation", "toAnnotatedString", "MutableRange", "ui-text"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1270:1\n33#2,6:1271\n33#2,6:1277\n33#2,6:1283\n33#2,6:1289\n33#2,6:1295\n33#2,6:1301\n151#2,3:1308\n33#2,4:1311\n154#2,2:1315\n38#2:1317\n156#2:1318\n151#2,3:1319\n33#2,4:1322\n154#2,2:1326\n38#2:1328\n156#2:1329\n151#2,3:1330\n33#2,4:1333\n154#2,2:1337\n38#2:1339\n156#2:1340\n1#3:1307\n*S KotlinDebug\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder\n*L\n436#1:1271,6\n439#1:1277,6\n443#1:1283,6\n463#1:1289,6\n466#1:1295,6\n470#1:1301,6\n742#1:1308,3\n742#1:1311,4\n742#1:1315,2\n742#1:1317\n742#1:1318\n745#1:1319,3\n745#1:1322,4\n745#1:1326,2\n745#1:1328\n745#1:1329\n748#1:1330,3\n748#1:1333,4\n748#1:1337,2\n748#1:1339\n748#1:1340\n*E\n"})
    public static final class Builder
    implements Appendable {
        @NotNull
        private final StringBuilder text;
        @NotNull
        private final List<MutableRange<SpanStyle>> spanStyles;
        @NotNull
        private final List<MutableRange<ParagraphStyle>> paragraphStyles;
        @NotNull
        private final List<MutableRange<? extends Object>> annotations;
        @NotNull
        private final List<MutableRange<? extends Object>> styleStack;
        public static final int $stable = 8;

        public Builder(int capacity) {
            this.text = new StringBuilder(capacity);
            this.spanStyles = new ArrayList();
            this.paragraphStyles = new ArrayList();
            this.annotations = new ArrayList();
            this.styleStack = new ArrayList();
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        public Builder(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public Builder(@NotNull AnnotatedString text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public final int getLength() {
            return this.text.length();
        }

        public final void append(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text.append(text);
        }

        @Deprecated(message="Replaced by the append(Char) method that returns an Appendable. This method must be kept around for binary compatibility.", level=DeprecationLevel.HIDDEN)
        @JvmName(name="append")
        public final /* synthetic */ void append(char c) {
            this.append(c);
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text);
            } else {
                this.text.append(text);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(@Nullable CharSequence text, int start, int end2) {
            if (text instanceof AnnotatedString) {
                this.append((AnnotatedString)text, start, end2);
            } else {
                this.text.append(text, start, end2);
            }
            return this;
        }

        @Override
        @NotNull
        public Builder append(char c) {
            this.text.append(c);
            return this;
        }

        public final void append(@NotNull AnnotatedString text) {
            block5: {
                Range<Object> it;
                Range<Object> item$iv;
                int index$iv;
                int n;
                boolean $i$f$fastForEach;
                List<Range<Object>> $this$fastForEach$iv;
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                int start = this.text.length();
                this.text.append(text.getText());
                List<Range<SpanStyle>> list2 = text.getSpanStylesOrNull$ui_text();
                if (list2 != null) {
                    $this$fastForEach$iv = list2;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl = false;
                        this.addStyle((SpanStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
                    }
                }
                List<Range<ParagraphStyle>> list3 = text.getParagraphStylesOrNull$ui_text();
                if (list3 != null) {
                    $this$fastForEach$iv = list3;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl = false;
                        this.addStyle((ParagraphStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
                    }
                }
                List<Range<? extends Object>> list4 = text.getAnnotations$ui_text();
                if (list4 == null) break block5;
                $this$fastForEach$iv = list4;
                $i$f$fastForEach = false;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    it = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl = false;
                    this.annotations.add(new MutableRange<Object>(it.getItem(), start + it.getStart(), start + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void append(@NotNull AnnotatedString text, int start, int end2) {
            block5: {
                Range it;
                Object item$iv;
                int index$iv;
                int n;
                boolean $i$f$fastForEach;
                List $this$fastForEach$iv;
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                int insertionStart = this.text.length();
                this.text.append(text.getText(), start, end2);
                List list2 = AnnotatedStringKt.access$getLocalSpanStyles(text, start, end2);
                if (list2 != null) {
                    $this$fastForEach$iv = list2;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        item$iv = $this$fastForEach$iv.get(index$iv);
                        it = (Range)item$iv;
                        boolean bl = false;
                        this.addStyle((SpanStyle)it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd());
                    }
                }
                List list3 = AnnotatedStringKt.access$getLocalParagraphStyles(text, start, end2);
                if (list3 != null) {
                    $this$fastForEach$iv = list3;
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        item$iv = $this$fastForEach$iv.get(index$iv);
                        it = (Range)item$iv;
                        boolean bl = false;
                        this.addStyle((ParagraphStyle)it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd());
                    }
                }
                List list4 = AnnotatedStringKt.access$getLocalAnnotations(text, start, end2);
                if (list4 == null) break block5;
                $this$fastForEach$iv = list4;
                $i$f$fastForEach = false;
                n = $this$fastForEach$iv.size();
                for (index$iv = 0; index$iv < n; ++index$iv) {
                    item$iv = $this$fastForEach$iv.get(index$iv);
                    it = (Range)item$iv;
                    boolean bl = false;
                    this.annotations.add(new MutableRange(it.getItem(), insertionStart + it.getStart(), insertionStart + it.getEnd(), it.getTag()));
                }
            }
        }

        public final void addStyle(@NotNull SpanStyle style, int start, int end2) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.spanStyles.add(new MutableRange(style, start, end2, null, 8, null));
        }

        public final void addStyle(@NotNull ParagraphStyle style, int start, int end2) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.paragraphStyles.add(new MutableRange(style, start, end2, null, 8, null));
        }

        public final void addStringAnnotation(@NotNull String tag, @NotNull String annotation, int start, int end2) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            this.annotations.add(new MutableRange<String>(annotation, start, end2, tag));
        }

        @ExperimentalTextApi
        public final void addTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation, int start, int end2) {
            Intrinsics.checkNotNullParameter((Object)ttsAnnotation, (String)"ttsAnnotation");
            this.annotations.add(new MutableRange(ttsAnnotation, start, end2, null, 8, null));
        }

        @Deprecated(message="Use LinkAnnotation API for links instead", replaceWith=@ReplaceWith(expression="addLink(, start, end)", imports={}))
        @ExperimentalTextApi
        public final void addUrlAnnotation(@NotNull UrlAnnotation urlAnnotation, int start, int end2) {
            Intrinsics.checkNotNullParameter((Object)urlAnnotation, (String)"urlAnnotation");
            this.annotations.add(new MutableRange(urlAnnotation, start, end2, null, 8, null));
        }

        public final void addLink(@NotNull LinkAnnotation.Url url, int start, int end2) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.annotations.add(new MutableRange(url, start, end2, null, 8, null));
        }

        public final void addLink(@NotNull LinkAnnotation.Clickable clickable2, int start, int end2) {
            Intrinsics.checkNotNullParameter((Object)clickable2, (String)"clickable");
            this.annotations.add(new MutableRange(clickable2, start, end2, null, 8, null));
        }

        public final int pushStyle(@NotNull SpanStyle style) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.spanStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStyle(@NotNull ParagraphStyle style) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            MutableRange it = mutableRange = new MutableRange(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.paragraphStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStringAnnotation(@NotNull String tag, @NotNull String annotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            MutableRange it = mutableRange = new MutableRange(annotation, this.text.length(), 0, tag, 4, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushTtsAnnotation(@NotNull TtsAnnotation ttsAnnotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)ttsAnnotation, (String)"ttsAnnotation");
            MutableRange it = mutableRange = new MutableRange(ttsAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        @Deprecated(message="Use LinkAnnotation API for links instead", replaceWith=@ReplaceWith(expression="pushLink(, start, end)", imports={}))
        @ExperimentalTextApi
        public final int pushUrlAnnotation(@NotNull UrlAnnotation urlAnnotation) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)urlAnnotation, (String)"urlAnnotation");
            MutableRange it = mutableRange = new MutableRange(urlAnnotation, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushLink(@NotNull LinkAnnotation link) {
            MutableRange mutableRange;
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            MutableRange it = mutableRange = new MutableRange(link, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            if (!(!((Collection)this.styleStack).isEmpty())) {
                boolean bl = false;
                String string = "Nothing to pop.";
                throw new IllegalStateException(string.toString());
            }
            MutableRange<? extends Object> item2 = this.styleStack.remove(this.styleStack.size() - 1);
            item2.setEnd(this.text.length());
        }

        public final void pop(int index2) {
            if (!(index2 < this.styleStack.size())) {
                boolean bl = false;
                String string = index2 + " should be less than " + this.styleStack.size();
                throw new IllegalStateException(string.toString());
            }
            while (this.styleStack.size() - 1 >= index2) {
                this.pop();
            }
        }

        @NotNull
        public final AnnotatedString toAnnotatedString() {
            Collection<MutableRange<SpanStyle>> collection;
            Collection collection2;
            Collection collection3;
            Collection collection4;
            List<MutableRange<ParagraphStyle>> list2;
            MutableRange it;
            Collection collection5;
            boolean bl;
            Object it$iv;
            Object item$iv$iv;
            int index$iv$iv;
            Collection<MutableRange<ParagraphStyle>> $this$fastMap$iv;
            String string = this.text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Collection<MutableRange<SpanStyle>> collection6 = this.spanStyles;
            String string2 = string;
            boolean $i$f$fastMap = false;
            ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
            Collection<MutableRange<ParagraphStyle>> $this$fastForEach$iv$iv = $this$fastMap$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                MutableRange mutableRange = (MutableRange)it$iv;
                collection5 = target$iv;
                boolean bl2 = false;
                collection5.add(it.toRange(this.text.length()));
            }
            String string3 = string2;
            $this$fastMap$iv = target$iv;
            if ($this$fastMap$iv.isEmpty()) {
                string2 = string3;
                boolean bl3 = false;
                list2 = null;
                string3 = string2;
            } else {
                list2 = $this$fastMap$iv;
            }
            $this$fastMap$iv = this.paragraphStyles;
            collection5 = list2;
            string2 = string3;
            $i$f$fastMap = false;
            target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                it = (MutableRange)it$iv;
                collection4 = target$iv;
                boolean bl4 = false;
                collection4.add(it.toRange(this.text.length()));
            }
            collection4 = target$iv;
            String string4 = string2;
            Collection collection7 = collection5;
            $this$fastMap$iv = collection4;
            if ($this$fastMap$iv.isEmpty()) {
                collection5 = collection7;
                string2 = string4;
                boolean bl5 = false;
                collection4 = null;
                string4 = string2;
                collection7 = collection5;
                collection3 = collection4;
            } else {
                collection3 = $this$fastMap$iv;
            }
            $this$fastMap$iv = this.annotations;
            collection4 = (List)collection3;
            collection5 = collection7;
            string2 = string4;
            $i$f$fastMap = false;
            target$iv = new ArrayList($this$fastMap$iv.size());
            $this$fastForEach$iv$iv = $this$fastMap$iv;
            $i$f$fastForEach = false;
            n = $this$fastForEach$iv$iv.size();
            for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                bl = false;
                it = (MutableRange)it$iv;
                collection2 = target$iv;
                boolean bl6 = false;
                collection2.add(it.toRange(this.text.length()));
            }
            collection2 = target$iv;
            String string5 = string2;
            Collection collection8 = collection5;
            Collection collection9 = collection4;
            collection6 = collection2;
            if (collection6.isEmpty()) {
                collection4 = collection9;
                collection5 = collection8;
                string2 = string5;
                boolean bl7 = false;
                collection2 = null;
                string5 = string2;
                collection8 = collection5;
                collection9 = collection4;
                collection = collection2;
            } else {
                collection = collection6;
            }
            List list3 = (List)collection;
            Collection collection10 = collection9;
            Collection collection11 = collection8;
            String string6 = string5;
            return new AnnotatedString(string6, (List<Range<SpanStyle>>)collection11, (List<Range<ParagraphStyle>>)collection10, list3);
        }

        public Builder() {
            this(0, 1, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\b\b\u0002\u0010 \u001a\u00020\u0005J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "T", "", "item", "start", "", "end", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "setEnd", "(I)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Builder$MutableRange;", "equals", "", "other", "hashCode", "toRange", "Landroidx/compose/ui/text/AnnotatedString$Range;", "defaultEnd", "toString", "ui-text"})
        @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Builder$MutableRange\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1270:1\n1#2:1271\n*E\n"})
        private static final class MutableRange<T> {
            private final T item;
            private final int start;
            private int end;
            @NotNull
            private final String tag;

            public MutableRange(T item2, int start, int end2, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.item = item2;
                this.start = start;
                this.end = end2;
                this.tag = tag;
            }

            public /* synthetic */ MutableRange(Object object, int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                if ((n3 & 8) != 0) {
                    string = "";
                }
                this(object, n, n2, string);
            }

            public final T getItem() {
                return this.item;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @NotNull
            public final Range<T> toRange(int defaultEnd) {
                int end2 = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                if (!(end2 != Integer.MIN_VALUE)) {
                    boolean bl = false;
                    String string = "Item.end should be set first";
                    throw new IllegalStateException(string.toString());
                }
                return new Range<T>(this.item, this.start, end2, this.tag);
            }

            public static /* synthetic */ Range toRange$default(MutableRange mutableRange, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableRange.toRange(n);
            }

            public final T component1() {
                return this.item;
            }

            public final int component2() {
                return this.start;
            }

            public final int component3() {
                return this.end;
            }

            @NotNull
            public final String component4() {
                return this.tag;
            }

            @NotNull
            public final MutableRange<T> copy(T item2, int start, int end2, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                return new MutableRange<T>(item2, start, end2, tag);
            }

            public static /* synthetic */ MutableRange copy$default(MutableRange mutableRange, Object object, int n, int n2, String string, int n3, Object object2) {
                if ((n3 & 1) != 0) {
                    object = mutableRange.item;
                }
                if ((n3 & 2) != 0) {
                    n = mutableRange.start;
                }
                if ((n3 & 4) != 0) {
                    n2 = mutableRange.end;
                }
                if ((n3 & 8) != 0) {
                    string = mutableRange.tag;
                }
                return mutableRange.copy(object, n, n2, string);
            }

            @NotNull
            public String toString() {
                return "MutableRange(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
            }

            public int hashCode() {
                int result2 = this.item == null ? 0 : this.item.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.start);
                result2 = result2 * 31 + Integer.hashCode(this.end);
                result2 = result2 * 31 + this.tag.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableRange)) {
                    return false;
                }
                MutableRange mutableRange = (MutableRange)other;
                if (!Intrinsics.areEqual(this.item, mutableRange.item)) {
                    return false;
                }
                if (this.start != mutableRange.start) {
                    return false;
                }
                if (this.end != mutableRange.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tag, (Object)mutableRange.tag);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/ui/text/AnnotatedString;", "getSaver", "()Landroidx/compose/runtime/saveable/Saver;", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<AnnotatedString, ?> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/text/AnnotatedString$Range;", "T", "", "item", "start", "", "end", "(Ljava/lang/Object;II)V", "tag", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStart", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/compose/ui/text/AnnotatedString$Range;", "equals", "", "other", "hashCode", "toString", "ui-text"})
    @Immutable
    @SourceDebugExtension(value={"SMAP\nAnnotatedString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedString$Range\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1270:1\n1#2:1271\n*E\n"})
    public static final class Range<T> {
        private final T item;
        private final int start;
        private final int end;
        @NotNull
        private final String tag;
        public static final int $stable;

        public Range(T item2, int start, int end2, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.item = item2;
            this.start = start;
            this.end = end2;
            this.tag = tag;
            if (!(this.start <= this.end)) {
                boolean bl = false;
                String string = "Reversed range is not supported";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public Range(T item2, int start, int end2) {
            this(item2, start, end2, "");
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final String component4() {
            return this.tag;
        }

        @NotNull
        public final Range<T> copy(T item2, int start, int end2, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return new Range<T>(item2, start, end2, tag);
        }

        public static /* synthetic */ Range copy$default(Range range, Object object, int n, int n2, String string, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = range.item;
            }
            if ((n3 & 2) != 0) {
                n = range.start;
            }
            if ((n3 & 4) != 0) {
                n2 = range.end;
            }
            if ((n3 & 8) != 0) {
                string = range.tag;
            }
            return range.copy(object, n, n2, string);
        }

        @NotNull
        public String toString() {
            return "Range(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", tag=" + this.tag + ')';
        }

        public int hashCode() {
            int result2 = this.item == null ? 0 : this.item.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.start);
            result2 = result2 * 31 + Integer.hashCode(this.end);
            result2 = result2 * 31 + this.tag.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Range)) {
                return false;
            }
            Range range = (Range)other;
            if (!Intrinsics.areEqual(this.item, range.item)) {
                return false;
            }
            if (this.start != range.start) {
                return false;
            }
            if (this.end != range.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)range.tag);
        }
    }
}

