/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.platform;

import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontFamily_desktopKt;
import androidx.compose.ui.text.platform.AwtFontUtils;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0002H\u0007\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0004*\u00020\u0002H\u0001\u00a8\u0006\u0006"}, d2={"asComposeFontFamily", "Landroidx/compose/ui/text/font/FontFamily;", "Ljava/awt/Font;", "composeFontFamilyNameOrNull", "", "fontFamilyNameOrNull", "ui-text"})
public final class AwtFontInteropKt {
    @ExperimentalTextApi
    @NotNull
    public static final FontFamily asComposeFontFamily(@NotNull Font $this$asComposeFontFamily) {
        String familyName;
        Intrinsics.checkNotNullParameter((Object)$this$asComposeFontFamily, (String)"<this>");
        String string = AwtFontInteropKt.composeFontFamilyNameOrNull($this$asComposeFontFamily);
        if (string == null) {
            string = familyName = $this$asComposeFontFamily.getFamily();
        }
        if (OsArch_jvmKt.getHostOs() == OS.MacOS) {
            Intrinsics.checkNotNull((Object)familyName);
            if (StringsKt.startsWith((String)familyName, (String)".AppleSystemUI", (boolean)true)) {
                return FontFamily.Companion.getDefault();
            }
        }
        Intrinsics.checkNotNull((Object)familyName);
        FontFamily fontFamily = FontFamily_desktopKt.EmbeddedFontFamily(familyName);
        if (fontFamily == null) {
            fontFamily = FontFamily_desktopKt.FontFamily(familyName);
        }
        return fontFamily;
    }

    @ExperimentalTextApi
    @Nullable
    public static final String composeFontFamilyNameOrNull(@NotNull Font $this$composeFontFamilyNameOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$composeFontFamilyNameOrNull, (String)"<this>");
        String string = AwtFontInteropKt.fontFamilyNameOrNull($this$composeFontFamilyNameOrNull);
        if (string == null) {
            string = $this$composeFontFamilyNameOrNull.getFamily();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return AwtFontUtils.INSTANCE.resolvePhysicalFontFamilyNameOrNull(string2, $this$composeFontFamilyNameOrNull.getStyle());
    }

    @ExperimentalTextApi
    @Nullable
    public static final String fontFamilyNameOrNull(@NotNull Font $this$fontFamilyNameOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$fontFamilyNameOrNull, (String)"<this>");
        return AwtFontUtils.INSTANCE.getPreferredFontFamilyName($this$fontFamilyNameOrNull);
    }
}

