/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.impl;

import com.intellij.database.DataGridBundle;
import com.intellij.database.extensions.LoaderScripts;
import com.intellij.database.loaders.DataLoader;
import com.intellij.grid.scripting.impl.DataLoaderManager;
import com.intellij.grid.scripting.impl.DataLoaderManagerKt;
import com.intellij.grid.scripting.impl.ScriptedDataLoader;
import com.intellij.grid.scripting.impl.ScriptedTableFileEditorProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xmlb.annotations.Tag;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0005\u001c\u001d\u001e\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\tH\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006J\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\tH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "allLoaders", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "Lcom/intellij/grid/scripting/impl/ScriptedDataLoader;", "dispose", "", "cleanup", "flush", "updateAssociations", "getDataLoaders", "Lcom/intellij/database/loaders/DataLoader;", "getDataLoadersToAssociate", "setting", "Lcom/intellij/grid/scripting/impl/ScriptedTableFileEditorProvider$OpenDetectedTables;", "getDataLoader", "id", "", "findDataLoader", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "tableFirstOnlyFormats", "", "onFsChanged", "dropLoaders", "Companion", "SettingListener", "VfsListener", "DataFileType", "Associations", "intellij.grid.scripting.impl"})
@SourceDebugExtension(value={"SMAP\nDataLoaderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n31#2,2:281\n774#3:283\n865#3,2:284\n1611#3,9:287\n1863#3:296\n1864#3:298\n1620#3:299\n1863#3,2:300\n1557#3:302\n1628#3,3:303\n1#4:286\n1#4:297\n*S KotlinDebug\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager\n*L\n126#1:281,2\n138#1:283\n138#1:284,2\n157#1:287,9\n157#1:296\n157#1:298\n157#1:299\n161#1:300,2\n95#1:302\n95#1:303,3\n157#1:297\n*E\n"})
public final class DataLoaderManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SynchronizedClearableLazy<List<ScriptedDataLoader>> allLoaders = new SynchronizedClearableLazy(DataLoaderManager::allLoaders$lambda$1);

    public DataLoaderManager() {
        this.updateAssociations();
        try {
            DataLoaderManagerKt.access$initConfig(Companion.getGrapeDir$intellij_grid_scripting_impl());
        }
        catch (Throwable th) {
            DataLoaderManagerKt.access$getLogger$p().warn(th);
        }
    }

    public void dispose() {
        this.dropLoaders();
    }

    @TestOnly
    public final void cleanup() {
        this.dropLoaders();
    }

    @TestOnly
    public final void flush() {
        com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DataLoaderManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DataLoaderManager.access$dropLoaders(this.this$0);
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                        ComponentManager $this$service$iv = (ComponentManager)application;
                        boolean $i$f$service = false;
                        Class<Associations> serviceClass$iv = Associations.class;
                        Object object3 = $this$service$iv.getService(serviceClass$iv);
                        if (object3 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        this.label = 1;
                        Object object4 = ((Associations)object3).updateAssociations((Continuation<? super Unit>)((Continuation)this));
                        if (object4 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void updateAssociations() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<Associations> serviceClass$iv = Associations.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((Associations)object).scheduleUpdate();
    }

    @NotNull
    public final List<DataLoader> getDataLoaders() {
        return (List)this.allLoaders.get();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<DataLoader> getDataLoadersToAssociate(@NotNull ScriptedTableFileEditorProvider.OpenDetectedTables setting) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)setting), (String)"setting");
        if (setting == ScriptedTableFileEditorProvider.OpenDetectedTables.NONE) {
            return CollectionsKt.emptyList();
        }
        List<DataLoader> dataLoaders = this.getDataLoaders();
        if (dataLoaders.isEmpty()) {
            return null;
        }
        if (setting == ScriptedTableFileEditorProvider.OpenDetectedTables.ALL) {
            return dataLoaders;
        }
        Iterable $this$filter$iv = dataLoaders;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DataLoader it = (DataLoader)element$iv$iv;
            boolean bl = false;
            if (!it.isTableFirstFormat()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final DataLoader getDataLoader(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.getDataLoaders();
            for (Object t : iterable) {
                DataLoader it = (DataLoader)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final DataLoader findDataLoader(@NotNull VirtualFile file, boolean tableFirstOnlyFormats) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable iterable = this.getDataLoaders();
            for (Object t : iterable) {
                DataLoader it = (DataLoader)t;
                boolean bl = false;
                if (!(it.isSuitable(file) && (!tableFirstOnlyFormats || it.isTableFirstFormat()))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void onFsChanged() {
        this.dropLoaders();
        this.updateAssociations();
    }

    /*
     * WARNING - void declaration
     */
    private final void dropLoaders() {
        void $this$mapNotNullTo$iv$iv;
        List list = (List)this.allLoaders.getValueIfInitialized();
        if (list == null) {
            return;
        }
        List loaders = list;
        this.allLoaders.drop();
        Iterable $this$mapNotNull$iv = loaders;
        boolean $i$f$mapNotNull2 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Throwable it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ScriptedDataLoader it = (ScriptedDataLoader)element$iv$iv;
            boolean bl2 = false;
            DataLoaderManager dataLoaderManager = this;
            try {
                DataLoaderManager $this$dropLoaders_u24lambda_u246_u24lambda_u245 = dataLoaderManager;
                boolean bl3 = false;
                it.cleanup();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.exceptionOrNull-impl((Object)object) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List errors = (List)destination$iv$iv;
        if (!((Collection)errors).isEmpty()) {
            RuntimeException runtimeException;
            RuntimeException $i$f$mapNotNull2 = runtimeException = new RuntimeException("Errors on cleanup");
            Logger logger = DataLoaderManagerKt.access$getLogger$p();
            boolean bl = false;
            Iterable $this$forEach$iv = errors;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$dropLoaders_u24lambda_u248;
                Throwable it = (Throwable)element$iv;
                boolean bl5 = false;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$dropLoaders_u24lambda_u248), (Throwable)it);
            }
            logger.warn((Throwable)runtimeException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List allLoaders$lambda$1() {
        void var3_3;
        void $this$mapTo$iv$iv;
        List list = LoaderScripts.getScriptFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getScriptFiles(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new ScriptedDataLoader((Path)it));
        }
        return (List)var3_3;
    }

    @JvmStatic
    @NotNull
    public static final DataLoaderManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ void access$dropLoaders(DataLoaderManager $this) {
        $this.dropLoaders();
    }

    public static final /* synthetic */ void access$onFsChanged(DataLoaderManager $this) {
        $this.onFsChanged();
    }

    @Service(value={Service.Level.APP})
    @com.intellij.openapi.components.State(name="ScriptedLoadersAssociations", storages={@Storage(value="csvSettings.xml")}, category=SettingsCategory.TOOLS)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u0013\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderManager$Associations;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/grid/scripting/impl/DataLoaderManager$Associations$State;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "state", "updates", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getState", "noStateLoaded", "loadState", "newState", "contains", "", "ext", "", "scheduleUpdate", "updateAssociations", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "State", "intellij.grid.scripting.impl"})
    @SourceDebugExtension(value={"SMAP\nDataLoaderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$Associations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1469#2,5:281\n*S KotlinDebug\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$Associations\n*L\n266#1:281,5\n*E\n"})
    private static final class Associations
    implements PersistentStateComponent<State> {
        @NotNull
        private final State state;
        @NotNull
        private final MutableSharedFlow<Unit> updates;

        public Associations(@NotNull CoroutineScope cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            this.state = new State();
            this.updates = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
            BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ Associations this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.updates), (long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ Associations this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = this.this$0.updateAssociations((Continuation<? super Unit>)((Continuation)this));
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public State getState() {
            State state;
            State $this$getState_u24lambda_u241 = state = new State();
            boolean bl = false;
            State state2 = this.state;
            synchronized (state2) {
                boolean bl2 = false;
                $this$getState_u24lambda_u241.getExtensions().addAll((Collection<String>)this.state.getExtensions());
                Unit unit = Unit.INSTANCE;
            }
            return state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noStateLoaded() {
            ScriptedTableFileEditorProvider.OpenDetectedTables openDetectedTables = ScriptedTableFileEditorProvider.OpenDetectedTables.getOpenDetectedTablesSetting();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)openDetectedTables), (String)"getOpenDetectedTablesSetting(...)");
            ScriptedTableFileEditorProvider.OpenDetectedTables setting = openDetectedTables;
            State state = this.state;
            synchronized (state) {
                boolean bl = false;
                this.state.getExtensions().clear();
                boolean bl2 = this.state.getExtensions().addAll((Collection<String>)Companion.getDefaultExtensions(setting));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadState(@NotNull State newState) {
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            State state = this.state;
            synchronized (state) {
                boolean bl = false;
                this.state.getExtensions().clear();
                boolean bl2 = this.state.getExtensions().addAll((Collection<String>)newState.getExtensions());
            }
            ScriptedTableFileEditorProvider.OpenDetectedTables openDetectedTables = ScriptedTableFileEditorProvider.OpenDetectedTables.getOpenDetectedTablesSetting();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)openDetectedTables), (String)"getOpenDetectedTablesSetting(...)");
            if (!newState.extensionsEqual((Collection<String>)Companion.getDefaultExtensions(openDetectedTables))) {
                this.scheduleUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean contains(@Nullable String ext) {
            boolean bl;
            State state = this.state;
            synchronized (state) {
                boolean bl2 = false;
                bl = ext != null && this.state.getExtensions().contains(ext);
            }
            return bl;
        }

        public final void scheduleUpdate() {
            this.updates.tryEmit((Object)Unit.INSTANCE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final Object updateAssociations(@NotNull Continuation<? super Unit> $completion) {
            void $this$flatMapTo$iv;
            DataLoaderManager dataLoaderManager = Companion.getInstance();
            ScriptedTableFileEditorProvider.OpenDetectedTables openDetectedTables = ScriptedTableFileEditorProvider.OpenDetectedTables.getOpenDetectedTablesSetting();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)openDetectedTables), (String)"getOpenDetectedTablesSetting(...)");
            List<DataLoader> dataLoaders = dataLoaderManager.getDataLoadersToAssociate(openDetectedTables);
            if (dataLoaders == null) {
                return Unit.INSTANCE;
            }
            Object object = dataLoaders;
            Set set = CollectionFactory.createCaseInsensitiveStringSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createCaseInsensitiveStringSet(...)");
            Collection destination$iv = set;
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                DataLoader it = (DataLoader)element$iv;
                boolean bl = false;
                Sequence list$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)it.getAssociatedExtensions()), (Function1)updateAssociations.extensions.1.1.INSTANCE);
                CollectionsKt.addAll((Collection)destination$iv, (Sequence)list$iv);
            }
            Set extensions2 = (Set)destination$iv;
            object = this.state;
            synchronized (object) {
                block7: {
                    boolean bl = false;
                    if (!this.state.extensionsEqual(extensions2)) break block7;
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                this.state.getExtensions().clear();
                boolean bl = this.state.getExtensions().addAll(extensions2);
            }
            Object object2 = CoroutinesKt.edtWriteAction(Associations::updateAssociations$lambda$8, $completion);
            if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object2;
            }
            return Unit.INSTANCE;
        }

        private static final void updateAssociations$lambda$8$lambda$7() {
        }

        private static final Unit updateAssociations$lambda$8() {
            FileTypeManagerEx.getInstanceEx().makeFileTypesChange("new associations from DataLoaderManager", Associations::updateAssociations$lambda$8$lambda$7);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fR\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderManager$Associations$State;", "", "<init>", "()V", "extensions", "", "", "getExtensions", "()Ljava/util/Set;", "extensionsEqual", "", "o", "", "intellij.grid.scripting.impl"})
        public static final class State {
            @Tag
            @NotNull
            private final Set<String> extensions;

            public State() {
                Set set = CollectionFactory.createCaseInsensitiveStringSet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createCaseInsensitiveStringSet(...)");
                this.extensions = set;
            }

            @NotNull
            public final Set<String> getExtensions() {
                return this.extensions;
            }

            public final boolean extensionsEqual(@NotNull Collection<String> o) {
                Intrinsics.checkNotNullParameter(o, (String)"o");
                return this.extensions.size() == o.size() && this.extensions.containsAll(o);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/grid/scripting/impl/DataLoaderManager;", "getDefaultExtensions", "", "", "setting", "Lcom/intellij/grid/scripting/impl/ScriptedTableFileEditorProvider$OpenDetectedTables;", "getGrapeDir", "Ljava/nio/file/Path;", "getGrapeDir$intellij_grid_scripting_impl", "intellij.grid.scripting.impl"})
    @SourceDebugExtension(value={"SMAP\nDataLoaderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,280:1\n31#2,2:281\n*S KotlinDebug\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$Companion\n*L\n78#1:281,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataLoaderManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DataLoaderManager> serviceClass$iv = DataLoaderManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DataLoaderManager)object;
        }

        @NotNull
        public final List<String> getDefaultExtensions(@NotNull ScriptedTableFileEditorProvider.OpenDetectedTables setting) {
            Intrinsics.checkNotNullParameter((Object)((Object)setting), (String)"setting");
            return switch (WhenMappings.$EnumSwitchMapping$0[setting.ordinal()]) {
                case 1 -> {
                    Object[] var2_2 = new String[]{"parquet", "json", "xls", "xlsx", "shp"};
                    yield CollectionsKt.listOf((Object[])var2_2);
                }
                case 2 -> {
                    Object[] var2_3 = new String[]{"parquet", "xls", "xlsx", "shp"};
                    yield CollectionsKt.listOf((Object[])var2_3);
                }
                case 3 -> CollectionsKt.emptyList();
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final Path getGrapeDir$intellij_grid_scripting_impl() {
            Path path = PathManager.getSystemDir().resolve("grape");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ScriptedTableFileEditorProvider.OpenDetectedTables.values().length];
                try {
                    nArray[ScriptedTableFileEditorProvider.OpenDetectedTables.ALL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScriptedTableFileEditorProvider.OpenDetectedTables.TABLE_FIRST_FORMATS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ScriptedTableFileEditorProvider.OpenDetectedTables.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderManager$DataFileType;", "Lcom/intellij/openapi/fileTypes/ex/FileTypeIdentifiableByVirtualFile;", "<init>", "()V", "getName", "", "getDisplayName", "getDescription", "getDefaultExtension", "getIcon", "Ljavax/swing/Icon;", "isBinary", "", "isReadOnly", "isMyFileType", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasScriptLoader", "intellij.grid.scripting.impl"})
    @SourceDebugExtension(value={"SMAP\nDataLoaderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$DataFileType\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,280:1\n31#2,2:281\n*S KotlinDebug\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$DataFileType\n*L\n206#1:281,2\n*E\n"})
    public static final class DataFileType
    implements FileTypeIdentifiableByVirtualFile {
        @NotNull
        public static final DataFileType INSTANCE = new DataFileType();

        private DataFileType() {
        }

        @NotNull
        public String getName() {
            return "Data File";
        }

        @NotNull
        public String getDisplayName() {
            String string = DataGridBundle.message((String)"filetype.tabular.data.description", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getDescription() {
            String string = DataGridBundle.message((String)"filetype.tabular.data.description", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getDefaultExtension() {
            return "";
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Nodes.DataTables;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DataTables");
            return icon;
        }

        public boolean isBinary() {
            return true;
        }

        public boolean isReadOnly() {
            return false;
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!this.hasScriptLoader(file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName()), (Object)FileTypes.UNKNOWN);
        }

        public final boolean hasScriptLoader(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String extension = file.getExtension();
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<Associations> serviceClass$iv = Associations.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((Associations)object).contains(extension);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderManager$SettingListener;", "Lcom/intellij/openapi/options/advanced/AdvancedSettingsChangeListener;", "<init>", "()V", "advancedSettingChanged", "", "id", "", "oldValue", "", "newValue", "intellij.grid.scripting.impl"})
    @SourceDebugExtension(value={"SMAP\nDataLoaderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$SettingListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,280:1\n31#2,2:281\n*S KotlinDebug\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$SettingListener\n*L\n168#1:281,2\n*E\n"})
    public static final class SettingListener
    implements AdvancedSettingsChangeListener {
        public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            if (Intrinsics.areEqual((Object)id, (Object)"database.import.open.detected.tables")) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                ComponentManager $this$service$iv = (ComponentManager)application;
                boolean $i$f$service = false;
                Class<Associations> serviceClass$iv = Associations.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((Associations)object).scheduleUpdate();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grid/scripting/impl/DataLoaderManager$VfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "()V", "rootPath", "", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.grid.scripting.impl"})
    @SourceDebugExtension(value={"SMAP\nDataLoaderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$VfsListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1#2:281\n1755#3,3:282\n*S KotlinDebug\n*F\n+ 1 DataLoaderManager.kt\ncom/intellij/grid/scripting/impl/DataLoaderManager$VfsListener\n*L\n177#1:282,3\n*E\n"})
    public static final class VfsListener
    implements AsyncFileListener {
        @Nullable
        private final String rootPath;

        public VfsListener() {
            String string;
            VfsListener vfsListener = this;
            String string2 = LoaderScripts.getScriptsDirectoryWithoutUnpack();
            if (string2 != null) {
                String it = string2;
                VfsListener vfsListener2 = vfsListener;
                boolean bl = false;
                string = it + "/";
                vfsListener = vfsListener2;
            } else {
                string = null;
            }
            vfsListener.rootPath = string;
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (this.rootPath == null) {
                    return null;
                }
                Iterable $this$any$iv = events;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VFileEvent it = (VFileEvent)element$iv;
                        boolean bl2 = false;
                        String string = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (!StringsKt.startsWith$default((String)string, (String)this.rootPath, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                return null;
            }
            return new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    DataLoaderManager.access$onFsChanged(DataLoaderManager.Companion.getInstance());
                }
            };
        }
    }
}

