/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.endpoints.webStructure;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.python.endpoints.CommonKt;
import com.intellij.python.endpoints.ModuleWebApplication;
import com.intellij.python.endpoints.ProjectWebStructureKt;
import com.intellij.python.endpoints.PyEndpointsBundle;
import com.intellij.python.endpoints.UrlPathsMethods;
import com.intellij.python.endpoints.WebStructureAction;
import com.intellij.python.endpoints.WebStructureActionFactory;
import com.intellij.python.endpoints.WebStructureUsagesCollector;
import com.intellij.python.endpoints.webStructure.CopyToClipboardActionFactoryKt;
import com.intellij.python.endpoints.webStructure.NavigationKt;
import com.intellij.python.endpoints.webStructure.UrlPathListPopupStep;
import com.intellij.python.endpoints.webStructure.WebStructureNavigationHandler;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0018\u0010\u0007\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000bH\u0016J3\u0010\f\u001a\u00130\r\u00a2\u0006\u000e\b\u000e\u0012\n\b\u000f\u0012\u0006\b\n0\u00108\u00112\u0018\u0010\u0007\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/endpoints/webStructure/CopyToClipboardActionFactory;", "Lcom/intellij/python/endpoints/WebStructureActionFactory;", "<init>", "()V", "createActions", "Lkotlin/sequences/Sequence;", "Lcom/intellij/python/endpoints/WebStructureAction;", "originalWebApplicationContexts", "", "Lcom/intellij/python/endpoints/ModuleWebApplication;", "Lcom/intellij/python/endpoints/UrlPathsMethods;", "Lcom/intellij/python/endpoints/WebApplicationContexts;", "buildTitle", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "copyToClipboardWithHint", "", "text", "mouseEvent", "Ljava/awt/event/MouseEvent;", "intellij.python.endpoints"})
public final class CopyToClipboardActionFactory
implements WebStructureActionFactory {
    @Override
    @NotNull
    public Sequence<WebStructureAction> createActions(@NotNull Map<ModuleWebApplication, UrlPathsMethods> originalWebApplicationContexts) {
        Intrinsics.checkNotNullParameter(originalWebApplicationContexts, (String)"originalWebApplicationContexts");
        WebStructureNavigationHandler handler = (arg_0, arg_1, arg_2) -> CopyToClipboardActionFactory.createActions$lambda$1(this, arg_0, arg_1, arg_2);
        WebStructureAction action = new WebStructureAction(CopyToClipboardActionFactoryKt.access$getCOPY_TO_CLIPBOARD_ACTION_ICON$p(), this.buildTitle(originalWebApplicationContexts), PyEndpointsBundle.INSTANCE.message("web.structure.line.marker.copy.to.clipboard.accessible.name", new Object[0]), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)handler), (Function2<? super WebStructureUsagesCollector.Origin, ? super MouseEvent, Unit>)((Function2)CopyToClipboardActionFactory::createActions$lambda$2));
        Object[] objectArray = new WebStructureAction[]{action};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private final String buildTitle(Map<ModuleWebApplication, UrlPathsMethods> originalWebApplicationContexts) {
        String path2 = ProjectWebStructureKt.commonPathMasked(originalWebApplicationContexts);
        Object[] objectArray = new Object[]{path2};
        return PyEndpointsBundle.INSTANCE.message("web.structure.line.marker.copy.to.clipboard", objectArray);
    }

    private final void copyToClipboardWithHint(String text, MouseEvent mouseEvent) {
        CopyPasteManager.copyTextToClipboard((String)text);
        NavigationKt.showEventHint(new SimpleColoredText(PyEndpointsBundle.INSTANCE.message("web.structure.copy.path.to.clipboard", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES), CopyToClipboardActionFactoryKt.access$getCOPY_TO_CLIPBOARD_ACTION_ICON$p(), mouseEvent);
    }

    private static final Unit createActions$lambda$1$lambda$0(CopyToClipboardActionFactory this$0, MouseEvent $mouseEvent, UrlPath selectedUrlPath) {
        Intrinsics.checkNotNullParameter((Object)selectedUrlPath, (String)"selectedUrlPath");
        this$0.copyToClipboardWithHint(CommonKt.toStringWithLeadingSlash(selectedUrlPath), $mouseEvent);
        return Unit.INSTANCE;
    }

    private static final void createActions$lambda$1(CopyToClipboardActionFactory this$0, MouseEvent mouseEvent, PsiElement psiElement, Map contexts) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)contexts, (String)"contexts");
        List paths = UiUtils.naturalSorted((Iterable)ProjectWebStructureKt.uniquePathHttpMethods(contexts).keySet());
        int n = paths.size();
        boolean bl = 0 <= n ? n < 2 : false;
        if (bl) {
            this$0.copyToClipboardWithHint(ProjectWebStructureKt.commonPathMasked(paths), mouseEvent);
        } else {
            UrlPathListPopupStep selectAndCopyPathStep = new UrlPathListPopupStep(AllIcons.Actions.Copy, paths, (Function1<? super UrlPath, Unit>)((Function1)arg_0 -> CopyToClipboardActionFactory.createActions$lambda$1$lambda$0(this$0, mouseEvent, arg_0)));
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)selectAndCopyPathStep).show(new RelativePoint(mouseEvent));
        }
    }

    private static final Unit createActions$lambda$2(WebStructureUsagesCollector.Origin origin, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)origin), (String)"origin");
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        WebStructureUsagesCollector.INSTANCE.logCopyToClipboard(origin, mouseEvent);
        return Unit.INSTANCE;
    }
}

