/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.python.remoteInterpreter.PyHelpersUpload;
import com.intellij.python.remoteInterpreter.PyRemoteInterpreterCommandLineUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshException;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.ssh.process.SshProcess;
import com.intellij.util.AbstractPathMapper;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PyRemoteProcessUtil {
    private PyRemoteProcessUtil() {
    }

    public static void uploadAllHelpers(@NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties, @Nullable Project project) {
        if (credentials == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(0);
        }
        if (sdkProperties == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(1);
        }
        PyHelpersUpload.uploadAllHelpers(project, null, credentials, sdkProperties, false);
    }

    @TestOnly
    public static void shutDownHelpersService() {
        PyHelpersUpload.shutDownService();
    }

    public static ProcessOutput getProcessOutput(@NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties, @NotNull PyRemotePathMapper pathMapper, String @NotNull [] command, @Nullable String workingDir, boolean askForSudo) throws RemoteSdkException {
        if (connectionBuilder == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(2);
        }
        if (credentials == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(3);
        }
        if (sdkProperties == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(5);
        }
        if (command == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(6);
        }
        return PyRemoteProcessUtil.getProcessHandler(connectionBuilder, credentials, sdkProperties, pathMapper, command, workingDir, askForSudo).runProcess();
    }

    @NotNull
    public static CapturingSshProcessHandler getProcessHandler(@NotNull ConnectionBuilder connectionBuilder, @NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties, @NotNull PyRemotePathMapper pathMapper, String @NotNull [] command, @Nullable String workingDir, boolean askForSudo) throws RemoteSdkException {
        SshExecProcess process;
        if (connectionBuilder == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(7);
        }
        if (credentials == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(8);
        }
        if (sdkProperties == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(9);
        }
        if (pathMapper == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(10);
        }
        if (command == null) {
            PyRemoteProcessUtil.$$$reportNull$$$0(11);
        }
        Pair<String[], String> commandWithWorkingDir = PyRemoteInterpreterCommandLineUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, command, workingDir, sdkProperties.getInterpreterPath());
        GeneralCommandLine commandLine = new GeneralCommandLine((String[])commandWithWorkingDir.first).withWorkDirectory((String)commandWithWorkingDir.second);
        PythonEnvUtil.setPythonUnbuffered((Map)commandLine.getEnvironment());
        ProcessBuilder builder = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withSudo((PasswordStringProvider)(askForSudo ? new DialogSshSudoPasswordStringProvider(credentials) : null)).withAllocatePty(false);
        try {
            process = builder.start();
        }
        catch (SshException exc) {
            throw new RemoteSdkException(PythonRemoteInterpreterBundle.message("python.remote.process.failed.to.connect.to.ssh.server", exc.getMessage()), (Throwable)exc);
        }
        return new CapturingSshProcessHandler((SshProcess)process, null, commandLine.getCommandLineString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkProperties";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionBuilder";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteProcessUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadAllHelpers";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessOutput";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

