/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures.base;

import com.google.common.base.Preconditions;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.impl.DockableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.figures.Figure;
import com.intellij.python.scientific.figures.base.FigureContentPanelBase;
import com.intellij.python.scientific.figures.image.ImageVirtualFile;
import com.intellij.python.scientific.ui.PyPlotToolWindow;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/python/scientific/figures/base/FigureBase;", "Lcom/intellij/python/scientific/figures/Figure;", "panelNotification", "Ljavax/swing/JComponent;", "<init>", "(Ljavax/swing/JComponent;)V", "mySearchKey", "", "hasSearchKey", "", "getSearchKey", "setSearchKey", "", "searchKey", "isInteractive", "()Z", "createTabInfo", "Lcom/intellij/ui/tabs/TabInfo;", "icon", "Ljavax/swing/Icon;", "panel", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.python.scientific"})
public abstract class FigureBase
implements Figure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JComponent panelNotification;
    @Nullable
    private Object mySearchKey;

    public FigureBase(@Nullable JComponent panelNotification) {
        this.panelNotification = panelNotification;
    }

    public /* synthetic */ FigureBase(JComponent jComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jComponent = null;
        }
        this(jComponent);
    }

    @Override
    public boolean hasSearchKey() {
        return this.mySearchKey != null;
    }

    @Override
    @NotNull
    public Object getSearchKey() {
        Preconditions.checkState((boolean)this.hasSearchKey(), (String)"Search key is not defined", (Object[])new Object[0]);
        Object object = this.mySearchKey;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    public final void setSearchKey(@Nullable Object searchKey) {
        this.mySearchKey = searchKey;
    }

    public boolean isInteractive() {
        return false;
    }

    @NotNull
    protected TabInfo createTabInfo(@NotNull Icon icon, @NotNull JPanel panel, @NotNull Project project) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JComponent additionalPanel = this.panelNotification;
        if (additionalPanel != null) {
            JPanel jPanel2;
            JPanel $this$createTabInfo_u24lambda_u240 = jPanel2 = new JPanel(new BorderLayout());
            boolean bl = false;
            $this$createTabInfo_u24lambda_u240.add((Component)panel, "Center");
            $this$createTabInfo_u24lambda_u240.add((Component)additionalPanel, "South");
            jPanel = jPanel2;
        } else {
            jPanel = panel;
        }
        JPanel newPanel = jPanel;
        TabInfo info = new TabInfo((JComponent)newPanel);
        info.setTabColor(UIUtil.getPanelBackground());
        info.setIcon(icon);
        int index = PyPlotToolWindow.Companion.getInstance(project).getLastPlotIndex();
        info.setText(String.valueOf(index));
        return info;
    }

    public FigureBase() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/python/scientific/figures/base/FigureBase$Companion;", "", "<init>", "()V", "createDockableContent", "Lcom/intellij/ui/docking/DockableContent;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "createDockableContent$intellij_python_scientific", "intellij.python.scientific"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockableContent<?> createDockableContent$intellij_python_scientific(@NotNull TabInfo info) {
            ImageVirtualFile file;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Image img = JBTabsImpl.Companion.getComponentImage(info);
            Presentation presentation = new Presentation(info.getText());
            Dimension preferredSize = info.getComponent().getPreferredSize();
            JComponent jComponent = info.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.python.scientific.figures.base.FigureContentPanelBase");
            ImageVirtualFile imageVirtualFile = file = ((FigureContentPanelBase)jComponent).getFileWithBinaryContent();
            Intrinsics.checkNotNull((Object)((Object)imageVirtualFile));
            ImageVirtualFile fileCopy = ImageVirtualFile.Companion.makeCopy(imageVirtualFile);
            VirtualFile virtualFile = (VirtualFile)fileCopy;
            Intrinsics.checkNotNull((Object)preferredSize);
            return (DockableContent)new DockableEditor(img, virtualFile, presentation, preferredSize, false, false, false, 64, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

