/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.commands;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.api.DSSessionListener;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DescribeTableCommand;
import com.intellij.scientific.tables.api.ImageTableCommand;
import com.intellij.scientific.tables.api.InfoTableCommand;
import com.intellij.scientific.tables.api.SliceTableCommand;
import com.intellij.scientific.tables.api.TableCommand;
import com.intellij.scientific.tables.api.TableCommandCodeProvider;
import com.intellij.scientific.tables.api.VisualizationDataTableCommand;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.pydev.tables.PyDevCommandParameters;
import com.jetbrains.python.tables.TableCommandParameters;
import com.jetbrains.python.tables.TableCommandType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J'\u0010\u001c\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/scientific/py/tables/commands/DSFrameAccessorCommandExecutor;", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "<init>", "(Lcom/jetbrains/python/debugger/PyFrameAccessor;)V", "listeners", "", "Lcom/intellij/scientific/tables/api/DSSessionListener;", "dataAccessorClass", "Ljava/lang/Class;", "getDataAccessorClass", "()Ljava/lang/Class;", "executeCommand", "", "tableCommand", "Lcom/intellij/scientific/tables/api/TableCommand;", "tableCommandCodeProvider", "Lcom/intellij/scientific/tables/api/TableCommandCodeProvider;", "commandCode", "isExecutionAvailable", "", "notifyAsyncOutputLoaded", "", "addSessionListener", "listener", "removeSessionListener", "restoreOutputWithoutStaticTableData", "executeTableCommand", "Lorg/jetbrains/annotations/Nullable;", "commandText", "commandType", "Lcom/jetbrains/python/tables/TableCommandType;", "commandParameters", "Lcom/jetbrains/python/tables/TableCommandParameters;", "intellij.scientific.py.tables"})
public final class DSFrameAccessorCommandExecutor
implements DSTableCommandExecutor {
    @NotNull
    private final PyFrameAccessor frameAccessor;
    @NotNull
    private final List<DSSessionListener> listeners;

    public DSFrameAccessorCommandExecutor(@NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        this.frameAccessor = frameAccessor;
        this.listeners = new ArrayList();
        this.frameAccessor.addFrameListener(new PyFrameListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void frameChanged() {
                DSFrameAccessorCommandExecutor dSFrameAccessorCommandExecutor = this;
                DSFrameAccessorCommandExecutor dSFrameAccessorCommandExecutor2 = this;
                DSFrameAccessorCommandExecutor dSFrameAccessorCommandExecutor3 = dSFrameAccessorCommandExecutor;
                synchronized (dSFrameAccessorCommandExecutor3) {
                    boolean bl = false;
                    Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)dSFrameAccessorCommandExecutor2.listeners);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DSSessionListener it = (DSSessionListener)element$iv;
                        boolean bl2 = false;
                        it.frameChanged();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionStopped(PyFrameAccessor communication) {
                DSFrameAccessorCommandExecutor dSFrameAccessorCommandExecutor = this;
                DSFrameAccessorCommandExecutor dSFrameAccessorCommandExecutor2 = this;
                DSFrameAccessorCommandExecutor dSFrameAccessorCommandExecutor3 = dSFrameAccessorCommandExecutor;
                synchronized (dSFrameAccessorCommandExecutor3) {
                    boolean bl = false;
                    Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)dSFrameAccessorCommandExecutor2.listeners);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DSSessionListener it = (DSSessionListener)element$iv;
                        boolean bl2 = false;
                        it.sessionStopped();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    @NotNull
    public Class<?> getDataAccessorClass() {
        return this.frameAccessor.getClass();
    }

    @NotNull
    public String executeCommand(@NotNull TableCommand tableCommand, @NotNull TableCommandCodeProvider tableCommandCodeProvider) {
        String string;
        TableCommandType tableCommandType;
        Intrinsics.checkNotNullParameter((Object)tableCommand, (String)"tableCommand");
        Intrinsics.checkNotNullParameter((Object)tableCommandCodeProvider, (String)"tableCommandCodeProvider");
        TableCommand tableCommand2 = tableCommand;
        if (tableCommand2 instanceof DescribeTableCommand) {
            tableCommandType = TableCommandType.DF_DESCRIBE;
        } else if (tableCommand2 instanceof InfoTableCommand) {
            tableCommandType = TableCommandType.DF_INFO;
        } else if (tableCommand2 instanceof SliceTableCommand) {
            tableCommandType = Registry.Companion.get("tables.command.slice.mode").asBoolean() ? TableCommandType.SLICE_CSV : TableCommandType.SLICE;
        } else if (tableCommand2 instanceof VisualizationDataTableCommand) {
            tableCommandType = TableCommandType.VISUALIZATION_DATA;
        } else if (tableCommand2 instanceof ImageTableCommand) {
            tableCommandType = TableCommandType.IMAGE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TableCommandType commandType = tableCommandType;
        PyDevCommandParameters parameters = tableCommand instanceof SliceTableCommand ? new PyDevCommandParameters(((SliceTableCommand)tableCommand).getStartRow(), ((SliceTableCommand)tableCommand).getEndRow(), ((SliceTableCommand)tableCommand).getFormat()) : null;
        try {
            string = this.executeTableCommand(tableCommand.getTableVariable(), commandType, (TableCommandParameters)parameters);
        }
        catch (PyDebuggerException e) {
            throw new DSTableDataException(e.getMessage());
        }
        return string;
    }

    @NotNull
    public String executeCommand(@NotNull String commandCode) {
        Intrinsics.checkNotNullParameter((Object)commandCode, (String)"commandCode");
        return this.executeTableCommand(commandCode, TableCommandType.SLICE, null);
    }

    public boolean isExecutionAvailable() {
        return true;
    }

    public void notifyAsyncOutputLoaded() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(@NotNull DSSessionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        DSFrameAccessorCommandExecutor dSFrameAccessorCommandExecutor = this;
        synchronized (dSFrameAccessorCommandExecutor) {
            boolean bl = false;
            boolean bl2 = this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(@NotNull DSSessionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        DSFrameAccessorCommandExecutor dSFrameAccessorCommandExecutor = this;
        synchronized (dSFrameAccessorCommandExecutor) {
            boolean bl = false;
            boolean bl2 = this.listeners.remove(listener);
        }
    }

    public void restoreOutputWithoutStaticTableData() {
    }

    private final String executeTableCommand(String commandText, TableCommandType commandType, TableCommandParameters commandParameters) {
        String string = this.frameAccessor.execTableCommand(commandText, commandType, commandParameters);
        if (string == null) {
            string = "";
        }
        return string;
    }
}

