/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.ref.DjangoItemFilter;
import com.jetbrains.django.ref.DjangoItemReference;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DjangoModelReferenceSet
extends DjangoItemReferenceSet {
    public DjangoModelReferenceSet(PsiElement element) {
        super(element, DjangoItemFilter.CLASSES);
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        ArrayList contexts = Lists.newArrayList(super.getDefaultContexts());
        PyFileImpl file = (PyFileImpl)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyFileImpl.class);
        if (file != null) {
            contexts.add(file);
        }
        ArrayList arrayList = contexts;
        if (arrayList == null) {
            DjangoModelReferenceSet.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    protected DjangoItemReference createDjangoReference(TextRange range, int index, String subreferenceText, boolean isLast) {
        return new DjangoModelItemReference(range, index, subreferenceText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/django/codeInsight/DjangoModelReferenceSet", "getDefaultContexts"));
    }

    private final class DjangoModelItemReference
    extends DjangoItemReference {
        DjangoModelItemReference(TextRange range, int index, String subreferenceText) {
            super(DjangoModelReferenceSet.this, range, index, subreferenceText);
        }

        @Override
        protected boolean isAllowed(PsiElement child) {
            if (child instanceof PyClass) {
                return DjangoModel.isDjangoModelDescendant((PyClass)child, null);
            }
            return super.isAllowed(child);
        }

        @Override
        public PsiElement bindToElement(@NotNull PsiElement element) {
            PsiNamedElement namedElement;
            if (element == null) {
                DjangoModelItemReference.$$$reportNull$$$0(0);
            }
            if ((namedElement = (PsiNamedElement)PyUtil.as((Object)element, PsiNamedElement.class)) != null) {
                String appName;
                QualifiedName modelName = QualifiedName.fromDottedString((String)this.myReferenceSet.getText());
                if (namedElement instanceof PyClass && (appName = DjangoModelItemReference.getApplicationNameFromModel(modelName, (PyClass)namedElement)) != null) {
                    return this.rename(appName, namedElement.getName());
                }
                return super.bindToElement(element);
            }
            throw new IncorrectOperationException("Element does not have a name");
        }

        @Nullable
        private static String getApplicationNameFromModel(@NotNull QualifiedName qName, @NotNull PyClass model) {
            if (qName == null) {
                DjangoModelItemReference.$$$reportNull$$$0(1);
            }
            if (model == null) {
                DjangoModelItemReference.$$$reportNull$$$0(2);
            }
            if (qName.getComponentCount() != 2) {
                return null;
            }
            DjangoModelApi api = (DjangoModelApi)DjangoModelApi.create((PyElement)model).getSuccessOrNull();
            if (api == null) {
                return null;
            }
            String appName = qName.getFirstComponent();
            List<DjangoApplicationModel> applications = api.getApplications();
            if (applications.stream().map(o -> o.getLabel()).noneMatch(s -> s.equals(appName))) {
                return null;
            }
            TypeEvalContext context = TypeEvalContext.userInitiated((Project)model.getProject(), (PsiFile)model.getContainingFile());
            for (DjangoApplicationModel application : applications) {
                if (!ContainerUtil.exists(application.getModelClasses(context), o -> model.equals(o.getPyClass()))) continue;
                return application.getLabel();
            }
            return null;
        }

        @Override
        @NotNull
        protected Collection<PsiFileSystemItem> getContexts() {
            Collection<PsiFileSystemItem> contexts = super.getContexts();
            if (this.getContextReference() != null) {
                ArrayList<PsiFileSystemItem> results = new ArrayList<PsiFileSystemItem>();
                for (PsiFileSystemItem context : contexts) {
                    PyFile modelFile;
                    if (!(context instanceof PsiDirectory) || (modelFile = new DjangoUnnamedApplicationModel((PsiDirectory)context).getModel()) == null) continue;
                    results.add((PsiFileSystemItem)modelFile);
                }
                ArrayList<PsiFileSystemItem> arrayList = results;
                if (arrayList == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            Collection<PsiFileSystemItem> collection = contexts;
            if (collection == null) {
                DjangoModelItemReference.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @Override
        protected ResolveResult[] innerResolve(boolean caseSensitive) {
            QualifiedName appQName;
            Module module;
            if ("self".equals(this.getText())) {
                PyClass clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyClass.class);
                if (clazz != null) {
                    return new ResolveResult[]{DjangoModelItemReference.createResolveResult((PsiElement)clazz)};
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            if (this.isFirst() && !this.isLast() && (module = DjangoCoreUtil.getDjangoModule(this.getElement().getProject())) != null && (appQName = DjangoCoreUtil.appLabelToQName(module, this.getText())) != null) {
                List results = PyResolveImportUtil.resolveQualifiedName((QualifiedName)appQName, (PyQualifiedNameResolveContext)PyResolveImportUtil.fromModule((Module)module));
                ResolveResult[] resolveResults = new ResolveResult[results.size()];
                for (int i = 0; i < results.size(); ++i) {
                    resolveResults[i] = new PsiElementResolveResult((PsiElement)results.get(i));
                }
                return resolveResults;
            }
            ResolveResult[] results = super.innerResolve(caseSensitive);
            if (results.length > 0) {
                return results;
            }
            return (ResolveResult[])PyClassNameIndex.find((String)this.getText(), (Project)this.getElement().getProject(), (boolean)true).stream().map(PsiElementResolveResult::new).toArray(PsiElementResolveResult[]::new);
        }

        @Override
        public Object @NotNull [] getVariants() {
            Object[] res = super.getVariants();
            if (this.isFirst()) {
                ArrayList list = Lists.newArrayList((Object[])res);
                list.add(LookupElementBuilder.create((String)"self"));
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                if (module != null) {
                    for (String s : DjangoCoreUtil.getInstalledAppLabels(module)) {
                        list.add(LookupElementBuilder.create((String)s));
                    }
                    DjangoModelApi api = (DjangoModelApi)DjangoModelApi.create(module).getSuccessOrNull();
                    if (api != null) {
                        StreamEx.of(api.getModelClasses(TypeEvalContext.userInitiated((Project)this.getElement().getProject(), null))).map(DjangoModelClass::getPyClass).map(LookupElementBuilder::create).into((Collection)list);
                    }
                }
                res = list.toArray();
            }
            if (res == null) {
                DjangoModelItemReference.$$$reportNull$$$0(5);
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/django/codeInsight/DjangoModelReferenceSet$DjangoModelItemReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/django/codeInsight/DjangoModelReferenceSet$DjangoModelItemReference";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContexts";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getApplicationNameFromModel";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

