/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.django.facet.DjangoFacetTab;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.django.util.XStreamTools;
import com.jetbrains.python.psi.PyUtil;
import com.thoughtworks.xstream.XStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoFacetConfiguration
implements FacetConfiguration {
    private static final String ATTR_ROOT_FOLDER = "rootFolder";
    private static final String ATTR_SETTINGS = "settingsModule";
    private static final String ATTR_TRACK_FILES_PATTERN = "trackFilePattern";
    private static final String ATTR_MANAGE = "manageScript";
    private static final String DO_NOT_USER_TEST_RUNNER = "doNotUseTestRunner";
    private static final String ATTR_ENV = "environment";
    private String myProjectRootPath;
    private String mySettingsFilePath = "settings.py";
    private String myManageFilePath = "manage.py";
    private String myTrackFilePattern = "migrations";
    private boolean myDoNotUseTestRunner = false;
    private VirtualFile myProjectRootFolderFile;
    @NotNull
    private final Map<String, String> myEnvVariables = new HashMap<String, String>();

    public FacetEditorTab[] createEditorTabs(FacetEditorContext facetEditorContext, FacetValidatorsManager facetValidatorsManager) {
        return new FacetEditorTab[]{new DjangoFacetTab(this, facetEditorContext)};
    }

    public void readExternal(Element element) throws InvalidDataException {
        Map envAsMap;
        this.setProjectRootPath(JDOMExternalizerUtil.readField((Element)element, (String)ATTR_ROOT_FOLDER));
        this.setSettingsFilePath(JDOMExternalizerUtil.readField((Element)element, (String)ATTR_SETTINGS));
        this.setTrackFilePattern(JDOMExternalizerUtil.readField((Element)element, (String)ATTR_TRACK_FILES_PATTERN));
        this.setManageFilePath(JDOMExternalizerUtil.readField((Element)element, (String)ATTR_MANAGE));
        String doNotUseTestRunner = JDOMExternalizerUtil.readField((Element)element, (String)DO_NOT_USER_TEST_RUNNER);
        this.myDoNotUseTestRunner = Boolean.parseBoolean(doNotUseTestRunner);
        String envAsString = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_ENV);
        if (!StringUtil.isEmpty((String)envAsString) && (envAsMap = (Map)PyUtil.as((Object)DjangoFacetConfiguration.createXStream().fromXML(envAsString), Map.class)) != null) {
            this.setEnvVariables(envAsMap);
        }
    }

    @NotNull
    public String getTrackFilePattern() {
        String string = this.myTrackFilePattern;
        if (string == null) {
            DjangoFacetConfiguration.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setTrackFilePattern(String trackFilePattern) {
        if (trackFilePattern != null) {
            this.myTrackFilePattern = trackFilePattern;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_ROOT_FOLDER, (String)this.getProjectRootPath());
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_SETTINGS, (String)this.mySettingsFilePath);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_MANAGE, (String)this.myManageFilePath);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_ENV, (String)DjangoFacetConfiguration.createXStream().toXML(this.myEnvVariables));
        JDOMExternalizerUtil.writeField((Element)element, (String)DO_NOT_USER_TEST_RUNNER, (String)Boolean.toString(this.myDoNotUseTestRunner));
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_TRACK_FILES_PATTERN, (String)this.myTrackFilePattern);
    }

    @NotNull
    private static XStream createXStream() {
        XStream xStream = XStreamTools.createWithRootClass(Map.class, null);
        if (xStream == null) {
            DjangoFacetConfiguration.$$$reportNull$$$0(1);
        }
        return xStream;
    }

    public String getProjectRootPath() {
        return this.myProjectRootPath;
    }

    public void setProjectRootPath(@Nullable String root) {
        this.myProjectRootPath = root == null ? null : FileUtil.toSystemIndependentName((String)root);
    }

    public boolean doNotUseTestRunner() {
        return this.myDoNotUseTestRunner;
    }

    public void setDoNotUseTestRunner(boolean doNotUseTestRunner) {
        this.myDoNotUseTestRunner = doNotUseTestRunner;
    }

    @NotNull
    public String getSettingsFilePath() {
        String string = this.mySettingsFilePath;
        if (string == null) {
            DjangoFacetConfiguration.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setSettingsFilePath(@Nullable String settingsFile) {
        this.mySettingsFilePath = settingsFile == null ? "settings.py" : settingsFile;
    }

    @NotNull
    public String getManageFilePath() {
        String string = this.myManageFilePath;
        if (string == null) {
            DjangoFacetConfiguration.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setManageFilePath(@Nullable String manageFilePath) {
        this.myManageFilePath = manageFilePath == null ? "manage.py" : manageFilePath;
    }

    @Nullable
    public String getProjectName() {
        VirtualFile root = this.getProjectRootFolderFile();
        return root != null ? root.getName() : null;
    }

    @Nullable
    public VirtualFile getProjectRootFolderFile() {
        if (this.myProjectRootFolderFile != null && this.myProjectRootFolderFile.isValid()) {
            return this.myProjectRootFolderFile;
        }
        if (StringUtil.isEmpty((String)this.myProjectRootPath)) {
            return null;
        }
        return VirtualFileUtil.findFile(this.myProjectRootPath);
    }

    public void setProjectRootFolderFile(VirtualFile file) {
        this.myProjectRootFolderFile = file;
        this.setProjectRootPath(file == null ? "" : file.getPath());
    }

    public void setEnvVariables(@NotNull Map<String, String> envVariables) {
        if (envVariables == null) {
            DjangoFacetConfiguration.$$$reportNull$$$0(4);
        }
        this.myEnvVariables.clear();
        this.myEnvVariables.putAll(envVariables);
    }

    @NotNull
    public Map<String, String> getEnvVariables() {
        Map<String, String> map = Collections.unmodifiableMap(this.myEnvVariables);
        if (map == null) {
            DjangoFacetConfiguration.$$$reportNull$$$0(5);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/facet/DjangoFacetConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackFilePattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createXStream";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getManageFilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/facet/DjangoFacetConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setEnvVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }
}

