/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;

public abstract class TExtensibleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private TProcessor processor;
    private TProtocolFactory inFactory;
    private Collection<Map.Entry<String, String>> customHeaders;

    protected abstract TProcessor getProcessor();

    protected abstract TProtocolFactory getInProtocolFactory();

    protected abstract TProtocolFactory getOutProtocolFactory();

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.processor = this.getProcessor();
        this.inFactory = this.getInProtocolFactory();
        TProtocolFactory outFactory = this.getOutProtocolFactory();
        this.customHeaders = new ArrayList<Map.Entry<String, String>>();
        if (this.processor == null) {
            throw new ServletException("processor must be set");
        }
        if (this.inFactory == null) {
            throw new ServletException("inFactory must be set");
        }
        if (outFactory == null) {
            throw new ServletException("outFactory must be set");
        }
    }

    protected void doPost(HttpServletRequest request2, HttpServletResponse response) throws ServletException, IOException {
        try {
            TIOStreamTransport transport;
            response.setContentType("application/x-thrift");
            if (null != this.customHeaders) {
                for (Map.Entry<String, String> header : this.customHeaders) {
                    response.addHeader(header.getKey(), header.getValue());
                }
            }
            ServletInputStream in = request2.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            TIOStreamTransport inTransport = transport = new TIOStreamTransport((InputStream)in, (OutputStream)out);
            TIOStreamTransport outTransport = transport;
            TProtocol inProtocol = this.inFactory.getProtocol(inTransport);
            TProtocol outProtocol = this.inFactory.getProtocol(outTransport);
            this.processor.process(inProtocol, outProtocol);
            out.flush();
        }
        catch (TException te) {
            throw new ServletException((Throwable)te);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void addCustomHeader(final String key, final String value2) {
        this.customHeaders.add(new Map.Entry<String, String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue() {
                return value2;
            }

            @Override
            public String setValue(String value22) {
                return null;
            }
        });
    }

    public void setCustomHeaders(Collection<Map.Entry<String, String>> headers) {
        this.customHeaders.clear();
        this.customHeaders.addAll(headers);
    }
}

