/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.xmlrpc.CommonsXmlRpcTransport;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcTransport;
import org.apache.xmlrpc.XmlRpcTransportFactory;

public class CommonsXmlRpcTransportFactory
implements XmlRpcTransportFactory {
    private URL url;
    private String auth;
    private Integer timeout;
    private Integer connectionTimeout;

    public CommonsXmlRpcTransportFactory(URL pURL) {
        this.url = pURL;
    }

    public XmlRpcTransport createTransport() throws XmlRpcClientException {
        HttpClient client = new HttpClient();
        CommonsXmlRpcTransport transport = new CommonsXmlRpcTransport(this.url, client);
        if (this.auth != null) {
            transport.setBasicAuthentication(this.auth);
        }
        if (this.timeout != null) {
            transport.setTimeout(this.timeout);
        }
        if (this.connectionTimeout != null) {
            transport.setConnectionTimeout(this.connectionTimeout);
        }
        return transport;
    }

    public void setBasicAuthentication(String pAuth) {
        this.auth = pAuth;
    }

    public void setBasicAuthentication(String pUsername, String pPassword) {
        this.auth = pUsername + ":" + pPassword;
    }

    public void setTimeout(int newTimeoutInMilliSeconds) {
        this.timeout = new Integer(newTimeoutInMilliSeconds);
    }

    public void setConnectionTimeout(int newConnectionTimeoutInMilliSeconds) {
        this.connectionTimeout = new Integer(newConnectionTimeoutInMilliSeconds);
    }

    public void setProperty(String propertyName, Object value2) {
        if ("auth".equals(propertyName)) {
            this.auth = (String)value2;
        } else if ("url".equals(propertyName)) {
            this.url = (URL)value2;
        }
    }
}

