/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.httpClient.actions.generation.HttpRequestUrlContextError;
import com.intellij.httpClient.actions.generation.RequestUrlContextInfo;
import com.intellij.httpClient.actions.generation.UrlChecker;
import com.intellij.httpClient.executor.util.PartialResult;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB%\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u0002\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo;", "", "schemes", "", "", "authorities", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getSchemes", "()Ljava/util/List;", "getAuthorities", "authoritiesWithScheme", "", "getAuthoritiesWithScheme", "()Ljava/lang/Iterable;", "onlyOneAuthorityWithScheme", "", "getOnlyOneAuthorityWithScheme", "()Z", "equals", "other", "hashCode", "", "toString", "NonHttpRequestUrlContextInfo", "HttpRequestUrlContextInfo", "Companion", "Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo$HttpRequestUrlContextInfo;", "Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo$NonHttpRequestUrlContextInfo;", "intellij.restClient"})
public abstract class RequestUrlContextInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final List<String> authorities;
    @NotNull
    private static final List<String> LOCALHOST;
    @NotNull
    private static final RequestUrlContextInfo DEFAULT_CONTEXT;

    private RequestUrlContextInfo(List<String> schemes, List<String> authorities) {
        this.schemes = schemes;
        this.authorities = authorities;
    }

    @NotNull
    public final List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public final List<String> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public final Iterable<String> getAuthoritiesWithScheme() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.schemes), arg_0 -> RequestUrlContextInfo._get_authoritiesWithScheme_$lambda$1(this, arg_0)));
    }

    public final boolean getOnlyOneAuthorityWithScheme() {
        return this.schemes.size() == 1 && this.authorities.size() == 1;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.httpClient.actions.generation.RequestUrlContextInfo");
        RequestUrlContextInfo cfr_ignored_0 = (RequestUrlContextInfo)other;
        if (!Intrinsics.areEqual(this.schemes, ((RequestUrlContextInfo)other).schemes)) {
            return false;
        }
        return Intrinsics.areEqual(this.authorities, ((RequestUrlContextInfo)other).authorities);
    }

    public int hashCode() {
        int result2 = ((Object)this.schemes).hashCode();
        result2 = 31 * result2 + ((Object)this.authorities).hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "HttpGenerationContext(schemes=" + this.schemes + ", authorities=" + this.authorities + ")";
    }

    private static final String _get_authoritiesWithScheme_$lambda$1$lambda$0(String $scheme, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $scheme + it;
    }

    private static final Sequence _get_authoritiesWithScheme_$lambda$1(RequestUrlContextInfo this$0, String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this$0.authorities), arg_0 -> RequestUrlContextInfo._get_authoritiesWithScheme_$lambda$1$lambda$0(scheme, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final RequestUrlContextInfo notEmpty(@Nullable RequestUrlContextInfo $this$notEmpty) {
        return Companion.notEmpty($this$notEmpty);
    }

    public /* synthetic */ RequestUrlContextInfo(List schemes, List authorities, DefaultConstructorMarker $constructor_marker) {
        this(schemes, authorities);
    }

    static {
        Object[] objectArray = new String[]{"localhost", "127.0.0.1", "localhost:8080", "127.0.0.1:8080"};
        LOCALHOST = CollectionsKt.listOf((Object[])objectArray);
        DEFAULT_CONTEXT = new HttpRequestUrlContextInfo(UrlConstants.HTTP_SCHEMES, LOCALHOST);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ6\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJl\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2$\u0010\u0011\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u0006*\u0004\u0018\u00010\u0006H\u0007JN\u0010\u0014\u001a\u00020\u0006*\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2$\u0010\u0011\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J\u0017\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\f0\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\fH\u0002R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo$Companion;", "", "<init>", "()V", "createNonHttp", "Lcom/intellij/httpClient/executor/util/PartialResult;", "Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlContextError;", "project", "Lcom/intellij/openapi/project/Project;", "schemes", "", "", "authorities", "create", "validSchemes", "wrongSchemes", "instantiator", "Lkotlin/Function2;", "notEmpty", "ensureNotEmpty", "defaultSchemes", "defaultAuthorities", "LOCALHOST", "DEFAULT_CONTEXT", "getDEFAULT_CONTEXT", "()Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo;", "hasAvailableSchemesByDefault", "", "", "hasAvailableSchemesByDefault$intellij_restClient", "isAvailableSchemaByDefault", "schema", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestGenerationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestGenerationUtil.kt\ncom/intellij/httpClient/actions/generation/RequestUrlContextInfo$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n3193#2,10:347\n3193#2,10:357\n1734#2,3:367\n*S KotlinDebug\n*F\n+ 1 HttpRequestGenerationUtil.kt\ncom/intellij/httpClient/actions/generation/RequestUrlContextInfo$Companion\n*L\n111#1:347,10\n126#1:357,10\n171#1:367,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PartialResult<RequestUrlContextInfo, HttpRequestUrlContextError> createNonHttp(@NotNull Project project, @NotNull List<String> schemes, @NotNull List<String> authorities) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
            return this.create(project, schemes, CollectionsKt.emptyList(), authorities, (Function2<? super List<String>, ? super List<String>, ? extends RequestUrlContextInfo>)((Function2)createNonHttp.1.INSTANCE));
        }

        public static /* synthetic */ PartialResult createNonHttp$default(Companion companion, Project project, List list2, List list3, int n, Object object) {
            if ((n & 2) != 0) {
                list2 = CollectionsKt.listOf((Object)"");
            }
            if ((n & 4) != 0) {
                list3 = CollectionsKt.listOf((Object)"");
            }
            return companion.createNonHttp(project, list2, list3);
        }

        @NotNull
        public final PartialResult<RequestUrlContextInfo, HttpRequestUrlContextError> create(@NotNull Project project, @NotNull List<String> schemes, @NotNull List<String> authorities) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
            Iterable $this$partition$iv = schemes;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = !Companion.isAvailableSchemaByDefault(it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List wrongSchemes = (List)pair.component1();
            List validSchemes = (List)pair.component2();
            if (!((Collection)schemes).isEmpty() && wrongSchemes.size() == schemes.size()) {
                return new PartialResult.Error<HttpRequestUrlContextError>(new HttpRequestUrlContextError(wrongSchemes, null, 2, null));
            }
            return this.create(project, validSchemes, wrongSchemes, authorities, (Function2<? super List<String>, ? super List<String>, ? extends RequestUrlContextInfo>)((Function2)create.2.INSTANCE));
        }

        private final PartialResult<RequestUrlContextInfo, HttpRequestUrlContextError> create(Project project, List<String> validSchemes, List<String> wrongSchemes, List<String> authorities, Function2<? super List<String>, ? super List<String>, ? extends RequestUrlContextInfo> instantiator) {
            Iterable $this$partition$iv = authorities;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = UrlChecker.isValidRequest$default(UrlChecker.INSTANCE, project, null, it, 2, null) ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List validAuthorities = (List)pair.component1();
            List wrongAuthorities = (List)pair.component2();
            if (!((Collection)authorities).isEmpty() && wrongAuthorities.size() == authorities.size()) {
                return new PartialResult.Error<HttpRequestUrlContextError>(new HttpRequestUrlContextError(null, wrongAuthorities, 1, null));
            }
            RequestUrlContextInfo result2 = (RequestUrlContextInfo)instantiator.invoke(validSchemes, (Object)validAuthorities);
            return wrongSchemes.isEmpty() && wrongAuthorities.isEmpty() ? (PartialResult)new PartialResult.Success<RequestUrlContextInfo>(result2) : (PartialResult)new PartialResult.PartialSuccess<RequestUrlContextInfo, HttpRequestUrlContextError>(result2, new HttpRequestUrlContextError(wrongSchemes, wrongAuthorities));
        }

        @JvmStatic
        @NotNull
        public final RequestUrlContextInfo notEmpty(@Nullable RequestUrlContextInfo $this$notEmpty) {
            RequestUrlContextInfo requestUrlContextInfo = $this$notEmpty;
            return requestUrlContextInfo instanceof HttpRequestUrlContextInfo ? this.ensureNotEmpty($this$notEmpty, UrlConstants.HTTP_SCHEMES, LOCALHOST, (Function2<? super List<String>, ? super List<String>, ? extends RequestUrlContextInfo>)((Function2)notEmpty.1.INSTANCE)) : (requestUrlContextInfo instanceof NonHttpRequestUrlContextInfo ? this.ensureNotEmpty($this$notEmpty, CollectionsKt.listOf((Object)""), LOCALHOST, (Function2<? super List<String>, ? super List<String>, ? extends RequestUrlContextInfo>)((Function2)notEmpty.2.INSTANCE)) : this.getDEFAULT_CONTEXT());
        }

        private final RequestUrlContextInfo ensureNotEmpty(RequestUrlContextInfo $this$ensureNotEmpty, List<String> defaultSchemes, List<String> defaultAuthorities, Function2<? super List<String>, ? super List<String>, ? extends RequestUrlContextInfo> instantiator) {
            if (!((Collection)$this$ensureNotEmpty.getSchemes()).isEmpty() && !((Collection)$this$ensureNotEmpty.getAuthorities()).isEmpty()) {
                return $this$ensureNotEmpty;
            }
            if (!((Collection)$this$ensureNotEmpty.getSchemes()).isEmpty()) {
                return (RequestUrlContextInfo)instantiator.invoke($this$ensureNotEmpty.getSchemes(), defaultAuthorities);
            }
            if (!((Collection)$this$ensureNotEmpty.getAuthorities()).isEmpty()) {
                return (RequestUrlContextInfo)instantiator.invoke(defaultSchemes, $this$ensureNotEmpty.getAuthorities());
            }
            return (RequestUrlContextInfo)instantiator.invoke(defaultSchemes, defaultAuthorities);
        }

        @NotNull
        public final RequestUrlContextInfo getDEFAULT_CONTEXT() {
            return DEFAULT_CONTEXT;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasAvailableSchemesByDefault$intellij_restClient(@NotNull Collection<String> $this$hasAvailableSchemesByDefault) {
            String p0;
            Intrinsics.checkNotNullParameter($this$hasAvailableSchemesByDefault, (String)"<this>");
            if ($this$hasAvailableSchemesByDefault.isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            Iterable $this$all$iv = $this$hasAvailableSchemesByDefault;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                p0 = (String)element$iv;
                boolean bl2 = false;
            } while (this.isAvailableSchemaByDefault(p0));
            return false;
        }

        private final boolean isAvailableSchemaByDefault(String schema) {
            return UrlConstants.HTTP_SCHEMES.contains(schema) || UrlConstants.WS_SCHEMES.contains(schema);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo$HttpRequestUrlContextInfo;", "Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo;", "schemes", "", "", "authorities", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "intellij.restClient"})
    private static final class HttpRequestUrlContextInfo
    extends RequestUrlContextInfo {
        public HttpRequestUrlContextInfo(@NotNull List<String> schemes, @NotNull List<String> authorities) {
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
            super(schemes, authorities, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo$NonHttpRequestUrlContextInfo;", "Lcom/intellij/httpClient/actions/generation/RequestUrlContextInfo;", "schemes", "", "", "authorities", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "intellij.restClient"})
    private static final class NonHttpRequestUrlContextInfo
    extends RequestUrlContextInfo {
        public NonHttpRequestUrlContextInfo(@NotNull List<String> schemes, @NotNull List<String> authorities) {
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
            super(schemes, authorities, null);
        }
    }
}

