/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpRequestRuntimeConfigurationProducer
extends LazyRunConfigurationProducer<HttpRequestRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = HttpRequestRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfigurationWithDefaultEnv(@NotNull ConfigurationContext context2) {
        if (context2 == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(1);
        }
        RunManager runManager = RunManager.getInstance((Project)context2.getProject());
        List configurations = this.getConfigurationSettingsList(runManager);
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            if (!this.checkExistingConfiguration(configurationSettings.getConfiguration(), context2)) continue;
            return configurationSettings;
        }
        return null;
    }

    protected abstract boolean checkExistingConfiguration(@Nullable RunConfiguration var1, @NotNull ConfigurationContext var2);

    protected static int getExecutionIndex(@NotNull HttpClientExecutionBlock executionBlock) {
        if (executionBlock == null) {
            HttpRequestRuntimeConfigurationProducer.$$$reportNull$$$0(2);
        }
        HttpClientExecutionBlock[] blocks = HttpRequestPsiUtils.getExecutionBlocks(executionBlock.getContainingFile());
        for (int i = 0; i < blocks.length; ++i) {
            HttpClientExecutionBlock block = blocks[i];
            if (block != executionBlock) continue;
            return i + 1;
        }
        return -1;
    }

    @Nullable
    protected static HttpClientExecutionBlock findHttpExecutionElement(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        if (element instanceof PsiDirectory || !(element.getContainingFile() instanceof HttpRequestPsiFile)) {
            return null;
        }
        if (element instanceof PsiFile) {
            HttpClientExecutionBlock[] blocks = HttpRequestPsiUtils.getExecutionBlocks((PsiFile)element);
            return blocks.length == 1 ? blocks[0] : null;
        }
        PsiElement psi = element instanceof PsiWhiteSpace ? (PsiElement)ObjectUtils.chooseNotNull((Object)element.getPrevSibling(), (Object)element) : element;
        return (HttpClientExecutionBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{HttpClientExecutionBlock.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/config/HttpRequestRuntimeConfigurationProducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpRequestRuntimeConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExistingConfigurationWithDefaultEnv";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExecutionIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

