/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.ErrorFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.ErrorStackTraceLimitNode;
import com.oracle.truffle.js.nodes.access.InitErrorObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ErrorFunctionBuiltins
extends JSBuiltinsContainer.Lambda {
    public static final JSBuiltinsContainer BUILTINS = new ErrorFunctionBuiltins();

    protected ErrorFunctionBuiltins() {
        super(JSError.CLASS_NAME);
        this.defineFunction(Strings.CAPTURE_STACK_TRACE, 2, JSAttributes.getDefault(), (context2, builtin) -> ErrorFunctionBuiltinsFactory.ErrorCaptureStackTraceNodeGen.create(context2, builtin, ErrorFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context2)));
    }

    public static abstract class ErrorCaptureStackTraceNode
    extends JSBuiltinNode {
        @Node.Child
        private ErrorStackTraceLimitNode stackTraceLimitNode;
        @Node.Child
        private InitErrorObjectNode initErrorObjectNode;

        public ErrorCaptureStackTraceNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.initErrorObjectNode = InitErrorObjectNode.create(context2);
            this.stackTraceLimitNode = ErrorStackTraceLimitNode.create();
        }

        @Specialization
        protected Object captureStackTrace(VirtualFrame frame, Object object, Object skipUpTo, @Cached InlinedBranchProfile errorProfile) {
            if (!JSRuntime.isObject(object)) {
                errorProfile.enter(this);
                throw Errors.createTypeError("invalid_argument");
            }
            JSObject obj = (JSObject)object;
            if (!JSObject.isExtensible(obj)) {
                errorProfile.enter(this);
                throw Errors.createTypeError("Cannot define property:stack, object is not extensible.");
            }
            int stackTraceLimit = this.stackTraceLimitNode.executeInt();
            boolean customSkip = JSFunction.isJSFunction(skipUpTo);
            JSFunctionObject skipFramesUpTo = customSkip ? (JSFunctionObject)skipUpTo : (JSFunctionObject)JSArguments.getFunctionObject(frame.getArguments());
            UserScriptException ex = UserScriptException.createCapture(obj, this.getContext().isOptionNashornCompatibilityMode() ? this : null, stackTraceLimit, skipFramesUpTo, customSkip);
            this.initErrorObjectNode.execute(obj, ex, null);
            return Undefined.instance;
        }

        @Override
        public boolean countsTowardsStackTraceLimit() {
            return false;
        }
    }
}

