/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class AsinhNode
extends MathOperation {
    public AsinhNode(JSContext context2, JSBuiltin builtin) {
        super(context2, builtin);
    }

    @Specialization
    protected double asinhDouble(double x, @Cached @Cached.Shared(value="isNegative") InlinedConditionProfile isNegative) {
        if (JSRuntime.isNegativeZero(x)) {
            return -0.0;
        }
        if (x < 0.0 && Double.isInfinite(x)) {
            return x;
        }
        if (isNegative.profile(this, x < 0.0)) {
            return -AsinhNode.asinhImpl(-x);
        }
        return AsinhNode.asinhImpl(x);
    }

    private static double asinhImpl(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    @Specialization
    protected double asinhGeneric(Object a, @Cached @Cached.Shared(value="isNegative") InlinedConditionProfile isNegative) {
        return this.asinhDouble(this.toDouble(a), isNegative);
    }
}

