/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorNextNodeGen;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;

@GenerateUncached
public abstract class IteratorNextNode
extends JavaScriptBaseNode {
    protected IteratorNextNode() {
    }

    public final Object execute(IteratorRecord iteratorRecord, Object value2) {
        return this.execute(iteratorRecord, value2, true);
    }

    public final Object execute(IteratorRecord iteratorRecord) {
        return this.execute(iteratorRecord, null, false);
    }

    protected abstract Object execute(IteratorRecord var1, Object var2, boolean var3);

    @Specialization
    protected final Object iteratorNext(IteratorRecord iteratorRecord, Object value2, boolean passValue, @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode methodCallNode, @Cached IsObjectNode isObjectNode, @Cached InlinedBranchProfile errorBranch) {
        Object nextMethod = iteratorRecord.getNextMethod();
        Object iterator = iteratorRecord.getIterator();
        Object result2 = methodCallNode.executeCall(passValue ? JSArguments.createOneArg(iterator, nextMethod, value2) : JSArguments.createZeroArg(iterator, nextMethod));
        if (!isObjectNode.executeBoolean(result2)) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorIteratorResultNotObject(result2, this);
        }
        return result2;
    }

    @NeverDefault
    public static IteratorNextNode create() {
        return IteratorNextNodeGen.create();
    }

    @NeverDefault
    public static IteratorNextNode getUncached() {
        return IteratorNextNodeGen.getUncached();
    }
}

