/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class JSToLengthNode
extends JavaScriptBaseNode {
    @NeverDefault
    public static JSToLengthNode create() {
        return JSToLengthNodeGen.create();
    }

    public abstract long executeLong(Object var1);

    @Specialization
    protected final long doInt(int value2, @Cached @Cached.Shared(value="negativeBranch") InlinedBranchProfile negativeBranch) {
        if (value2 < 0) {
            negativeBranch.enter(this);
            return 0L;
        }
        return value2;
    }

    @Specialization
    protected final long doSafeInteger(SafeInteger value2, @Cached @Cached.Shared(value="negativeBranch") InlinedBranchProfile negativeBranch) {
        long longValue = value2.longValue();
        if (longValue < 0L) {
            negativeBranch.enter(this);
            return 0L;
        }
        return longValue;
    }

    @Specialization
    protected final long doDouble(double value2, @Cached @Cached.Shared(value="negativeBranch") InlinedBranchProfile negativeBranch, @Cached @Cached.Shared(value="tooLargeBranch") InlinedBranchProfile tooLargeBranch) {
        return this.doLong((long)value2, negativeBranch, tooLargeBranch);
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static long doUndefined(Object value2) {
        return 0L;
    }

    @Specialization
    protected final long doObject(Object value2, @Cached JSToNumberNode toNumberNode, @Cached @Cached.Shared(value="negativeBranch") InlinedBranchProfile negativeBranch, @Cached @Cached.Shared(value="tooLargeBranch") InlinedBranchProfile tooLargeBranch) {
        Number result2 = (Number)toNumberNode.execute(value2);
        return this.doLong(JSRuntime.toInteger(result2), negativeBranch, tooLargeBranch);
    }

    private long doLong(long value2, InlinedBranchProfile negativeBranch, InlinedBranchProfile tooLargeBranch) {
        if (value2 < 0L) {
            negativeBranch.enter(this);
            return 0L;
        }
        if (value2 > JSRuntime.MAX_SAFE_INTEGER_LONG) {
            tooLargeBranch.enter(this);
            return JSRuntime.MAX_SAFE_INTEGER_LONG;
        }
        return value2;
    }
}

